/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSRunContainerObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSSubItemObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSContentProvider;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSDefinitionPage;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSEditorContributor;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleMessages;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleCSAddStepAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleCSAddSubStepAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleCSPreviewAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleCSRemoveRunObjectAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleCSRemoveStepAction;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.actions.SimpleCSRemoveSubStepAction;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SimpleCSMasterTreeSection
extends TreeSection
implements ICSMaster {
    private static final int F_BUTTON_ADD_STEP = 0;
    private static final int F_BUTTON_ADD_SUBSTEP = 1;
    private static final int F_BUTTON_REMOVE = 4;
    private static final int F_BUTTON_UP = 5;
    private static final int F_BUTTON_DOWN = 6;
    private static final int F_BUTTON_PREVIEW = 9;
    private static final int F_UP_FLAG = -1;
    private static final int F_DOWN_FLAG = 1;
    private TreeViewer fTreeViewer;
    private ISimpleCSModel fModel;
    private SimpleCSAddStepAction fAddStepAction;
    private SimpleCSRemoveStepAction fRemoveStepAction;
    private SimpleCSRemoveSubStepAction fRemoveSubStepAction;
    private SimpleCSAddSubStepAction fAddSubStepAction;
    private SimpleCSRemoveRunObjectAction fRemoveRunObjectAction;
    private CollapseAction fCollapseAction;
    private ControlDecoration fSubStepInfoDecoration;

    public SimpleCSMasterTreeSection(PDEFormPage formPage, Composite parent) {
        String[] stringArray = new String[10];
        stringArray[0] = SimpleMessages.SimpleCSMasterTreeSection_addStep;
        stringArray[1] = SimpleMessages.SimpleCSMasterTreeSection_addSubStep;
        stringArray[4] = SimpleMessages.SimpleCSMasterTreeSection_remove;
        stringArray[5] = SimpleMessages.SimpleCSMasterTreeSection_up;
        stringArray[6] = SimpleMessages.SimpleCSMasterTreeSection_down;
        stringArray[9] = SimpleMessages.SimpleCSMasterTreeSection_preview;
        super(formPage, parent, 128, stringArray);
        this.fAddStepAction = new SimpleCSAddStepAction();
        this.fRemoveStepAction = new SimpleCSRemoveStepAction();
        this.fRemoveSubStepAction = new SimpleCSRemoveSubStepAction();
        this.fAddSubStepAction = new SimpleCSAddSubStepAction();
        this.fRemoveRunObjectAction = new SimpleCSRemoveRunObjectAction();
        this.fCollapseAction = null;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISimpleCSModel)this.getPage().getModel();
        section.setText(SimpleMessages.SimpleCSMasterTreeSection_sectionTitle);
        section.setDescription(SimpleMessages.SimpleCSMasterTreeSection_sectionDescription);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fTreeViewer, SimpleMessages.SimpleCSMasterTreeSection_collapseAll, 1, (Object)this.fModel.getSimpleCS());
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void initializeTreeViewer() {
        ISelection selection = this.fTreeViewer.getSelection();
        if (this.fModel == null) {
            return;
        }
        this.fTreeViewer.setInput((Object)this.fModel);
        this.getTreePart().setButtonEnabled(0, this.fModel.isEditable());
        this.getTreePart().setButtonEnabled(1, false);
        this.getTreePart().setButtonEnabled(4, false);
        this.getTreePart().setButtonEnabled(5, false);
        this.getTreePart().setButtonEnabled(6, false);
        this.getTreePart().setButtonEnabled(9, true);
        this.fTreeViewer.setSelection(selection, true);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 4, 2, toolkit);
        this.fTreeViewer = treePart.getTreeViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new SimpleCSContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)PDEUserAssistanceUIPlugin.getDefault().getLabelProvider());
        PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().connect(this);
        this.createTreeListeners();
        this.createSubStepInfoDecoration();
    }

    protected boolean isDragAndDropEnabled() {
        return true;
    }

    public boolean canDragMove(Object[] sourceObjects) {
        if (!this.validatePaste(sourceObjects)) {
            return false;
        }
        StructuredSelection selection = new StructuredSelection(sourceObjects);
        return this.canCut((ISelection)selection);
    }

    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        ISimpleCSModel targetModel;
        if (!this.validatePaste(targetObject, sourceObjects)) {
            return false;
        }
        ISimpleCSObject sourceCSObject = (ISimpleCSObject)sourceObjects[0];
        ISimpleCSObject targetCSObject = (ISimpleCSObject)targetObject;
        ISimpleCSModel sourceModel = sourceCSObject.getModel();
        if (!sourceModel.equals(targetModel = targetCSObject.getModel())) {
            return false;
        }
        if (sourceCSObject.getType() == 6) {
            ISimpleCSItem sourceItem = (ISimpleCSItem)sourceCSObject;
            if (targetCSObject.getType() == 0) {
                ISimpleCS targetCheatSheet = (ISimpleCS)targetCSObject;
                return this.canDropMove(targetCheatSheet, sourceItem, targetLocation);
            }
            if (targetCSObject.getType() == 6) {
                ISimpleCSItem targetItem = (ISimpleCSItem)targetCSObject;
                return this.canDropMove(targetItem, sourceItem, targetLocation);
            }
            if (targetCSObject.getType() == 5) {
                ISimpleCSIntro targetIntro = (ISimpleCSIntro)targetCSObject;
                return this.canDropMove(targetIntro, sourceItem, targetLocation);
            }
        } else if (sourceCSObject.getType() == 10) {
            ISimpleCSSubItem sourceSubItem = (ISimpleCSSubItem)sourceCSObject;
            if (targetCSObject.getType() == 6) {
                ISimpleCSItem targetItem = (ISimpleCSItem)targetCSObject;
                return this.canDropMove(targetItem, sourceSubItem, targetLocation);
            }
            if (targetCSObject.getType() == 10 && targetCSObject.getParent().getType() == 6) {
                ISimpleCSSubItem targetSubItem = (ISimpleCSSubItem)targetCSObject;
                return this.canDropMove(targetSubItem, sourceSubItem, targetLocation);
            }
        }
        return false;
    }

    private boolean canDropMove(ISimpleCS targetCheatSheet, ISimpleCSItem sourceItem, int targetLocation) {
        if (targetLocation == 1) {
            return false;
        }
        if (targetLocation == 2) {
            return false;
        }
        if (targetLocation == 3) {
            return !targetCheatSheet.isLastItem(sourceItem);
        }
        return false;
    }

    private boolean canDropMove(ISimpleCSItem targetItem, ISimpleCSItem sourceItem, int targetLocation) {
        ISimpleCS parent = targetItem.getSimpleCS();
        if (targetLocation == 1) {
            IDocumentElementNode previousNode = parent.getPreviousSibling((IDocumentElementNode)targetItem, ISimpleCSItem.class);
            return !sourceItem.equals(previousNode);
        }
        if (targetLocation == 2) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetItem, ISimpleCSItem.class);
            return !sourceItem.equals(nextNode);
        }
        if (targetLocation == 3) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetItem, ISimpleCSItem.class);
            return !sourceItem.equals(nextNode);
        }
        return false;
    }

    private boolean canDropMove(ISimpleCSIntro targetIntro, ISimpleCSItem sourceItem, int targetLocation) {
        ISimpleCS parent = targetIntro.getSimpleCS();
        if (targetLocation == 1) {
            return false;
        }
        if (targetLocation == 2) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetIntro, ISimpleCSItem.class);
            return !sourceItem.equals(nextNode);
        }
        if (targetLocation == 3) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetIntro, ISimpleCSItem.class);
            return !sourceItem.equals(nextNode);
        }
        return false;
    }

    private boolean canDropMove(ISimpleCSItem targetItem, ISimpleCSSubItem sourceSubItem, int targetLocation) {
        if (targetLocation == 1) {
            return false;
        }
        if (targetLocation == 2) {
            if (targetItem.getExecutable() != null) {
                return false;
            }
            return !targetItem.isFirstSubItem((ISimpleCSSubItemObject)sourceSubItem);
        }
        if (targetLocation == 3) {
            if (targetItem.getExecutable() != null) {
                return false;
            }
            return !targetItem.isLastSubItem((ISimpleCSSubItemObject)sourceSubItem);
        }
        return false;
    }

    private boolean canDropMove(ISimpleCSSubItem targetSubItem, ISimpleCSSubItem sourceSubItem, int targetLocation) {
        ISimpleCSItem parent = (ISimpleCSItem)targetSubItem.getParent();
        if (targetLocation == 1) {
            IDocumentElementNode previousNode = parent.getPreviousSibling((IDocumentElementNode)targetSubItem, ISimpleCSSubItem.class);
            return !sourceSubItem.equals(previousNode);
        }
        if (targetLocation == 2) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetSubItem, ISimpleCSSubItem.class);
            return !sourceSubItem.equals(nextNode);
        }
        if (targetLocation == 3) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetSubItem, ISimpleCSSubItem.class);
            return !sourceSubItem.equals(nextNode);
        }
        return false;
    }

    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validatePaste(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        ISimpleCSObject sourceCSObject = (ISimpleCSObject)sourceObjects[0];
        ISimpleCSObject targetCSObject = (ISimpleCSObject)targetObject;
        if (sourceCSObject.getType() == 6) {
            ISimpleCSItem sourceItem = (ISimpleCSItem)sourceCSObject;
            if (targetCSObject.getType() == 0) {
                ISimpleCS targetCheatSheet = (ISimpleCS)targetCSObject;
                this.doDropMove(targetCheatSheet, sourceItem, targetLocation);
            } else if (targetCSObject.getType() == 6) {
                ISimpleCSItem targetItem = (ISimpleCSItem)targetCSObject;
                this.doDropMove(targetItem, sourceItem, targetLocation);
            } else if (targetCSObject.getType() == 5) {
                ISimpleCSIntro targetIntro = (ISimpleCSIntro)targetCSObject;
                this.doDropMove(targetIntro, sourceItem, targetLocation);
            }
        } else if (sourceCSObject.getType() == 10) {
            ISimpleCSSubItem sourceSubItem = (ISimpleCSSubItem)sourceCSObject;
            if (targetCSObject.getType() == 6) {
                ISimpleCSItem targetItem = (ISimpleCSItem)targetCSObject;
                this.doDropMove(targetItem, sourceSubItem, targetLocation);
            } else if (targetCSObject.getType() == 10 && targetCSObject.getParent().getType() == 6) {
                ISimpleCSSubItem targetSubItem = (ISimpleCSSubItem)targetCSObject;
                this.doDropMove(targetSubItem, sourceSubItem, targetLocation);
            }
        }
    }

    private void doDropMove(ISimpleCS targetCheatSheet, ISimpleCSItem sourceItem, int targetLocation) {
        if (targetLocation != 1 && targetLocation != 2 && targetLocation == 3) {
            if (targetCheatSheet.isLastItem(sourceItem)) {
                return;
            }
            sourceItem.reconnect((IDocumentElementNode)targetCheatSheet, (IModel)this.fModel);
            targetCheatSheet.addItem(sourceItem);
        }
    }

    private void doDropMove(ISimpleCSItem targetItem, ISimpleCSItem sourceItem, int targetLocation) {
        ISimpleCS parent = targetItem.getSimpleCS();
        if (targetLocation == 1) {
            IDocumentElementNode previousNode = parent.getPreviousSibling((IDocumentElementNode)targetItem, ISimpleCSItem.class);
            if (sourceItem.equals(previousNode)) {
                return;
            }
            sourceItem.reconnect((IDocumentElementNode)parent, (IModel)this.fModel);
            int index = parent.indexOfItem(targetItem);
            if (index != -1) {
                parent.addItem(index, sourceItem);
            }
        } else if (targetLocation == 2 || targetLocation == 3) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetItem, ISimpleCSItem.class);
            if (sourceItem.equals(nextNode)) {
                return;
            }
            sourceItem.reconnect((IDocumentElementNode)parent, (IModel)this.fModel);
            if (nextNode == null) {
                parent.addItem(sourceItem);
            } else {
                int index = parent.indexOfItem((ISimpleCSItem)nextNode);
                if (index != -1) {
                    parent.addItem(index, sourceItem);
                }
            }
        }
    }

    private void doDropMove(ISimpleCSIntro targetIntro, ISimpleCSItem sourceItem, int targetLocation) {
        ISimpleCS parent = targetIntro.getSimpleCS();
        if (targetLocation != 1 && (targetLocation == 2 || targetLocation == 3)) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetIntro, ISimpleCSItem.class);
            if (sourceItem.equals(nextNode)) {
                return;
            }
            sourceItem.reconnect((IDocumentElementNode)parent, (IModel)this.fModel);
            if (nextNode == null) {
                parent.addItem(sourceItem);
            } else {
                int index = parent.indexOfItem((ISimpleCSItem)nextNode);
                if (index != -1) {
                    parent.addItem(index, sourceItem);
                }
            }
        }
    }

    private void doDropMove(ISimpleCSItem targetItem, ISimpleCSSubItem sourceSubItem, int targetLocation) {
        if (targetLocation != 1) {
            if (targetLocation == 2) {
                if (targetItem.getExecutable() != null) {
                    return;
                }
                if (targetItem.isFirstSubItem((ISimpleCSSubItemObject)sourceSubItem)) {
                    return;
                }
                sourceSubItem.reconnect((IDocumentElementNode)targetItem, (IModel)this.fModel);
                ISimpleCSSubItem firstSubItem = (ISimpleCSSubItem)targetItem.getChildNode(ISimpleCSSubItem.class);
                if (firstSubItem == null) {
                    targetItem.addSubItem((ISimpleCSSubItemObject)sourceSubItem);
                } else {
                    int index = targetItem.indexOfSubItem((ISimpleCSSubItemObject)firstSubItem);
                    if (index != -1) {
                        targetItem.addSubItem(index, (ISimpleCSSubItemObject)sourceSubItem);
                    }
                }
            } else if (targetLocation == 3) {
                if (targetItem.getExecutable() != null) {
                    return;
                }
                if (targetItem.isLastSubItem((ISimpleCSSubItemObject)sourceSubItem)) {
                    return;
                }
                sourceSubItem.reconnect((IDocumentElementNode)targetItem, (IModel)this.fModel);
                targetItem.addSubItem((ISimpleCSSubItemObject)sourceSubItem);
            }
        }
    }

    private void doDropMove(ISimpleCSSubItem targetSubItem, ISimpleCSSubItem sourceSubItem, int targetLocation) {
        ISimpleCSItem parent = (ISimpleCSItem)targetSubItem.getParent();
        if (targetLocation == 1) {
            IDocumentElementNode previousNode = parent.getPreviousSibling((IDocumentElementNode)targetSubItem, ISimpleCSSubItem.class);
            if (sourceSubItem.equals(previousNode)) {
                return;
            }
            sourceSubItem.reconnect((IDocumentElementNode)parent, (IModel)this.fModel);
            int index = parent.indexOfSubItem((ISimpleCSSubItemObject)targetSubItem);
            if (index != -1) {
                parent.addSubItem(index, (ISimpleCSSubItemObject)sourceSubItem);
            }
        } else if (targetLocation == 2 || targetLocation == 3) {
            IDocumentElementNode nextNode = parent.getNextSibling((IDocumentElementNode)targetSubItem, ISimpleCSSubItem.class);
            if (sourceSubItem.equals(nextNode)) {
                return;
            }
            sourceSubItem.reconnect((IDocumentElementNode)parent, (IModel)this.fModel);
            if (nextNode == null) {
                parent.addSubItem((ISimpleCSSubItemObject)sourceSubItem);
            } else {
                int index = parent.indexOfSubItem((ISimpleCSSubItemObject)((ISimpleCSSubItem)nextNode));
                if (index != -1) {
                    parent.addSubItem(index, (ISimpleCSSubItemObject)sourceSubItem);
                }
            }
        }
    }

    public void doDragRemove(Object[] sourceObjects) {
        ISimpleCSObject parent;
        if (!this.validatePaste(sourceObjects)) {
            return;
        }
        ISimpleCSObject object = (ISimpleCSObject)sourceObjects[0];
        if (object.getType() == 6) {
            ISimpleCSItem item = (ISimpleCSItem)object;
            ISimpleCS cheatsheet = object.getSimpleCS();
            this.doSelect(false);
            cheatsheet.removeItem(item);
            this.doSelect(true);
        } else if (object.getType() == 10 && (parent = object.getParent()).getType() == 6) {
            ISimpleCSSubItem subitem = (ISimpleCSSubItem)object;
            ISimpleCSItem item = (ISimpleCSItem)parent;
            this.doSelect(false);
            item.removeSubItem((ISimpleCSSubItemObject)subitem);
            this.doSelect(true);
        }
        ((PDEFormEditor)this.getPage().getEditor()).getContextManager().getPrimaryContext().flushEditorInput();
    }

    private void createSubStepInfoDecoration() {
        Button button = this.getStructuredViewerPart().getButton(1);
        int bits = 131200;
        this.fSubStepInfoDecoration = new ControlDecoration((Control)button, bits);
        this.fSubStepInfoDecoration.setMarginWidth(0);
        this.updateSubStepInfoDecoration(false, false, false);
        this.fSubStepInfoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
    }

    private void updateSubStepInfoDecoration(boolean show, boolean itemHasNoExecutable, boolean itemIsNotOptional) {
        if (show) {
            this.fSubStepInfoDecoration.show();
            if (!itemHasNoExecutable) {
                this.fSubStepInfoDecoration.setDescriptionText(SimpleMessages.SimpleCSMasterTreeSection_descriptionText1);
            } else if (!itemIsNotOptional) {
                this.fSubStepInfoDecoration.setDescriptionText(SimpleMessages.SimpleCSMasterTreeSection_descriptionText2);
            }
        } else {
            this.fSubStepInfoDecoration.hide();
        }
        this.fSubStepInfoDecoration.setShowHover(show);
    }

    private void createTreeListeners() {
        this.fTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)new PDEFormEditor.PDEFormEditorChangeListener(this.getPage().getPDEEditor()));
    }

    public ISelection getSelection() {
        return this.fTreeViewer.getSelection();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddStepAction();
                break;
            }
            case 1: {
                this.handleAddSubStepAction();
                break;
            }
            case 4: {
                this.handleDeleteAction();
                break;
            }
            case 5: {
                this.handleMoveStepAction(-1);
                break;
            }
            case 6: {
                this.handleMoveStepAction(1);
                break;
            }
            case 9: {
                this.handlePreviewAction();
            }
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (!this.fModel.isEditable()) {
            return;
        }
        ISimpleCSObject csObject = this.getCurrentSelection();
        boolean canAddItem = false;
        boolean canAddSubItem = false;
        boolean canRemove = false;
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        boolean itemHasNoExecutable = false;
        boolean itemIsNotOptional = false;
        boolean showDecoration = false;
        if (csObject != null) {
            if (csObject.getType() == 0) {
                canAddItem = true;
            } else if (csObject.getType() == 5) {
                canAddItem = true;
            } else if (csObject.getType() == 6) {
                ISimpleCSItem item = (ISimpleCSItem)csObject;
                if (!item.getSimpleCS().isFirstItem(item)) {
                    canMoveUp = true;
                }
                if (!item.getSimpleCS().isLastItem(item)) {
                    canMoveDown = true;
                }
                if (item.getSimpleCS().getItemCount() > 1) {
                    canRemove = true;
                }
                itemHasNoExecutable = item.getExecutable() == null;
                boolean bl = itemIsNotOptional = !item.getSkip();
                if (itemHasNoExecutable && itemIsNotOptional) {
                    canAddSubItem = true;
                }
                showDecoration = !canAddSubItem;
                canAddItem = true;
            } else if (csObject.getType() == 10) {
                ISimpleCSSubItem subitem = (ISimpleCSSubItem)csObject;
                ISimpleCSObject parent = subitem.getParent();
                if (parent.getType() == 6) {
                    ISimpleCSItem item = (ISimpleCSItem)parent;
                    if (!item.isFirstSubItem((ISimpleCSSubItemObject)subitem)) {
                        canMoveUp = true;
                    }
                    if (!item.isLastSubItem((ISimpleCSSubItemObject)subitem)) {
                        canMoveDown = true;
                    }
                    itemHasNoExecutable = item.getExecutable() == null;
                    boolean bl = itemIsNotOptional = !item.getSkip();
                    if (itemHasNoExecutable && itemIsNotOptional) {
                        canAddSubItem = true;
                    }
                    showDecoration = !canAddSubItem;
                }
                canRemove = true;
            } else if (csObject.getType() == 9 || csObject.getType() == 3 || csObject.getType() == 8 || csObject.getType() == 1 || csObject.getType() == 2) {
                canRemove = true;
            }
            this.updateSubStepInfoDecoration(showDecoration, itemHasNoExecutable, itemIsNotOptional);
        }
        this.getTreePart().setButtonEnabled(0, canAddItem);
        this.getTreePart().setButtonEnabled(1, canAddSubItem);
        this.getTreePart().setButtonEnabled(4, canRemove);
        this.getTreePart().setButtonEnabled(5, canMoveUp);
        this.getTreePart().setButtonEnabled(6, canMoveDown);
    }

    private void handleAddStepAction() {
        ISimpleCSObject csObject = this.getCurrentSelection();
        if (csObject == null) {
            this.fAddStepAction.setDataObject((ISimpleCSObject)this.fModel.getSimpleCS());
        } else {
            this.fAddStepAction.setDataObject(csObject);
        }
        this.fAddStepAction.run();
    }

    private ISimpleCSObject getCurrentSelection() {
        ISelection selection = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        return (ISimpleCSObject)object;
    }

    private void handleAddSubStepAction() {
        ISimpleCSObject csObject = this.getCurrentSelection();
        if (csObject == null) {
            return;
        }
        this.fAddSubStepAction.setDataObject(csObject);
        this.fAddSubStepAction.run();
    }

    private void handleMoveStepAction(int positionFlag) {
        ISimpleCSObject object = this.getCurrentSelection();
        if (object != null) {
            ISimpleCSSubItem subitem;
            ISimpleCSObject parent;
            if (object instanceof ISimpleCSItem) {
                ISimpleCSItem item = (ISimpleCSItem)object;
                item.getSimpleCS().moveItem(item, positionFlag);
            } else if (object instanceof ISimpleCSSubItem && (parent = (subitem = (ISimpleCSSubItem)object).getParent()).getType() == 6) {
                ISimpleCSItem item = (ISimpleCSItem)parent;
                item.moveSubItem((ISimpleCSSubItemObject)subitem, positionFlag);
            }
        }
    }

    private void handlePreviewAction() {
        PDEFormEditor editor = (PDEFormEditor)this.getPage().getEditor();
        SimpleCSEditorContributor contributor = (SimpleCSEditorContributor)editor.getContributor();
        SimpleCSPreviewAction previewAction = contributor.getPreviewAction();
        previewAction.setDataModelObject(this.fModel.getSimpleCS());
        previewAction.setEditorInput(this.getPage().getEditorInput());
        previewAction.run();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        } else if (event.getChangeType() == 1) {
            this.handleModelInsertType(event);
        } else if (event.getChangeType() == 2) {
            this.handleModelRemoveType(event);
        } else if (event.getChangeType() == 3 && event.getChangedProperty().equals("type_swap")) {
            this.handleModelChangeTypeSwap(event);
        } else if (event.getChangeType() == 3) {
            this.handleModelChangeType(event);
        }
    }

    public void refresh() {
        SimpleCSDefinitionPage page = (SimpleCSDefinitionPage)this.getPage();
        this.fModel = (ISimpleCSModel)page.getModel();
        this.initializeTreeViewer();
        super.refresh();
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.markStale();
    }

    private void handleModelChangeTypeSwap(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (!(objects[0] instanceof ISimpleCSObject)) {
            return;
        }
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null && (object.getType() == 6 || object.getType() == 0)) {
            this.fTreeViewer.refresh((Object)object);
        }
    }

    private void handleModelInsertType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null && (object.getType() == 6 || object.getType() == 10)) {
            this.fTreeViewer.refresh((Object)object.getParent());
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)object), true);
        }
    }

    private void handleModelRemoveType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null) {
            if (object.getType() == 6) {
                this.fTreeViewer.remove((Object)object);
                if (!this.canSelect()) {
                    return;
                }
                ISimpleCSObject csObject = this.fRemoveStepAction.getObjectToSelect();
                if (csObject == null) {
                    csObject = object.getParent();
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)csObject), true);
            } else if (object.getType() == 10) {
                this.fTreeViewer.remove((Object)object);
                if (!this.canSelect()) {
                    return;
                }
                ISimpleCSObject csObject = this.fRemoveSubStepAction.getObjectToSelect();
                if (csObject == null) {
                    csObject = object.getParent();
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)csObject), true);
            } else if (object.getType() == 3 || object.getType() == 9 || object.getType() == 8) {
                this.fTreeViewer.remove((Object)object);
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)object.getParent()), true);
            }
        }
    }

    private void handleModelChangeType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (!(objects[0] instanceof ISimpleCSObject)) {
            return;
        }
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null && (object.getType() == 6 || object.getType() == 10 || object.getType() == 0)) {
            this.fTreeViewer.update((Object)object, null);
        }
    }

    @Override
    public void fireSelection() {
        this.fTreeViewer.setSelection(this.fTreeViewer.getSelection());
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISimpleCSObject csObject = this.getCurrentSelection();
        MenuManager submenu = new MenuManager(SimpleMessages.SimpleCSMasterTreeSection_new);
        manager.add((IContributionItem)submenu);
        if (csObject == null || csObject.getType() == 0) {
            this.fAddStepAction.setDataObject((ISimpleCSObject)this.fModel.getSimpleCS());
            this.fAddStepAction.setEnabled(this.fModel.isEditable());
            submenu.add((IAction)this.fAddStepAction);
        } else if (csObject.getType() == 6) {
            ISimpleCSItem item = (ISimpleCSItem)csObject;
            this.fAddSubStepAction.setDataObject(csObject);
            if (item.getExecutable() == null && !item.getSkip()) {
                this.fAddSubStepAction.setEnabled(this.fModel.isEditable());
            } else {
                this.fAddSubStepAction.setEnabled(false);
            }
            submenu.add((IAction)this.fAddSubStepAction);
            manager.add((IContributionItem)new Separator());
            this.fRemoveStepAction.setItem((ISimpleCSItem)csObject);
            if (item.getSimpleCS().getItemCount() > 1) {
                this.fRemoveStepAction.setEnabled(this.fModel.isEditable());
            } else {
                this.fRemoveStepAction.setEnabled(false);
            }
            manager.add((IAction)this.fRemoveStepAction);
        } else if (csObject.getType() == 10 || csObject.getType() == 9 || csObject.getType() == 3) {
            manager.add((IContributionItem)new Separator());
            this.fRemoveSubStepAction.setSubItem((ISimpleCSSubItemObject)csObject);
            this.fRemoveSubStepAction.setEnabled(this.fModel.isEditable());
            manager.add((IAction)this.fRemoveSubStepAction);
        } else if (csObject.getType() == 8 || csObject.getType() == 1 || csObject.getType() == 2) {
            manager.add((IContributionItem)new Separator());
            this.fRemoveRunObjectAction.setRunObject((ISimpleCSRunContainerObject)csObject);
            this.fRemoveRunObjectAction.setEnabled(this.fModel.isEditable());
            manager.add((IAction)this.fRemoveRunObjectAction);
        }
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDeleteAction();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDeleteAction();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    private void handleDeleteAction() {
        ISimpleCSObject object = this.getCurrentSelection();
        if (object != null) {
            if (object instanceof ISimpleCSItem) {
                ISimpleCSItem item = (ISimpleCSItem)object;
                if (item.getSimpleCS().getItemCount() > 1) {
                    this.fRemoveStepAction.setItem(item);
                    this.fRemoveStepAction.run();
                } else {
                    Display.getCurrent().beep();
                }
            } else if (object instanceof ISimpleCSSubItemObject) {
                this.fRemoveSubStepAction.setSubItem((ISimpleCSSubItemObject)object);
                this.fRemoveSubStepAction.run();
            } else if (object instanceof ISimpleCSRunContainerObject) {
                this.fRemoveRunObjectAction.setRunObject((ISimpleCSRunContainerObject)object);
                this.fRemoveRunObjectAction.run();
            } else if (object instanceof ISimpleCS) {
                Display.getCurrent().beep();
            } else if (object instanceof ISimpleCSIntro) {
                Display.getCurrent().beep();
            }
        }
    }

    @Override
    public boolean setFormInput(Object object) {
        if (object instanceof ISimpleCSObject) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.fTreeViewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean validatePaste(Object targetObject, Object[] sourceObjects) {
        if (!(targetObject instanceof ISimpleCSObject)) {
            return false;
        }
        return this.validatePaste(sourceObjects);
    }

    private boolean validatePaste(Object[] sourceObjects) {
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length != 1) {
            return false;
        }
        return sourceObjects[0] instanceof ISimpleCSObject;
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        if (!this.validatePaste(targetObject, sourceObjects)) {
            return false;
        }
        ISimpleCSObject sourceCSObject = (ISimpleCSObject)sourceObjects[0];
        ISimpleCSObject targetCSObject = (ISimpleCSObject)targetObject;
        if (sourceCSObject.getType() == 6) {
            if (targetCSObject.getType() == 0) {
                return true;
            }
            if (targetCSObject.getType() == 6) {
                return true;
            }
            if (targetCSObject.getType() == 5) {
                return true;
            }
        } else if (sourceCSObject.getType() == 10) {
            if (targetCSObject.getType() == 6) {
                return true;
            }
            if (targetCSObject.getType() == 10) {
                return true;
            }
        }
        return false;
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        if (!this.validatePaste(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        ISimpleCSObject sourceCSObject = (ISimpleCSObject)sourceObjects[0];
        ISimpleCSObject targetCSObject = (ISimpleCSObject)targetObject;
        if (sourceCSObject.getType() == 6) {
            ISimpleCSItem sourceItem = (ISimpleCSItem)sourceCSObject;
            if (targetCSObject.getType() == 0) {
                ISimpleCS targetCheatSheet = (ISimpleCS)targetCSObject;
                sourceItem.reconnect((IDocumentElementNode)targetCheatSheet, (IModel)this.fModel);
                targetCheatSheet.addItem(sourceItem);
            } else if (targetCSObject.getType() == 6) {
                ISimpleCSItem targetItem = (ISimpleCSItem)targetCSObject;
                ISimpleCS targetCheatSheet = targetItem.getSimpleCS();
                sourceItem.reconnect((IDocumentElementNode)targetCheatSheet, (IModel)this.fModel);
                int index = targetCheatSheet.indexOfItem(targetItem) + 1;
                targetCheatSheet.addItem(index, sourceItem);
            } else if (targetCSObject.getType() == 5) {
                ISimpleCSIntro targetIntro = (ISimpleCSIntro)targetCSObject;
                ISimpleCS targetCheatSheet = targetCSObject.getSimpleCS();
                sourceItem.reconnect((IDocumentElementNode)targetCheatSheet, (IModel)this.fModel);
                int index = targetCheatSheet.indexOf((IDocumentElementNode)targetIntro) + 1;
                targetCheatSheet.addItem(index, sourceItem);
            }
        } else if (sourceCSObject.getType() == 10) {
            ISimpleCSSubItem sourceSubitem = (ISimpleCSSubItem)sourceCSObject;
            if (targetCSObject.getType() == 6) {
                ISimpleCSItem targetItem = (ISimpleCSItem)targetCSObject;
                sourceSubitem.reconnect((IDocumentElementNode)targetItem, (IModel)this.fModel);
                targetItem.addSubItem((ISimpleCSSubItemObject)sourceSubitem);
            } else if (targetCSObject.getType() == 10 && targetCSObject.getParent().getType() == 6) {
                ISimpleCSSubItem targetSubItem = (ISimpleCSSubItem)targetCSObject;
                ISimpleCSItem targetItem = (ISimpleCSItem)targetSubItem.getParent();
                sourceSubitem.reconnect((IDocumentElementNode)targetItem, (IModel)this.fModel);
                int index = targetItem.indexOfSubItem((ISimpleCSSubItemObject)targetSubItem) + 1;
                targetItem.addSubItem(index, (ISimpleCSSubItemObject)sourceSubitem);
            }
        }
    }

    public boolean canCut(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (!(object instanceof ISimpleCSObject)) {
            return false;
        }
        ISimpleCSObject csObject = (ISimpleCSObject)object;
        if (csObject.getType() == 6 && csObject.getSimpleCS().getItemCount() != 1) {
            return true;
        }
        return object instanceof ISimpleCSSubItem;
    }
}

