/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.ui.actions.SyncProgressMonitor;
import org.eclipse.rcptt.ui.launching.aut.AUTConnectionErrorDialog;
import org.eclipse.rcptt.ui.launching.aut.AUTSelectionDialog;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.rcptt.util.ShellUtilsProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;

public class LaunchUtils {
    public static final String PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH = "org.eclipse.debug.ui.save_dirty_editors_before_launch";

    public static boolean saveChanges(IResource[] context) throws ModelException {
        String savePromptMode = DebugUITools.getPreferenceStore().getString(PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
        if (Strings.isNullOrEmpty((String)savePromptMode)) {
            savePromptMode = "prompt";
        }
        if ("never".equals(savePromptMode)) {
            return true;
        }
        final HashSet<IPath> targets = new HashSet<IPath>();
        IResource[] iResourceArray = context;
        int n = context.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            targets.add(r.getFullPath());
            ++n2;
        }
        HashSet contexts = new HashSet();
        IResource[] iResourceArray2 = context;
        int n3 = context.length;
        n = 0;
        while (n < n3) {
            IResource r = iResourceArray2[n];
            IQ7Element e = RcpttCore.create((IResource)r);
            if (e instanceof IQ7NamedElement) {
                RcpttCore.getInstance().findAllContexts((IQ7NamedElement)e, contexts);
                RcpttCore.getInstance().findAllVerifications((IQ7NamedElement)e, contexts);
            }
            ++n;
        }
        for (IQ7Element c : contexts) {
            targets.add(c.getResource().getFullPath());
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return workbench.saveAll((IShellProvider)window, (IRunnableContext)window, (ISaveableFilter)new SaveableFilter(){

            @Override
            public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
                IWorkbenchPart[] iWorkbenchPartArray = containingParts;
                int n = containingParts.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPart p = iWorkbenchPartArray[n2];
                    if (p instanceof IEditorPart) {
                        IResource[] editorContext;
                        IEditorPart editor = (IEditorPart)p;
                        IResource[] iResourceArray = editorContext = LaunchUtils.getContext(editor);
                        int n3 = editorContext.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResource r = iResourceArray[n4];
                            if (targets.contains(r.getFullPath())) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                return false;
            }
        }, "prompt".equals(savePromptMode));
    }

    public static IResource[] getContext() {
        IEditorPart part;
        ISelection selection;
        IWorkbenchPage page;
        IResource[] resources = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (page = activeWorkbenchWindow.getActivePage()) != null && (resources = LaunchUtils.getContext(selection = page.getSelection())).length == 0 && (part = page.getActiveEditor()) != null) {
            resources = LaunchUtils.getContext(part);
        }
        return resources;
    }

    public static IResource[] getContext(ISelection selection) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                LaunchUtils.doGetContext(it.next(), resources);
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private static void doGetContext(Object object, List<IResource> resources) {
        if (object instanceof Tag) {
            Tag tag = (Tag)object;
            for (IQ7NamedElement element : TagsUtil.getDistinctTagRefs((Tag)tag)) {
                LaunchUtils.doGetContext(element, resources);
            }
        } else if (object instanceof IQ7NamedElement) {
            IResource res = ((IQ7NamedElement)object).getResource();
            if (res != null) {
                resources.add(res);
            }
        } else if (object instanceof NamedElement) {
            IFile file = Q7Utils.getLocation((NamedElement)((NamedElement)object));
            if (file != null) {
                resources.add((IResource)file);
            }
        } else {
            IResource res = LaunchUtils.getAdapter(IResource.class, object);
            if (res != null) {
                resources.add(res);
            }
        }
    }

    public static IResource[] getContext(IEditorPart part) {
        IResource res = (IResource)part.getAdapter(IResource.class);
        if (res == null) {
            return new IResource[0];
        }
        return new IResource[]{res};
    }

    public static <T> T getAdapter(Class<T> clazz, Object element) {
        if (element == null) {
            return null;
        }
        if (clazz.isInstance(element)) {
            return clazz.cast(element);
        }
        Object adapted = null;
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapted = adaptable.getAdapter(clazz);
        }
        if (adapted == null) {
            adapted = Platform.getAdapterManager().getAdapter(element, clazz);
        }
        return adapted == null ? null : (T)clazz.cast(adapted);
    }

    public static void launchContext(IResource[] context, String mode, Map<String, List<List<String>>> variants) {
        LaunchUtils.launchContext(context, mode, true, variants);
    }

    public static void launchContext(IResource[] context, String mode) {
        LaunchUtils.launchContext(context, mode, true, null);
    }

    public static void launchVerification(IResource[] verification, String mode) {
        LaunchUtils.launchVerification(verification, mode, true, null);
    }

    public static void runResource(IResource res) {
        LaunchUtils.launchContextOrVerification(new IResource[]{res}, "run", false, false, null);
    }

    public static void launchContext(IResource[] context, String mode, boolean sort, Map<String, List<List<String>>> variants) {
        LaunchUtils.launchContextOrVerification(context, mode, sort, true, variants);
    }

    public static void launchVerification(IResource[] verification, String mode, boolean sort, Map<String, List<List<String>>> variants) {
        LaunchUtils.launchVerification(verification, mode, sort, true, variants);
    }

    public static void launchContext(IResource[] context, String mode, boolean sort) {
        LaunchUtils.launchContextOrVerification(context, mode, sort, true, null);
    }

    public static void launchVerification(IResource[] verification, String mode, boolean sort) {
        LaunchUtils.launchVerification(verification, mode, sort, true, null);
    }

    public static void launchContextOrVerification(IResource[] context, String mode, boolean sort, boolean promptForSave, Map<String, List<List<String>>> variants) {
        try {
            IQ7NamedElement[] elements = TestSuiteUtils.getElements((IResource[])context, (boolean)false, (boolean)sort);
            if (elements.length == 0) {
                LaunchUtils.showNoTestsFoundDialog();
                return;
            }
            if (promptForSave && !LaunchUtils.saveChanges(context)) {
                return;
            }
            ILaunchConfiguration config = LaunchUtils.getLaunchConfig(context, mode, sort, variants);
            if (config == null) {
                return;
            }
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                return;
            }
            ErrorDialog.openError((Shell)WorkbenchUtils.getShell(), (String)Messages.LaunchUtils_CantCreateLaunchConfDialogTitle, (String)Messages.LaunchUtils_CantCreateLaunchConfDialogMsg, (IStatus)e.getStatus());
        }
    }

    public static void launchVerification(IResource[] verification, String mode, boolean sort, boolean promptForSave, Map<String, List<List<String>>> variants) {
        LaunchUtils.launchContextOrVerification(verification, mode, sort, promptForSave, variants);
    }

    public static ILaunchConfiguration getLaunchConfig(IResource[] context, String mode, boolean sort, Map<String, List<List<String>>> variants) throws CoreException {
        IQ7NamedElement[] elements = TestSuiteUtils.getElements((IResource[])context, (boolean)false, (boolean)sort);
        if (elements.length == 0) {
            return null;
        }
        return Q7Launcher.getLaunchConfiguration((IQ7NamedElement[])elements, null, null, (boolean)sort, variants);
    }

    public static AutLaunch selectAutLaunch() {
        return LaunchUtils.selectAutLaunch(null);
    }

    public static void waitForCompletion(ILaunch launch) {
        while (!launch.isTerminated()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void execute(IResource resource, boolean debug) throws CoreException {
        String mode = debug ? "debug" : "run";
        LaunchUtils.waitForCompletion(LaunchUtils.getLaunchConfig(new IResource[]{resource}, mode, false, null).launch(mode, (IProgressMonitor)new NullProgressMonitor()));
    }

    public static AutLaunch selectAutLaunch(Shell shell) {
        List launches = AutManager.INSTANCE.getLaunches();
        if (launches.size() == 1) {
            return (AutLaunch)launches.get(0);
        }
        if (shell == null) {
            shell = LaunchUtils.getShell();
        }
        final AtomicReference launch = new AtomicReference();
        if (shell == null) {
            shell = LaunchUtils.getShell();
        }
        final Shell s = shell;
        LaunchUtils.runInUI(s.getDisplay(), new Runnable(){

            @Override
            public void run() {
                AUTSelectionDialog dialog = new AUTSelectionDialog(s);
                if (dialog.open() == 0) {
                    launch.set(dialog.getResult());
                }
            }
        });
        return (AutLaunch)launch.get();
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
    }

    public static AutLaunch launch(final Aut aut, final Shell shell) {
        final AtomicReference launch = new AtomicReference();
        LaunchUtils.runInUI(shell.getDisplay(), new Runnable(){

            @Override
            public void run() {
                LaunchUtils.doLaunch(aut, shell, launch);
            }
        });
        return (AutLaunch)launch.get();
    }

    private static void doLaunch(final Aut aut, final Shell shell, final AtomicReference<AutLaunch> launch) {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(shell);
        final AtomicReference<IStatus> status = new AtomicReference<IStatus>();
        try {
            progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        try {
                            launch.set(aut.launch((IProgressMonitor)new SyncProgressMonitor(monitor, shell.getDisplay())));
                            status.set(Status.OK_STATUS);
                        }
                        catch (CoreException e) {
                            status.set(e.getStatus());
                            if (status.get() == null) {
                                status.set(Status.CANCEL_STATUS);
                            }
                        }
                    }
                    finally {
                        if (status.get() == null) {
                            status.set(Status.CANCEL_STATUS);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            status.set(RcpttPlugin.createStatus((String)("Failed to launch " + aut.getName()), (Throwable)e1.getCause()));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        IStatus s = (IStatus)status.get();
        if (s.matches(8)) {
            return;
        }
        if (!s.isOK()) {
            RcpttPlugin.getDefault().getLog().log(s);
            AUTConnectionErrorDialog.showAUTConnectionError(shell, s, aut.getConfig());
            return;
        }
        try {
            ShellUtilsProvider.getShellUtils().forceActive((Object)shell);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static void runInUI(Display display, Runnable runnable) {
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.syncExec(runnable);
        }
    }

    private static void showNoTestsFoundDialog() {
        MessageDialog.openInformation((Shell)WorkbenchUtils.getShell(), (String)Messages.LaunchUtils_NoQ7TestFoundTitle, (String)Messages.LaunchUtils_NoQ7TestFoundDialogMsg);
    }

    public static boolean hasLaunchedTestCases() {
        ILaunch[] launches;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (Q7LaunchManager.isTestSuiteLauch((ILaunch)launch) && !launch.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Boolean checkCancelDebugSessions(Shell shell) {
        final Shell selectedShell = shell != null ? shell : LaunchUtils.getShell();
        final Boolean[] result = new Boolean[]{Boolean.TRUE};
        LaunchUtils.runInUI(selectedShell.getDisplay(), new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.openQuestion((Shell)selectedShell, (String)"RCPTT Debug", (String)"Debug session are in progress.\nWould you like to cancel it?");
            }
        });
        return result[0];
    }

    private static abstract class SaveableFilter
    implements ISaveableFilter {
        private SaveableFilter() {
        }

        public abstract boolean select(Saveable var1, IWorkbenchPart[] var2);
    }
}

