/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.aspects.swt.rap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.SWT;

public class RcpttJSRegistrar {
    private static final String[] CLIENT_JS_FILES = new String[]{"rcptt/RCPTT.js", "rcptt/Assertion.js"};

    public static void registrate(StartupPage page, ResourceManager manager) throws IOException {
        ContentBuffer content = new ContentBuffer();
        String[] stringArray = CLIENT_JS_FILES;
        int n = CLIENT_JS_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            content.append(file);
            ++n2;
        }
        RcpttJSRegistrar.registerJavascriptResource(page, manager, content, String.valueOf(SWT.getVersion()) + "/rcptt-client.js");
    }

    private static void registerJavascriptResource(StartupPage page, ResourceManager manager, ContentBuffer buffer, String name) throws IOException {
        InputStream inputStream = buffer.getContentAsStream();
        try {
            manager.register(name, inputStream);
        }
        finally {
            inputStream.close();
        }
        String location = manager.getLocation(name);
        page.addJsLibrary(location);
    }

    private static class ContentBuffer {
        private final ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();

        public void append(String location) throws IOException {
            InputStream inputStream = this.openResourceStream(location);
            if (inputStream == null) {
                throw new IOException("Failed to load resource: " + location);
            }
            try {
                this.append(inputStream);
            }
            finally {
                inputStream.close();
            }
        }

        private void append(InputStream inputStream) throws IOException {
            byte[] buffer = new byte[40960];
            boolean contentWritten = false;
            int read = inputStream.read(buffer);
            while (read != -1) {
                this.bufferOutputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
                contentWritten = true;
            }
            if (contentWritten) {
                this.bufferOutputStream.write(10);
            }
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.bufferOutputStream.toByteArray());
        }

        private InputStream openResourceStream(String name) {
            return this.getClass().getClassLoader().getResourceAsStream(name);
        }
    }
}

