/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface.rap;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.tesla.jface.rap.JFaceAspectsActivator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DescriptorInfo {
    BUNDLE_URL{
        public final Pattern pattern = Pattern.compile("URLImageDescriptor\\(((bundleentry|bundleresource).*)\\)");

        public String extract(String descriptorStr) {
            Matcher matcher = this.pattern.matcher(descriptorStr);
            if (matcher.matches()) {
                String uriStr = matcher.group(1);
                URI bundleUri = null;
                try {
                    bundleUri = new URI(uriStr);
                }
                catch (URISyntaxException uRISyntaxException) {
                    return "InvalidUri(" + uriStr + ")";
                }
                String host = bundleUri.getHost();
                int bundleIdEndIndex = host.indexOf(".fwk");
                if (bundleIdEndIndex == -1) {
                    return "UnknownBundleId(" + uriStr + ")";
                }
                int bundleId = -1;
                try {
                    bundleId = Integer.parseInt(host.substring(0, bundleIdEndIndex));
                }
                catch (NumberFormatException numberFormatException) {
                    return "UnknownBundleId(" + uriStr + ")";
                }
                Bundle imageBundle = JFaceAspectsActivator.getDefault().getBundle().getBundleContext().getBundle((long)bundleId);
                String bundleName = imageBundle == null ? "unknownBundle" : imageBundle.getSymbolicName();
                return String.format("%s%s", bundleName, bundleUri.getPath());
            }
            return null;
        }

        String extract(ImageDescriptor descriptor) {
            return this.extract(descriptor.toString());
        }
    }
    ,
    ABSOLUTE_URL{
        public final Pattern pattern = Pattern.compile("URLImageDescriptor\\((file:/|platform:/plugin/)(.*)\\)");

        public String extract(String descriptorStr) {
            Matcher matcher = this.pattern.matcher(descriptorStr);
            if (matcher.matches()) {
                return matcher.group(2);
            }
            return null;
        }

        String extract(ImageDescriptor descriptor) {
            return this.extract(descriptor.toString());
        }
    }
    ,
    FILE_CLASS{
        public final Pattern pattern = Pattern.compile("FileImageDescriptor\\(location=class (.*), name=(.*)\\)");

        public String extract(String descriptorStr) {
            Matcher matcher = this.pattern.matcher(descriptorStr);
            if (matcher.matches()) {
                return String.format("%s%s", matcher.group(1), matcher.group(2));
            }
            return null;
        }

        String extract(ImageDescriptor descriptor) {
            return this.extract(descriptor.toString());
        }
    };


    private DescriptorInfo() {
    }

    public static String getInfo(ImageDescriptor descriptor) {
        DescriptorInfo[] descriptorInfoArray = DescriptorInfo.values();
        int n = descriptorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DescriptorInfo i = descriptorInfoArray[n2];
            String info = i.extract(descriptor);
            if (info != null) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    public String extract(String descriptorStr) {
        return null;
    }

    abstract String extract(ImageDescriptor var1);

    /* synthetic */ DescriptorInfo(String string, int n, DescriptorInfo descriptorInfo) {
        this();
    }
}

