/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.ecl.core.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.VerificationsRuntime;
import org.eclipse.rcptt.core.ecl.core.model.ExecVerification;
import org.eclipse.rcptt.core.internal.ecl.core.Utils;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.reporting.core.RunnableWithStatus;

public class ExecVerificationService
implements ICommandService {
    public IStatus service(Command command, final IProcess context) throws InterruptedException, CoreException {
        final ExecVerification execVerification = (ExecVerification)command;
        Verification verification = execVerification.getVerification();
        Q7Info info = ReportingFactory.eINSTANCE.createQ7Info();
        info.setType(ItemKind.VERIFICATION);
        info.setId(verification.getId());
        info.setTags(verification.getTags());
        info.setSubtype(verification.getId());
        info.setPhase(execVerification.getPhase().toString());
        info.setDescription(verification.getDescription());
        RunnableWithStatus runnable = new RunnableWithStatus(){

            public void run() throws CoreException {
                ExecVerificationService.this.exec(execVerification, context);
            }
        };
        Utils.reportExecution(ReportManager.getCurrentReportNode(), runnable, verification.getName() == null ? "Unnamed verification" : verification.getName(), info);
        return Status.OK_STATUS;
    }

    public void exec(ExecVerification execVerification, IProcess process) throws CoreException {
        Verification verification = execVerification.getVerification();
        switch (execVerification.getPhase()) {
            case START: {
                VerificationsRuntime.getInstance().executeStart(verification, process);
                break;
            }
            case RUN: {
                VerificationsRuntime.getInstance().executeRun(verification, process);
                break;
            }
            case FINISH: {
                VerificationsRuntime.getInstance().executeFinish(verification, process);
                break;
            }
            case AUTO: {
                VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification(verification);
                String[] phases = type.getPhases();
                if (phases.length != 1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.core.ecl.core", "Failed to execute verification (phase auto-detection failed)."));
                }
                String phase = phases[phases.length - 1];
                if (phase.equals("start")) {
                    VerificationsRuntime.getInstance().executeStart(verification, process);
                    break;
                }
                if (phase.equals("run")) {
                    VerificationsRuntime.getInstance().executeRun(verification, process);
                    break;
                }
                if (!phase.equals("finish")) break;
                VerificationsRuntime.getInstance().executeFinish(verification, process);
            }
        }
    }
}

