/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.ReadExcelFile;
import org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.EclDataApachePOIImplPlugin;
import org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands.ExcelFileService;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ReadExcelFileService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        ReadExcelFile ref = (ReadExcelFile)command;
        EList sheetNames = ref.getSheets();
        String uri = ref.getUri();
        EclFile file = FileResolver.resolve((String)uri);
        try {
            Workbook book = ExcelFileService.readBook(file);
            if (sheetNames != null && !sheetNames.isEmpty()) {
                for (String sheetName : sheetNames) {
                    if (book.getSheet(sheetName) == null) {
                        return EclDataApachePOIImplPlugin.createErr("Sheet %s does not persist in file %s", sheetName, file.toURI());
                    }
                    Table table = this.readTable(book, book.getSheetIndex(sheetName));
                    context.getOutput().write((Object)table);
                }
            } else {
                int sheetnum = 0;
                while (sheetnum < book.getNumberOfSheets()) {
                    Table table = this.readTable(book, sheetnum);
                    context.getOutput().write((Object)table);
                    ++sheetnum;
                }
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private Table readTable(Workbook book, int sheetnum) {
        Table table = ObjectsFactory.eINSTANCE.createTable();
        Sheet sheet = book.getSheetAt(sheetnum);
        table.setPageName(sheet.getSheetName());
        org.apache.poi.ss.usermodel.Row headers = sheet.getRow(0);
        if (headers == null) {
            return table;
        }
        this.readHeaders(table, headers);
        this.readRows(table, sheet);
        return table;
    }

    private void readHeaders(Table table, org.apache.poi.ss.usermodel.Row headers) {
        int cellnum = 0;
        while (headers.getCell(cellnum) != null) {
            Cell cell = headers.getCell(cellnum);
            table.getColumns().add((Object)ExcelFileService.getCellValue(cell));
            ++cellnum;
        }
    }

    private void readRows(Table table, Sheet sheet) {
        int rownum = 1;
        while (sheet.getRow(rownum) != null) {
            org.apache.poi.ss.usermodel.Row row = sheet.getRow(rownum);
            this.readRow(table, row);
            ++rownum;
        }
    }

    private void readRow(Table table, org.apache.poi.ss.usermodel.Row row) {
        Row tableRow = ObjectsFactory.eINSTANCE.createRow();
        int cellnum = 0;
        int size = table.getColumns().size();
        while (cellnum < size) {
            Cell cell = row.getCell(cellnum);
            tableRow.getValues().add((Object)ExcelFileService.getCellValue(cell));
            ++cellnum;
        }
        table.getRows().add((Object)tableRow);
    }
}

