/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands;

import java.util.List;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.WriteExcelFile;
import org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.EclDataApachePOIImplPlugin;
import org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands.ExcelFileService;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class WriteExcelFileService
implements ICommandService {
    private static final String SHEET_NAME_PATTERN = "Sheet%d";

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Workbook book;
        WriteExcelFile wef = (WriteExcelFile)command;
        EList tables = wef.getTables();
        String uri = wef.getUri();
        EclFile file = FileResolver.resolve((String)uri);
        boolean isAppend = wef.isAppend();
        isAppend &= file.toFile().exists();
        try {
            book = isAppend ? ExcelFileService.readBook(file) : ExcelFileService.createBook(file, uri);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        int sheetnum = 1;
        for (Table table : tables) {
            Sheet sheet;
            int rownum = 0;
            String sheetName = table.getPageName();
            if (sheetName == null || sheetName.equals("")) {
                sheetName = String.format(SHEET_NAME_PATTERN, sheetnum);
            }
            if ((sheet = book.getSheet(sheetName)) == null) {
                sheet = book.createSheet(sheetName);
                rownum = this.writeValues(rownum, sheet, (List<String>)table.getColumns());
            } else {
                rownum = this.resolveHeaders(sheet, table, file);
            }
            for (Row tableRow : table.getRows()) {
                rownum = this.writeRow(rownum, sheet, tableRow);
            }
            this.autoSizeColumns(sheet);
            context.getOutput().write((Object)table);
            ++sheetnum;
        }
        try {
            ExcelFileService.writeBook(book, file);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private int resolveHeaders(Sheet sheet, Table table, EclFile file) throws CoreException {
        org.apache.poi.ss.usermodel.Row header = sheet.getRow(0);
        if (header == null || header.getLastCellNum() == -1) {
            return this.writeValues(0, sheet, (List<String>)table.getColumns());
        }
        this.validateHeaders(sheet, table, file);
        return sheet.getLastRowNum() + 1;
    }

    private void validateHeaders(Sheet sheet, Table table, EclFile file) throws CoreException {
        org.apache.poi.ss.usermodel.Row headersRow = sheet.getRow(0);
        EList tableHeaders = table.getColumns();
        if (headersRow.getLastCellNum() != tableHeaders.size()) {
            throw new CoreException(EclDataApachePOIImplPlugin.createErr("Table headers length from input does not match with headers length in the file", file.toURI()));
        }
        int cellnum = 0;
        for (String tableHeader : tableHeaders) {
            Cell headerCell = headersRow.getCell(cellnum);
            if (headerCell == null || !tableHeader.equals(ExcelFileService.getCellValue(headerCell))) {
                throw new CoreException(EclDataApachePOIImplPlugin.createErr("%s table header from input does not match with header %d in the file", tableHeader, cellnum, file.toURI()));
            }
            ++cellnum;
        }
    }

    private int writeRow(int rownum, Sheet sheet, Row tableRow) {
        for (Row row : tableRow.getChildren()) {
            rownum = this.writeRow(rownum, sheet, row);
        }
        rownum = this.writeValues(rownum, sheet, (List<String>)tableRow.getValues());
        return rownum;
    }

    private int writeValues(int rownum, Sheet sheet, List<String> values) {
        org.apache.poi.ss.usermodel.Row row = sheet.createRow(rownum);
        ++rownum;
        int cellnum = 0;
        for (String value : values) {
            Cell cell = row.createCell(cellnum);
            if (value != null && value.startsWith("=")) {
                try {
                    cell.setCellFormula(value.replaceAll("^=", ""));
                }
                catch (FormulaParseException formulaParseException) {
                    cell.setCellValue(value);
                }
            } else {
                cell.setCellValue(value);
            }
            ++cellnum;
        }
        return rownum;
    }

    private void autoSizeColumns(Sheet sheet) {
        int length = sheet.getRow(0).getLastCellNum();
        if (length == -1) {
            return;
        }
        int col = 0;
        while (col < length) {
            sheet.autoSizeColumn(col);
            ++col;
        }
    }
}

