/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class ServletOutputStreamWrapper
extends ServletOutputStream {
    private OutputStream realOutput;
    private OutputStream spyStream;
    private boolean closed = false;

    public ServletOutputStreamWrapper(OutputStream realOutput, OutputStream duplicateStream) {
        this.realOutput = realOutput;
        this.spyStream = duplicateStream;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.realOutput != null) {
            this.realOutput.flush();
            this.realOutput.close();
        }
        this.spyStream.flush();
        this.spyStream.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this.realOutput != null) {
            this.realOutput.flush();
        }
        this.spyStream.flush();
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.realOutput != null) {
            this.realOutput.write((byte)b);
        }
        this.spyStream.write((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.realOutput != null) {
            this.realOutput.write(b, off, len);
        }
        this.spyStream.write(b, off, len);
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

