/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import java.lang.reflect.InvocationTargetException;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.util.LocaleUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EnvironmentSection
extends SectionPart {
    private ComboPart fOSCombo;
    private ComboPart fWSCombo;
    private ComboPart fNLCombo;
    private ComboPart fArchCombo;
    private TreeSet<String> fNLChoices;
    private TreeSet<String> fOSChoices;
    private TreeSet<String> fWSChoices;
    private TreeSet<String> fArchChoices;
    private boolean LOCALES_INITIALIZED = false;
    private TargetEditor fEditor;

    public EnvironmentSection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.fEditor = (TargetEditor)page.getEditor();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(PDEUIMessages.EnvironmentBlock_targetEnv);
        section.setDescription(PDEUIMessages.EnvironmentSection_description);
        GridData data = new GridData(768);
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(true, 2));
        client.setLayoutData((Object)new GridData(768));
        Composite left = toolkit.createComposite(client);
        left.setLayout((Layout)new GridLayout(2, false));
        GridLayout layout = FormLayoutFactory.createClearGridLayout(false, 2);
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        left.setLayout((Layout)layout);
        left.setLayoutData((Object)new GridData(768));
        this.initializeChoices();
        Label label = toolkit.createLabel(left, PDEUIMessages.EnvironmentSection_operationSystem);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fOSCombo = new ComboPart();
        this.fOSCombo.createControl(left, toolkit, 2052);
        this.fOSCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fOSCombo.setItems(this.fOSChoices.toArray(new String[this.fOSChoices.size()]));
        this.fOSCombo.setVisibleItemCount(30);
        label = toolkit.createLabel(left, PDEUIMessages.EnvironmentSection_windowingSystem);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fWSCombo = new ComboPart();
        this.fWSCombo.createControl(left, toolkit, 2052);
        this.fWSCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fWSCombo.setItems(this.fWSChoices.toArray(new String[this.fWSChoices.size()]));
        this.fWSCombo.setVisibleItemCount(30);
        Composite right = toolkit.createComposite(client);
        layout = FormLayoutFactory.createClearGridLayout(false, 2);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        right.setLayout((Layout)layout);
        right.setLayoutData((Object)new GridData(768));
        label = toolkit.createLabel(right, PDEUIMessages.EnvironmentSection_architecture);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fArchCombo = new ComboPart();
        this.fArchCombo.createControl(right, toolkit, 2052);
        this.fArchCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fArchCombo.setItems(this.fArchChoices.toArray(new String[this.fArchChoices.size()]));
        this.fArchCombo.setVisibleItemCount(30);
        label = toolkit.createLabel(right, PDEUIMessages.EnvironmentSection_locale);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fNLCombo = new ComboPart();
        this.fNLCombo.createControl(right, toolkit, 2308);
        this.fNLCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fNLCombo.setItems(this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
        this.fNLCombo.setVisibleItemCount(30);
        this.refresh();
        this.fOSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentSection.this.markDirty();
                EnvironmentSection.this.getTarget().setOS(EnvironmentSection.this.getText(EnvironmentSection.this.fOSCombo));
            }
        });
        this.fWSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentSection.this.markDirty();
                EnvironmentSection.this.getTarget().setWS(EnvironmentSection.this.getText(EnvironmentSection.this.fWSCombo));
            }
        });
        this.fArchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentSection.this.markDirty();
                EnvironmentSection.this.getTarget().setArch(EnvironmentSection.this.getText(EnvironmentSection.this.fArchCombo));
            }
        });
        this.fNLCombo.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                if (!EnvironmentSection.this.LOCALES_INITIALIZED) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                EnvironmentSection.this.initializeAllLocales();
                                EnvironmentSection.this.LOCALES_INITIALIZED = true;
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        PDEPlugin.log(e);
                    }
                    catch (InterruptedException e) {
                        PDEPlugin.log(e);
                    }
                }
                if (EnvironmentSection.this.fNLCombo.getItemCount() < 3) {
                    String current = EnvironmentSection.this.fNLCombo.getSelection();
                    if (!EnvironmentSection.this.fNLCombo.getControl().isDisposed()) {
                        EnvironmentSection.this.fNLCombo.setItems(EnvironmentSection.this.fNLChoices.toArray(new String[EnvironmentSection.this.fNLChoices.size()]));
                        EnvironmentSection.this.fNLCombo.setText(current);
                    }
                    EnvironmentSection.this.fNLCombo.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            String value = EnvironmentSection.this.getText(EnvironmentSection.this.fNLCombo);
                            if (value == null) {
                                EnvironmentSection.this.getTarget().setNL(null);
                            } else {
                                int index = value.indexOf("-");
                                if (index > 0) {
                                    value = value.substring(0, index);
                                }
                                EnvironmentSection.this.getTarget().setNL(value.trim());
                            }
                            EnvironmentSection.this.markDirty();
                        }
                    });
                }
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void initializeChoices() {
        ITargetDefinition target = this.getTarget();
        this.fOSChoices = new TreeSet();
        String[] os = Platform.knownOSValues();
        int i = 0;
        while (i < os.length) {
            this.fOSChoices.add(os[i]);
            ++i;
        }
        this.fOSChoices.add("");
        String fileValue = target.getOS();
        if (fileValue != null) {
            this.fOSChoices.add(fileValue);
        }
        this.fWSChoices = new TreeSet();
        String[] ws = Platform.knownWSValues();
        int i2 = 0;
        while (i2 < ws.length) {
            this.fWSChoices.add(ws[i2]);
            ++i2;
        }
        this.fWSChoices.add("");
        fileValue = target.getWS();
        if (fileValue != null) {
            this.fWSChoices.add(fileValue);
        }
        this.fArchChoices = new TreeSet();
        String[] arch = Platform.knownOSArchValues();
        int i3 = 0;
        while (i3 < arch.length) {
            this.fArchChoices.add(arch[i3]);
            ++i3;
        }
        this.fArchChoices.add("");
        fileValue = target.getArch();
        if (fileValue != null) {
            this.fArchChoices.add(fileValue);
        }
        this.fNLChoices = new TreeSet();
        this.fNLChoices.add("");
    }

    private void initializeAllLocales() {
        String[] nl = LocaleUtil.getLocales();
        int i = 0;
        while (i < nl.length) {
            this.fNLChoices.add(nl[i]);
            ++i;
        }
        String fileValue = this.getTarget().getNL();
        if (fileValue != null) {
            this.fNLChoices.add(LocaleUtil.expandLocaleName(fileValue));
        }
        this.LOCALES_INITIALIZED = true;
    }

    private String getText(ComboPart combo) {
        Control control = combo.getControl();
        String text = control instanceof Combo ? ((Combo)control).getText() : ((CCombo)control).getText();
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        return text;
    }

    public void refresh() {
        ITargetDefinition target = this.getTarget();
        String presetValue = target.getOS() == null ? "" : target.getOS();
        this.fOSCombo.setText(presetValue);
        presetValue = target.getWS() == null ? "" : target.getWS();
        this.fWSCombo.setText(presetValue);
        presetValue = target.getArch() == null ? "" : target.getArch();
        this.fArchCombo.setText(presetValue);
        presetValue = target.getNL() == null ? "" : LocaleUtil.expandLocaleName(target.getNL());
        this.fNLCombo.setText(presetValue);
        super.refresh();
    }

    protected void updateChoices() {
        if (this.LOCALES_INITIALIZED) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentSection.this.initializeAllLocales();
            }
        }).start();
    }
}

