/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class DiffRegionFormatter
extends DiffFormatter {
    private DocumentOutputStream stream;
    private List<DiffRegion> regions = new ArrayList<DiffRegion>();
    private List<FileDiffRegion> fileRegions = new ArrayList<FileDiffRegion>();
    private final int maxLines;
    private int linesWritten;

    public DiffRegionFormatter(IDocument document, int offset) {
        this(document, offset, -1);
    }

    public DiffRegionFormatter(IDocument document) {
        this(document, document.getLength(), -1);
    }

    public DiffRegionFormatter(IDocument document, int offset, int maxLines) {
        super((OutputStream)new DocumentOutputStream(document, offset));
        this.stream = (DocumentOutputStream)this.getOutputStream();
        this.maxLines = maxLines;
    }

    public DiffRegionFormatter write(Repository repository, FileDiff diff) throws IOException {
        this.stream.charset = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)diff.getPath());
        int start = this.stream.offset;
        diff.outputDiff(null, repository, this, true);
        this.flush();
        this.fileRegions.add(new FileDiffRegion(repository, diff, start, this.stream.offset - start));
        return this;
    }

    public DiffRegion[] getRegions() {
        return this.regions.toArray(new DiffRegion[this.regions.size()]);
    }

    public FileDiffRegion[] getFileRegions() {
        return this.fileRegions.toArray(new FileDiffRegion[this.fileRegions.size()]);
    }

    protected DiffRegion addRegion(DiffRegion.Type type, int start, int end) {
        if (!this.regions.isEmpty()) {
            DiffRegion last = this.regions.get(this.regions.size() - 1);
            if (last.diffType.equals((Object)type) && start == last.getOffset() + last.getLength()) {
                this.regions.remove(this.regions.size() - 1);
                start = last.getOffset();
            }
        }
        DiffRegion range = new DiffRegion(start, end - start, type);
        this.regions.add(range);
        return range;
    }

    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        int start = this.stream.offset;
        if (!this.regions.isEmpty()) {
            DiffRegion last = this.regions.get(this.regions.size() - 1);
            int lastEnd = last.getOffset() + last.getLength();
            if (last.diffType == DiffRegion.Type.HEADLINE && lastEnd < start) {
                this.addRegion(DiffRegion.Type.HEADER, lastEnd, start);
            }
        }
        super.writeHunkHeader(aStartLine, aEndLine, bStartLine, bEndLine);
        this.stream.flushLine();
        this.addRegion(DiffRegion.Type.HUNK, start, this.stream.offset);
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        if (this.maxLines > 0 && this.linesWritten > this.maxLines) {
            if (this.linesWritten == this.maxLines + 1) {
                int start = this.stream.offset;
                this.stream.flushLine();
                this.stream.write(NLS.bind((String)UIText.DiffStyleRangeFormatter_diffTruncated, (Object)this.maxLines));
                this.stream.write("\n");
                this.addRegion(DiffRegion.Type.HEADLINE, start, this.stream.offset);
                ++this.linesWritten;
            }
            return;
        }
        if (prefix == ' ') {
            super.writeLine(prefix, text, cur);
            this.stream.flushLine();
        } else {
            DiffRegion.Type type = prefix == '+' ? DiffRegion.Type.ADD : DiffRegion.Type.REMOVE;
            int start = this.stream.offset;
            super.writeLine(prefix, text, cur);
            this.stream.flushLine();
            this.addRegion(type, start, this.stream.offset);
        }
        ++this.linesWritten;
    }

    protected void formatGitDiffFirstHeaderLine(ByteArrayOutputStream o, DiffEntry.ChangeType type, String oldPath, String newPath) throws IOException {
        this.stream.flushLine();
        int offset = this.stream.offset;
        int start = o.size();
        super.formatGitDiffFirstHeaderLine(o, type, oldPath, newPath);
        int end = o.size();
        this.addRegion(DiffRegion.Type.HEADLINE, offset + start, offset + end);
    }

    public void format(EditList edits, RawText a, RawText b) throws IOException {
        this.stream.flushLine();
        super.format(edits, a, b);
    }

    public static class DiffRegion
    extends Region {
        public Type diffType = Type.OTHER;

        public DiffRegion(int offset, int length) {
            super(offset, length);
        }

        public DiffRegion(int offset, int length, Type type) {
            super(offset, length);
            this.diffType = type;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public static enum Type {
            ADD,
            REMOVE,
            HUNK,
            HEADLINE,
            HEADER,
            OTHER;

        }
    }

    private static class DocumentOutputStream
    extends OutputStream {
        private String charset;
        private IDocument document;
        private int offset;
        private StringBuilder lineBuffer = new StringBuilder();

        public DocumentOutputStream(IDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        private void write(String content) throws IOException {
            try {
                this.document.replace(this.offset, 0, content);
                this.offset += content.length();
            }
            catch (BadLocationException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.charset == null) {
                this.lineBuffer.append(new String(b, off, len, "UTF-8"));
            } else {
                this.lineBuffer.append(new String(b, off, len, this.charset));
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void flush() throws IOException {
            this.flushLine();
        }

        protected void flushLine() throws IOException {
            if (this.lineBuffer.length() > 0) {
                this.write(this.lineBuffer.toString());
                this.lineBuffer.setLength(0);
            }
        }
    }

    public static class FileDiffRegion
    extends Region {
        private final FileDiff diff;
        private final Repository repository;

        public FileDiffRegion(Repository repository, FileDiff fileDiff, int start, int length) {
            super(start, length);
            this.diff = fileDiff;
            this.repository = repository;
        }

        public FileDiff getDiff() {
            return this.diff;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "[FileDiffRange " + (this.diff == null ? "null" : this.diff.getPath()) + ' ' + super.toString() + ']';
        }
    }
}

