/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

class PackageSelectionStringButtonAdapter
implements IStringButtonAdapter {
    private final SourceFirstPackageSelectionDialogField fPackageSelectionField;
    private String fEmtpyListMessage;
    private String fMessage;
    private String fTitle;

    PackageSelectionStringButtonAdapter(SourceFirstPackageSelectionDialogField field, String title, String message, String emtpyListMessage) {
        this.fPackageSelectionField = field;
        this.fTitle = title;
        this.fMessage = message;
        this.fEmtpyListMessage = emtpyListMessage;
    }

    @Override
    public void changeControlPressed(DialogField field) {
        IPackageFragmentRoot root = this.fPackageSelectionField.getSelectedFragmentRoot();
        Object[] packages = null;
        try {
            if (root != null && root.exists()) {
                packages = root.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(field.getLabelControl(null).getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(true);
        dialog.setTitle(this.fTitle);
        dialog.setMessage(this.fMessage);
        dialog.setEmptyListMessage(this.fEmtpyListMessage);
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            this.fPackageSelectionField.setSelected(fragment);
        }
    }
}

