/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.html;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.html.FullSingleTestHtmlRenderer;
import org.eclipse.rcptt.reporting.html.internal.Plugin;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.util.FileUtil;

public class HtmlReportRenderer
implements IReportRenderer {
    private final String summaryTemplate = HtmlReportRenderer.loadAsString("/templates/summary.html");
    protected final NumberFormat durationFormat = NumberFormat.getNumberInstance();
    private int screenshotCount;
    private static final Function<Report, Integer> reportStatus = new Function<Report, Integer>(){

        public Integer apply(Report input) {
            if (input.getRoot() == null) {
                return 4;
            }
            Q7Info info = (Q7Info)input.getRoot().getProperties().get((Object)"q7");
            if (info == null || info.getResult() == null) {
                return 4;
            }
            return info.getResult().getSeverity();
        }
    };

    public HtmlReportRenderer() {
        this.durationFormat.setMaximumFractionDigits(1);
        this.durationFormat.setMinimumFractionDigits(1);
        this.screenshotCount = 0;
    }

    static String loadAsString(String path) {
        try {
            byte[] content = FileUtil.getStreamContent((InputStream)HtmlReportRenderer.class.getResourceAsStream(path));
            return new String(content, Charsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load " + path);
        }
    }

    public IStatus generateReport(IReportRenderer.IContentFactory factory, String reportName, Iterable<Report> reportList) {
        PrintWriter writer = null;
        try {
            try {
                OutputStream stream = factory.createFileStream(String.valueOf(reportName) + ".html");
                writer = new PrintWriter(new OutputStreamWriter(stream, Charsets.UTF_8));
                this.renderReport(writer, reportList, factory);
            }
            catch (Exception e) {
                IStatus iStatus = Plugin.UTILS.createError((Throwable)e);
                FileUtil.safeClose(writer);
                return iStatus;
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(writer);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)writer);
        return Status.OK_STATUS;
    }

    protected void renderReport(PrintWriter writer, Iterable<Report> reports, IReportRenderer.IContentFactory content) throws CoreException {
        writer.println("<html>");
        this.renderHead(writer, null);
        writer.println("<body onload=\"installDetailsWorkaround()\">");
        Q7Statistics statistics = ReportUtils.calculateStatistics(reports.iterator());
        this.renderSummary(writer, reports, statistics);
        Iterable passedReports = Iterables.filter(reports, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)0), reportStatus));
        Iterable skippedReports = Iterables.filter(reports, (Predicate)Predicates.compose(this.matches(8), reportStatus));
        Iterable failedReports = Iterables.filter(reports, (Predicate)Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.or((Predicate)Predicates.equalTo((Object)0), this.matches(8))), reportStatus));
        writer.println("<h1 class=\"failure\">Failed Tests (" + statistics.getFailed() + ")</h1>");
        this.renderFailed(writer, content, failedReports);
        writer.println("<h1 class=\"skipped\">Skipped Tests (" + statistics.getSkipped() + ")</h1>");
        writer.println("<table class=\"skipped\">");
        for (Report report : skippedReports) {
            this.renderNameAndDuration(writer, report, content);
        }
        writer.println("</table>");
        writer.println("<details class=\"closed\"><summary><h1 class=\"passed\">Passed Tests (" + statistics.getPassed() + ")</h1></summary>");
        writer.println("<table class=\"passed detailsContent\">");
        for (Report report : passedReports) {
            this.renderNameAndDuration(writer, report, content);
        }
        writer.println("</table>");
        writer.println("</body></html>");
    }

    protected void renderHead(PrintWriter writer, String title) {
        writer.println("<head>");
        if (!Strings.isNullOrEmpty((String)title)) {
            writer.println("<title>" + title + "</title>");
        }
        writer.println("<style>");
        writer.println(HtmlReportRenderer.loadAsString("/templates/rcptt.css"));
        writer.println("</style>");
        writer.println("<script type=\"text/javascript\">");
        writer.println(HtmlReportRenderer.loadAsString("/templates/rcptt.js"));
        writer.println("</script>");
        writer.println("</head>");
    }

    protected void renderFailed(PrintWriter writer, IReportRenderer.IContentFactory content, Iterable<Report> failedReports) throws CoreException {
        for (Report report : failedReports) {
            try {
                this.renderFailed(writer, report, content);
                writer.println("<hr/>");
            }
            catch (Exception e) {
                Plugin.UTILS.log(Plugin.UTILS.createError((Throwable)e));
                e.printStackTrace(writer);
            }
        }
    }

    protected void renderNameAndDuration(PrintWriter writer, Report report, IReportRenderer.IContentFactory content) throws CoreException {
        Node root = report.getRoot();
        long millseconds = root.getDuration();
        String duration = this.durationFormat.format((float)millseconds / 1000.0f);
        writer.println("<tr><td>" + root.getName() + "</td><td>" + duration + " s</td></tr>");
    }

    protected void renderFailed(PrintWriter writer, Report report, IReportRenderer.IContentFactory content) {
        final IReportRenderer.IContentFactory images = content.createFolder("images");
        FullSingleTestHtmlRenderer renderer = new FullSingleTestHtmlRenderer(writer, this.durationFormat, new Function<Screenshot, String>(){

            public String apply(Screenshot input) {
                StringBuilder stringBuilder = new StringBuilder("images/");
                Object[] objectArray = new Object[1];
                HtmlReportRenderer htmlReportRenderer = HtmlReportRenderer.this;
                int n = htmlReportRenderer.screenshotCount;
                htmlReportRenderer.screenshotCount = n + 1;
                objectArray[0] = n;
                return stringBuilder.append(HtmlReportRenderer.this.writeScreenshot(images, String.format("%3d", objectArray), input)).toString();
            }
        });
        renderer.render(report);
    }

    private void renderSummary(PrintWriter writer, Iterable<Report> reports, Q7Statistics statistics) {
        this.renderStatistics(writer, statistics);
    }

    private void renderStatistics(PrintWriter writer, Q7Statistics statistics) {
        Replacer r = new Replacer(this.summaryTemplate);
        this.fillStatistics(statistics, r);
        writer.append(r.toString());
    }

    private int percent(int value, int total) {
        return (int)((float)value / (float)total * 100.0f);
    }

    private void fillStatistics(Q7Statistics statistics, Replacer r) {
        r.replace("totalCount", statistics.getTotal());
        r.replace("failedCount", statistics.getFailed());
        r.replace("failedPercent", this.percent(statistics.getFailed(), statistics.getTotal()));
        r.replace("skippedPercent", this.percent(statistics.getSkipped(), statistics.getTotal()));
        r.replace("skippedCount", statistics.getSkipped());
        r.replace("elapsed", this.durationFormat.format((float)statistics.getTime() / 1000.0f));
    }

    public String[] getGeneratedFileNames(String reportName) {
        return new String[]{String.valueOf(reportName) + ".html"};
    }

    Predicate<Integer> matches(final int mask) {
        return new Predicate<Integer>(){

            public boolean apply(Integer input) {
                return (input & mask) != 0;
            }
        };
    }

    private String writeScreenshot(IReportRenderer.IContentFactory images, String key, Screenshot value) {
        String ext = value.getKind().name().toLowerCase();
        String fileName = String.valueOf(key) + "." + ext;
        OutputStream stream = null;
        try {
            try {
                stream = images.createFileStream(fileName);
                stream.write(value.getData());
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to write screenshot " + key);
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(stream);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)stream);
        return fileName;
    }

    protected String getNodeName(Node node) {
        String name = node.getName();
        Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
        if (info != null && info.getVariant() != null && info.getVariant().size() != 0) {
            name = String.valueOf(name) + "_" + ReportUtils.combineNames((EList)info.getVariant(), (String)",");
        }
        name = name.trim().replace(" ", "");
        return FileUtil.rlimitSize((String)FileUtil.getID((String)name), (int)20).toLowerCase();
    }

    private static class Replacer {
        private String current;

        public Replacer(String current) {
            this.current = current;
        }

        public void replace(String key, String value) {
            this.current = this.current.replaceAll("\\$\\{" + key + "\\}", value);
        }

        public void replace(String key, int value) {
            this.replace(key, "" + value);
        }

        public String toString() {
            return this.current;
        }
    }
}

