/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.views.launch.Decoration;

public class DecorationManager {
    private static Map<IDebugTarget, List<Decoration>> fDecorations = new HashMap<IDebugTarget, List<Decoration>>(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDecoration(Decoration decoration) {
        Map<IDebugTarget, List<Decoration>> map = fDecorations;
        synchronized (map) {
            IDebugTarget target = decoration.getThread().getDebugTarget();
            List<Decoration> list = fDecorations.get(target);
            if (list == null) {
                list = new ArrayList<Decoration>();
                fDecorations.put(target, list);
            }
            list.add(decoration);
        }
    }

    public static void removeDecorations(IDebugTarget target) {
        DecorationManager.doRemoveDecorations(target, null);
    }

    public static void removeDecorations(IThread thread) {
        DecorationManager.doRemoveDecorations(thread.getDebugTarget(), thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRemoveDecorations(IDebugTarget target, IThread thread) {
        ArrayList<Decoration> decorationsToRemove = new ArrayList<Decoration>();
        Map<IDebugTarget, List<Decoration>> map = fDecorations;
        synchronized (map) {
            List<Decoration> list = fDecorations.get(target);
            if (list != null) {
                ListIterator<Decoration> iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Decoration decoration = iterator.next();
                    if (thread != null && !thread.equals(decoration.getThread())) continue;
                    decorationsToRemove.add(decoration);
                    iterator.remove();
                }
                if (list.isEmpty()) {
                    fDecorations.remove(target);
                }
            }
        }
        for (Decoration decoration : decorationsToRemove) {
            decoration.remove();
        }
    }
}

