/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Combo;

public class BundleProviderHistoryUtil {
    private static final String S_PROVIDERS = "providers";

    public static void loadHistory(Combo combo, IDialogSettings settings) {
        if (combo == null || settings == null) {
            return;
        }
        String[] providers = settings.getArray(S_PROVIDERS);
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                combo.add(providers[i]);
                ++i;
            }
        }
    }

    public static void saveHistory(Combo combo, IDialogSettings settings) {
        if (combo == null) {
            return;
        }
        String text = combo.getText();
        if (text.length() == 0) {
            return;
        }
        int indexOfText = combo.indexOf(text);
        if (indexOfText != -1) {
            combo.remove(indexOfText);
        }
        combo.add(text, 0);
        String[] items = combo.getItems();
        if (items != null && items.length > 0) {
            settings.put(S_PROVIDERS, items);
        }
    }
}

