/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.ConfigureProblemSeverityAction;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.text.IDocument;

public class ConfigureProblemSeveritySubProcessor {
    public static final boolean hasConfigureProblemSeverityProposal(int problemId) {
        return JavaCore.getOptionForConfigurableSeverity((int)problemId) != null;
    }

    public static void addConfigureProblemSeverityProposal(final IInvocationContext context, final IProblemLocation problem, Collection<ICommandAccess> proposals) {
        final int problemId = problem.getProblemId();
        final String optionId = JavaCore.getOptionForConfigurableSeverity((int)problemId);
        if (optionId == null) {
            return;
        }
        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(CorrectionMessages.ConfigureProblemSeveritySubProcessor_name, null, -11, JavaPluginImages.get("org.eclipse.jdt.ui.configure_problem_severity.png")){

            @Override
            public void apply(IDocument document) {
                ConfigureProblemSeverityAction problemSeverityAction = new ConfigureProblemSeverityAction(context.getCompilationUnit().getJavaProject(), optionId, (problemId & Integer.MIN_VALUE) != 0, null);
                problemSeverityAction.run();
            }

            @Override
            public String getAdditionalProposalInfo(IProgressMonitor monitor) {
                String problemMsg = "";
                IProblem[] iProblemArray = context.getASTRoot().getProblems();
                int n = iProblemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem iProblem = iProblemArray[n2];
                    if (problem.getProblemId() == iProblem.getID() && problem.getOffset() == iProblem.getSourceStart() && problem.getLength() == iProblem.getSourceEnd() - iProblem.getSourceStart() + 1) {
                        problemMsg = iProblem.getMessage();
                        break;
                    }
                    ++n2;
                }
                return Messages.format(CorrectionMessages.ConfigureProblemSeveritySubProcessor_info, new String[]{problemMsg});
            }
        };
        proposals.add(proposal);
    }
}

