/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.merge;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.merge.GitCachedResourceVariantTree;
import org.eclipse.egit.core.internal.merge.GitResourceVariantCache;
import org.eclipse.egit.core.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.egit.core.internal.storage.IndexResourceVariant;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.variants.IResourceVariantTree;

public class DirCacheResourceVariantTreeProvider
implements GitResourceVariantTreeProvider {
    private final IResourceVariantTree baseTree;
    private final IResourceVariantTree sourceTree;
    private final IResourceVariantTree remoteTree;
    private final Set<IResource> roots;
    private final Set<IResource> knownResources;

    public DirCacheResourceVariantTreeProvider(Repository repository) throws IOException {
        DirCache cache = repository.readDirCache();
        GitResourceVariantCache baseCache = new GitResourceVariantCache();
        GitResourceVariantCache sourceCache = new GitResourceVariantCache();
        GitResourceVariantCache remoteCache = new GitResourceVariantCache();
        int i = 0;
        while (i < cache.getEntryCount()) {
            DirCacheEntry entry = cache.getEntry(i);
            Path path = new Path(entry.getPathString());
            IResource resource = ResourceUtil.getResourceHandleForLocation((IPath)path);
            if (resource.getProject() != null && resource.getProject().isAccessible()) {
                switch (entry.getStage()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        baseCache.setVariant(resource, IndexResourceVariant.create(repository, entry));
                        break;
                    }
                    case 2: {
                        sourceCache.setVariant(resource, IndexResourceVariant.create(repository, entry));
                        break;
                    }
                    case 3: {
                        remoteCache.setVariant(resource, IndexResourceVariant.create(repository, entry));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid stage: " + entry.getStage());
                    }
                }
            }
            ++i;
        }
        this.baseTree = new GitCachedResourceVariantTree(baseCache);
        this.sourceTree = new GitCachedResourceVariantTree(sourceCache);
        this.remoteTree = new GitCachedResourceVariantTree(remoteCache);
        this.roots = new LinkedHashSet<IResource>();
        this.roots.addAll(baseCache.getRoots());
        this.roots.addAll(sourceCache.getRoots());
        this.roots.addAll(remoteCache.getRoots());
        this.knownResources = new LinkedHashSet<IResource>();
        this.knownResources.addAll(baseCache.getKnownResources());
        this.knownResources.addAll(sourceCache.getKnownResources());
        this.knownResources.addAll(remoteCache.getKnownResources());
    }

    @Override
    public IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    @Override
    public IResourceVariantTree getRemoteTree() {
        return this.remoteTree;
    }

    @Override
    public IResourceVariantTree getSourceTree() {
        return this.sourceTree;
    }

    @Override
    public Set<IResource> getKnownResources() {
        return this.knownResources;
    }

    @Override
    public Set<IResource> getRoots() {
        return this.roots;
    }
}

