/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.log.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.rcptt.verifications.log.ErrorLogVerification;
import org.eclipse.rcptt.verifications.log.LogEntryPredicate;
import org.eclipse.rcptt.verifications.log.LogFactory;
import org.eclipse.rcptt.verifications.log.LogPackage;

public class ErrorLogUtil {
    private static final int[] MASKS = new int[]{4, 2, 1};
    private static final String[] NAMES = new String[]{"ERROR", "WARNING", "INFO"};

    public static boolean match(LogEntryPredicate predicate, IStatus status) {
        if (!LogPackage.Literals.LOG_ENTRY_PREDICATE__CODE.getDefaultValue().equals(predicate.getCode()) && predicate.getCode() != status.getCode()) {
            return false;
        }
        if (!status.matches(predicate.getSeverityMask())) {
            return false;
        }
        if (!status.getMessage().matches(predicate.getMessagePattern())) {
            return false;
        }
        return status.getPlugin().matches(predicate.getPluginPattern());
    }

    public static LogEntryPredicate find(Iterable<LogEntryPredicate> predicates, IStatus status) {
        for (LogEntryPredicate predicate : predicates) {
            if (!ErrorLogUtil.match(predicate, status)) continue;
            return predicate;
        }
        return null;
    }

    public static boolean includes(LogEntryPredicate wide, LogEntryPredicate specific) {
        if ((specific.getSeverityMask() & ~wide.getSeverityMask()) != 0) {
            return false;
        }
        if (!LogPackage.Literals.LOG_ENTRY_PREDICATE__CODE.getDefaultValue().equals(wide.getCode()) && wide.getCode() == specific.getCode()) {
            return false;
        }
        if (!StringUtils.nullToEmpty((String)specific.getMessagePattern()).matches(StringUtils.nullToEmpty((String)wide.getMessagePattern()))) {
            return false;
        }
        return StringUtils.nullToEmpty((String)specific.getPluginPattern()).matches(StringUtils.nullToEmpty((String)wide.getPluginPattern()));
    }

    public static LogEntryPredicate createMatchingPredicate(IStatus status) {
        LogEntryPredicate rv = LogFactory.eINSTANCE.createLogEntryPredicate();
        rv.setCode(status.getCode());
        rv.setSeverityMask(status.getSeverity());
        rv.setMessagePattern(status.getMessage());
        rv.setPluginPattern(status.getPlugin());
        assert (ErrorLogUtil.match(rv, status));
        return rv;
    }

    public static int getIndex(LogEntryPredicate predicate) {
        ErrorLogVerification parent = (ErrorLogVerification)predicate.eContainer();
        if (parent == null) {
            throw new NullPointerException("Predicate should be stored in a verification");
        }
        List<LogEntryPredicate> content = ErrorLogUtil.getPredicates(parent);
        int rv = content.indexOf(predicate);
        assert (rv >= 0);
        return rv;
    }

    protected static List<LogEntryPredicate> getPredicates(ErrorLogVerification parent) {
        ArrayList<LogEntryPredicate> content = new ArrayList<LogEntryPredicate>();
        content.addAll((Collection<LogEntryPredicate>)parent.getRequired());
        content.addAll((Collection<LogEntryPredicate>)parent.getAllowed());
        content.addAll((Collection<LogEntryPredicate>)parent.getDenied());
        return content;
    }

    public static LogEntryPredicate getPredicateByIndex(ErrorLogVerification parent, int index) {
        assert (index >= 0);
        List<LogEntryPredicate> content = ErrorLogUtil.getPredicates(parent);
        if (index >= content.size()) {
            return null;
        }
        LogEntryPredicate rv = content.get(index);
        assert (rv != null);
        assert (ErrorLogUtil.getIndex(rv) == index);
        return rv;
    }

    private static String severityToString(int severity) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < MASKS.length) {
            if ((MASKS[i] & severity) != 0) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(NAMES[i]);
                first = false;
            }
            ++i;
        }
        if (first) {
            sb.append("NO SEVERITY");
        }
        return sb.toString();
    }

    public static String describe(LogEntryPredicate predicate) {
        StringBuilder sb = new StringBuilder();
        sb.append(ErrorLogUtil.severityToString(predicate.getSeverityMask()));
        if (!LogPackage.Literals.LOG_ENTRY_PREDICATE__CODE.getDefaultValue().equals(predicate.getCode())) {
            sb.append("code: " + predicate.getCode());
        }
        if (!".*".equals(predicate.getPluginPattern())) {
            sb.append(", plugin: " + StringUtils.nullToEmpty((String)predicate.getPluginPattern()));
        }
        if (!".*".equals(predicate.getMessagePattern())) {
            sb.append(", message: " + StringUtils.nullToEmpty((String)predicate.getMessagePattern()));
        }
        return sb.toString();
    }

    public static String describe(IStatus status) {
        return status.toString();
    }
}

