/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.events;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rcptt.tesla.swt.aspects.rap.SWTAspectActivator;
import org.eclipse.rcptt.tesla.swt.events.ITeslaBrowserListener;
import org.eclipse.rcptt.util.ListUtil;
import org.eclipse.rcptt.util.Predicate;
import org.eclipse.swt.browser.Browser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeslaBrowserManager {
    private static TeslaBrowserManager manager = new TeslaBrowserManager();
    private Set<ITeslaBrowserListener> listeners = new HashSet<ITeslaBrowserListener>();
    private Set<WeakReference<Browser>> browsers = new HashSet<WeakReference<Browser>>();

    private TeslaBrowserManager() {
    }

    public static TeslaBrowserManager getManager() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ITeslaBrowserListener listener) {
        Set<ITeslaBrowserListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(ITeslaBrowserListener listener) {
        Set<ITeslaBrowserListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Set<ITeslaBrowserListener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
    }

    public void notifyAdded(Browser br) {
        List<ITeslaBrowserListener> copy = this.getListeners();
        for (ITeslaBrowserListener listener : copy) {
            listener.browserAdded(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITeslaBrowserListener> getListeners() {
        ArrayList<ITeslaBrowserListener> copy = null;
        Set<ITeslaBrowserListener> set = this.listeners;
        synchronized (set) {
            copy = new ArrayList<ITeslaBrowserListener>(this.listeners);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Set<ITeslaBrowserListener> set = this.listeners;
        synchronized (set) {
            return !this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBrowser(Browser browser) {
        block5: {
            try {
                if (browser == null || browser.isDisposed()) break block5;
                Set<WeakReference<Browser>> set = this.browsers;
                synchronized (set) {
                    this.browsers.add(new WeakReference<Browser>(browser));
                }
                this.notifyAdded(browser);
            }
            catch (Throwable e) {
                SWTAspectActivator.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Browser[] getBrowsers() {
        Set<WeakReference<Browser>> set = this.browsers;
        synchronized (set) {
            final ArrayList result = new ArrayList();
            ListUtil.excludeInPlace(this.browsers, (Predicate)new Predicate<WeakReference<Browser>>(){

                public boolean apply(WeakReference<Browser> input) {
                    Browser browser = (Browser)input.get();
                    if (browser != null && !browser.isDisposed()) {
                        result.add(browser);
                        return false;
                    }
                    return true;
                }
            });
            return result.toArray(new Browser[result.size()]);
        }
    }

    public synchronized void browserSetText(Browser browser) {
        List<ITeslaBrowserListener> copy = this.getListeners();
        for (ITeslaBrowserListener listener : copy) {
            listener.browserSetText(browser);
        }
    }

    public void beginChanging(Browser browser) {
        List<ITeslaBrowserListener> copy = this.getListeners();
        for (ITeslaBrowserListener listener : copy) {
            listener.browserChanged(browser);
        }
    }
}

