/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.internal.core.jobs.IJob;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread processingThread;
    protected Job progressJob;
    private int enableCount = 1;
    public boolean activated = false;
    private int awaitingClients = 0;
    private final Object delaySignal = new Object();

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public synchronized void disable() {
        --this.enableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) {
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.processingThread != null && this.executing) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (i <= this.jobEnd) {
                    currentJob = this.awaitingJobs[i];
                    if (currentJob != null) {
                        this.awaitingJobs[i] = null;
                        if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                            this.awaitingJobs[++loc] = currentJob;
                        } else {
                            currentJob.cancel();
                        }
                    }
                    ++i;
                }
                this.jobStart = 0;
                this.jobEnd = loc;
            }
        }
        finally {
            this.enable();
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        this.notifyAll();
    }

    public synchronized boolean isJobWaiting(IJob request) {
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request.equals(this.awaitingJobs[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress) {
        return this.performConcurrentJob(searchJob, waitingPolicy, progress, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress, long timeout) {
        block39: {
            searchJob.ensureReadyToRun();
            concurrentJobWork = 100;
            if (progress != null) {
                progress.beginTask("", concurrentJobWork);
            }
            status = false;
            if (this.awaitingJobsCount() <= 0) break block39;
            switch (waitingPolicy) {
                case 1: {
                    try {
                        this.disable();
                        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
                    }
                    finally {
                        this.enable();
                    }
                    return status;
                }
                case 2: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    start = System.currentTimeMillis();
                    subProgress = null;
                    totalWork = this.awaitingJobsCount();
                    if (progress != null && totalWork > 0) {
                        subProgress = new SubProgressMonitor(progress, concurrentJobWork / 2);
                        subProgress.beginTask("", totalWork);
                        concurrentJobWork /= 2;
                    }
                    if (totalWork > 0) {
                        var12_11 = this.delaySignal;
                        synchronized (var12_11) {
                            this.delaySignal.notify();
                        }
                    }
                    originalPriority = (t = this.processingThread) == null ? -1 : t.getPriority();
                    try {
                        if (t != null) {
                            t.setPriority(Thread.currentThread().getPriority());
                        }
                        var14_13 = this;
                        synchronized (var14_13) {
                            ++this.awaitingClients;
                        }
                        previousJob = null;
                        while ((awaitingWork = this.awaitingJobsCount()) > 0 && (timeout == -1L || System.currentTimeMillis() - start < timeout)) {
                            if (subProgress != null && subProgress.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            currentJob = this.currentJob();
                            if (currentJob != null && currentJob != previousJob) {
                                if (subProgress != null) {
                                    subProgress.subTask(NLS.bind((String)"Files to index ${0}", (Object)Integer.toString(awaitingWork)));
                                    subProgress.worked(1);
                                }
                                previousJob = currentJob;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException v2) {}
                        }
                        if (timeout == -1L || System.currentTimeMillis() - start <= timeout) ** GOTO lbl83
                        var18_16 = this;
                    }
                    catch (Throwable var17_19) {
                        var18_17 = this;
                        synchronized (var18_17) {
                            --this.awaitingClients;
                        }
                        if (t != null && originalPriority > -1 && t.isAlive()) {
                            t.setPriority(originalPriority);
                        }
                        throw var17_19;
                    }
                    synchronized (var18_16) {
                        --this.awaitingClients;
                    }
                    if (t != null && originalPriority > -1 && t.isAlive()) {
                        t.setPriority(originalPriority);
                    }
                    return false;
lbl83:
                    // 1 sources

                    var18_18 = this;
                    synchronized (var18_18) {
                        --this.awaitingClients;
                    }
                    if (t != null && originalPriority > -1 && t.isAlive()) {
                        t.setPriority(originalPriority);
                    }
                    if (subProgress == null) break;
                    subProgress.done();
                }
            }
        }
        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
        if (progress != null) {
            progress.done();
        }
        return status;
    }

    public abstract String processName();

    public void waitUntilReady(IProgressMonitor monitor) {
        this.performConcurrentJob(new WaitJob(), 3, monitor);
    }

    public void requestIfNotWaiting(IJob job) {
        if (!this.isJobWaiting(job)) {
            this.request(job);
        }
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        this.notifyAll();
    }

    public synchronized void reset() {
        if (this.processingThread != null) {
            this.discardJobs(null);
        } else {
            this.processingThread = new Thread((Runnable)this, this.processName());
            this.processingThread.setDaemon(true);
            this.processingThread.setPriority(4);
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            this.progressJob = null;
            while (this.processingThread != null) {
                try {
                    JobManager jobManager;
                    boolean waitAC;
                    IJob job;
                    Object object = this;
                    synchronized (object) {
                        if (this.processingThread == null) {
                            continue;
                        }
                        job = this.currentJob();
                        if (job == null) {
                            this.hideProgress();
                            if (idlingStart < 0L) {
                                idlingStart = System.currentTimeMillis();
                            } else {
                                this.notifyIdle(System.currentTimeMillis() - idlingStart);
                            }
                            this.wait();
                        } else {
                            idlingStart = -1L;
                        }
                    }
                    if (job == null) {
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        object = this.delaySignal;
                        synchronized (object) {
                            this.delaySignal.wait(500L);
                            continue;
                        }
                    }
                    try {
                        this.executing = true;
                        this.showProgress();
                        job.execute(null);
                    }
                    catch (Throwable throwable) {
                        this.executing = false;
                        this.moveToNextJob();
                        waitAC = false;
                        jobManager = this;
                        synchronized (jobManager) {
                            waitAC = this.awaitingClients == 0;
                        }
                        if (waitAC) {
                            Thread.sleep(50L);
                        }
                        throw throwable;
                    }
                    this.executing = false;
                    this.moveToNextJob();
                    waitAC = false;
                    jobManager = this;
                    synchronized (jobManager) {
                        waitAC = this.awaitingClients == 0;
                    }
                    if (!waitAC) continue;
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.processingThread != null) {
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
        catch (Error e) {
            if (this.processingThread != null && !(e instanceof ThreadDeath)) {
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
    }

    private void showProgress() {
        if (this.progressJob == null) {
            this.progressJob = new ProgressJob("Indexing in progress...");
            this.progressJob.setPriority(30);
            this.progressJob.setSystem(true);
            this.progressJob.schedule();
        }
    }

    private void hideProgress() {
        if (this.progressJob != null) {
            this.progressJob.cancel();
            this.progressJob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.processingThread;
        try {
            Job job;
            if (thread != null) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join(60000L);
            }
            if ((job = this.progressJob) != null) {
                job.cancel();
                job.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private final class ProgressJob
    extends Job {
        ProgressJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            int awaitingJobsCount;
            monitor.beginTask("Indexin Q7 resources...", -1);
            while (!monitor.isCanceled() && (awaitingJobsCount = JobManager.this.awaitingJobsCount()) > 0) {
                monitor.subTask(NLS.bind((String)"Files to index ${0}", (Object)Integer.toString(awaitingJobsCount)));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    private static final class WaitJob
    implements IJob {
        private WaitJob() {
        }

        @Override
        public boolean belongsTo(String jobFamily) {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void ensureReadyToRun() {
        }

        @Override
        public boolean execute(IProgressMonitor progress) {
            return false;
        }

        public String toString() {
            return "WAIT-UNTIL-READY-JOB";
        }
    }
}

