/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewInterfaceWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public class NewInterfaceCreationWizard
extends NewElementWizard {
    private NewInterfaceWizardPage fPage;
    private boolean fOpenEditorOnFinish;

    public NewInterfaceCreationWizard(NewInterfaceWizardPage page, boolean openEditorOnFinish) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWINT);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.NewInterfaceCreationWizard_title);
        this.fPage = page;
        this.fOpenEditorOnFinish = openEditorOnFinish;
    }

    public NewInterfaceCreationWizard() {
        this(null, true);
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new NewInterfaceWizardPage();
            this.fPage.init(this.getSelection());
        }
        this.addPage((IWizardPage)this.fPage);
    }

    @Override
    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }

    @Override
    public boolean performFinish() {
        IResource resource;
        this.warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res && (resource = this.fPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            if (this.fOpenEditorOnFinish) {
                this.openResource((IFile)resource);
            }
        }
        return res;
    }

    @Override
    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }
}

