/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.common;

import org.eclipse.core.runtime.ListenerList;

public abstract class EventManager {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private volatile ListenerList<Object> listenerList = null;

    protected final synchronized void addListenerObject(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add(listener);
    }

    protected final void clearListeners() {
        this.listenerList = null;
    }

    protected final Object[] getListeners() {
        ListenerList<Object> list = this.listenerList;
        if (list == null) {
            return EMPTY_ARRAY;
        }
        return list.getListeners();
    }

    protected final boolean isListenerAttached() {
        return this.listenerList != null;
    }

    protected final synchronized void removeListenerObject(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }
}

