/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

public final class LoggedNewNameQueries
implements INewNameQueries {
    private final ReorgExecutionLog fLog;

    public LoggedNewNameQueries(ReorgExecutionLog log) {
        this.fLog = log;
    }

    @Override
    public INewNameQuery createNewCompilationUnitNameQuery(ICompilationUnit unit, String initialSuggestedName) {
        return new NewNameQuery(unit, initialSuggestedName);
    }

    @Override
    public INewNameQuery createNewPackageFragmentRootNameQuery(IPackageFragmentRoot root, String initialSuggestedName) {
        return new NewNameQuery(root, initialSuggestedName);
    }

    @Override
    public INewNameQuery createNewPackageNameQuery(IPackageFragment fragment, String initialSuggestedName) {
        return new NewNameQuery(fragment, initialSuggestedName);
    }

    @Override
    public INewNameQuery createNewResourceNameQuery(IResource resource, String initialSuggestedName) {
        return new NewNameQuery(resource, initialSuggestedName);
    }

    @Override
    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    @Override
    public INewNameQuery createStaticQuery(final String name) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                return name;
            }
        };
    }

    private final class NewNameQuery
    implements INewNameQuery {
        private final String fName;
        private final Object fObject;

        public NewNameQuery(Object object, String name) {
            this.fObject = object;
            this.fName = name;
        }

        private String getCompilationUnitName() {
            int index;
            String name = LoggedNewNameQueries.this.fLog.getNewName(this.fObject);
            if (name != null && (index = name.lastIndexOf(46)) > 0) {
                name = name.substring(0, index);
            }
            return name;
        }

        @Override
        public String getNewName() {
            String name = null;
            name = this.fObject instanceof ICompilationUnit ? this.getCompilationUnitName() : LoggedNewNameQueries.this.fLog.getNewName(this.fObject);
            if (name == null) {
                name = this.fName;
            }
            return this.fName;
        }
    }
}

