/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.UAElementFactory;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.intro.impl.FontSelection;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroExtensionContent;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.util.IntroEvaluationContext;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.eclipse.ui.intro.config.IntroConfigurer;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IntroModelRoot
extends AbstractIntroContainer {
    public static final int CURRENT_PAGE_PROPERTY_ID = 1;
    private static final String ATT_CONTENT = "content";
    private static final String ATT_CONFIGURER = "configurer";
    private static final String VAR_THEME = "theme";
    private static final String VAR_DIRECTION = "direction";
    private boolean hasValidConfig = true;
    private IntroConfigurer configurer;
    private IntroTheme theme;
    private IntroPartPresentation introPartPresentation;
    private IntroHomePage rootPage;
    private String currentPageId;
    private String startPageId;
    private AbstractIntroPage standbyPage;
    private AbstractIntroPage homePage;
    private String modelStandbyPageId;
    private IConfigurationElement[] configExtensionElements;
    public ListenerList<IPropertyListener> propChangeListeners = new ListenerList();
    private List<ExtensionContent> unresolvedConfigExt = new ArrayList<ExtensionContent>();

    public IntroModelRoot(IConfigurationElement configElement, IConfigurationElement[] configExtensionElements) {
        super(configElement);
        this.configExtensionElements = configExtensionElements;
    }

    public void loadModel() {
        this.getChildren();
        this.determineHomePage();
    }

    @Override
    protected void loadChildren() {
        IConfigurationElement presentationElement;
        this.children = new Vector();
        if (Log.logInfo) {
            Log.info("Creating Intro plugin model....");
        }
        if ((presentationElement = this.loadPresentation()) == null) {
            this.setModelState(true, false);
            Log.warning("Could not find presentation element in intro config.");
            return;
        }
        this.loadTheme();
        this.loadConfigurer();
        this.introPartPresentation = new IntroPartPresentation(presentationElement);
        this.children.add(this.introPartPresentation);
        this.introPartPresentation.setParent(this);
        Document document = this.loadDOM(this.getCfgElement());
        if (document == null) {
            this.setModelState(true, false);
            return;
        }
        this.base = this.getBase(this.getCfgElement());
        this.loadPages(document, this.getBundle());
        this.loadSharedGroups(document, this.getBundle());
        this.setModelState(true, true);
        if (this.configurer != null) {
            this.configurer.bind(this);
        }
    }

    public void setPresentation(IntroPartPresentation presentation) {
        this.introPartPresentation = presentation;
        presentation.setParent(this);
        this.children.set(0, presentation);
    }

    @Override
    protected void resolveChildren() {
        this.resolveConfigExtensions();
        this.resolved = true;
    }

    private IConfigurationElement loadPresentation() {
        IConfigurationElement[] presentationElements = this.getCfgElement().getChildren("presentation");
        IConfigurationElement presentationElement = ModelLoaderUtil.validateSingleContribution(presentationElements, "home-page-id");
        return presentationElement;
    }

    private void loadConfigurer() {
        String cname = this.getCfgElement().getAttribute(ATT_CONFIGURER);
        if (cname != null) {
            try {
                Object obj = this.getCfgElement().createExecutableExtension(ATT_CONFIGURER);
                if (obj instanceof IntroConfigurer) {
                    this.configurer = (IntroConfigurer)obj;
                }
            }
            catch (CoreException e) {
                Log.error("Error loading intro configurer", e);
            }
        }
    }

    private void determineHomePage() {
        AbstractIntroPage page;
        String pid = Platform.getProduct().getId();
        this.startPageId = this.getProcessPreference("INTRO_START_PAGE", pid);
        String homePagePreference = this.getProcessPreference("INTRO_HOME_PAGE", pid);
        this.homePage = this.rootPage;
        if (homePagePreference.length() != 0 && (page = (AbstractIntroPage)this.findChild(homePagePreference, 12)) != null) {
            this.homePage = page;
            if (this.startPageId.length() == 0) {
                this.startPageId = homePagePreference;
            }
        }
        String standbyPagePreference = this.getProcessPreference("INTRO_STANDBY_PAGE", pid);
        this.modelStandbyPageId = this.getPresentation().getStandbyPageId();
        if (standbyPagePreference.length() != 0) {
            this.standbyPage = (AbstractIntroPage)this.findChild(standbyPagePreference, 12);
        }
        if (this.standbyPage == null && this.modelStandbyPageId != null && this.modelStandbyPageId.length() != 0) {
            this.standbyPage = (AbstractIntroPage)this.findChild(this.modelStandbyPageId, 12);
        }
        if (this.standbyPage != null) {
            this.standbyPage.setStandbyPage(true);
        }
    }

    private void loadTheme() {
        String pid = Platform.getProduct().getId();
        String themeId = this.getProcessPreference("INTRO_THEME", pid);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        IConfigurationElement themeElement = null;
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals(VAR_THEME)) {
                String id = elements[i].getAttribute("id");
                if (themeId != null) {
                    if (id != null && themeId.equals(id)) {
                        themeElement = elements[i];
                        break;
                    }
                } else {
                    String value = elements[i].getAttribute("default");
                    if (value != null && value.equalsIgnoreCase("true")) {
                        themeElement = elements[i];
                        break;
                    }
                }
            }
            ++i;
        }
        if (themeElement != null) {
            this.theme = new IntroTheme(themeElement);
        }
    }

    private void loadPages(Document dom, Bundle bundle) {
        String rootPageId = this.getPresentation().getHomePageId();
        Element[] pages = ModelUtil.getElementsByTagName(dom, "page");
        int i = 0;
        while (i < pages.length) {
            Element pageElement = pages[i];
            if (pageElement.getAttribute("id").equals(rootPageId)) {
                this.rootPage = new IntroHomePage(pageElement, bundle, this.base);
                this.rootPage.setParent(this);
                this.currentPageId = this.rootPage.getId();
                this.children.add(this.rootPage);
            } else {
                IntroPage page = new IntroPage(pageElement, bundle, this.base);
                page.setParent(this);
                this.children.add(page);
            }
            ++i;
        }
    }

    private void loadSharedGroups(Document dom, Bundle bundle) {
        Element[] groups = ModelUtil.getElementsByTagName(dom, "group");
        int i = 0;
        while (i < groups.length) {
            IntroGroup group = new IntroGroup(groups[i], bundle, this.base);
            group.setParent(this);
            this.children.add(group);
            ++i;
        }
    }

    private void resolveConfigExtensions() {
        int i = 0;
        while (i < this.configExtensionElements.length) {
            this.processConfigExtension(this.configExtensionElements[i]);
            ++i;
        }
        this.tryResolvingExtensions();
        for (ExtensionContent extension : this.unresolvedConfigExt) {
            Element configExtensionElement = extension.element;
            IConfigurationElement configExtConfigurationElement = extension.configExtElement;
            Bundle bundle = BundleUtil.getBundleFromConfigurationElement(configExtConfigurationElement);
            String base = this.getBase(configExtConfigurationElement);
            this.children.add(new IntroExtensionContent(configExtensionElement, bundle, base, configExtConfigurationElement));
            Log.warning("Could not resolve the following configExtension: " + ModelLoaderUtil.getLogString(bundle, configExtensionElement, "path"));
        }
    }

    private void processConfigExtension(IConfigurationElement configExtElement) {
        Document dom = this.loadDOM(configExtElement);
        if (dom == null) {
            return;
        }
        this.processConfigExtension(dom, configExtElement);
    }

    private void processConfigExtension(Document dom, IConfigurationElement configExtElement) {
        String base = this.getBase(configExtElement);
        Element[] extensionContentElements = this.loadExtensionContent(dom, configExtElement, base);
        int i = 0;
        while (i < extensionContentElements.length) {
            Element extensionContentElement = extensionContentElements[i];
            this.unresolvedConfigExt.add(new ExtensionContent(extensionContentElement, configExtElement));
            ++i;
        }
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(configExtElement);
        Element[] pages = ModelUtil.getElementsByTagName(dom, "page");
        int j = 0;
        while (j < pages.length) {
            if (!UAContentFilter.isFiltered((Object)UAElementFactory.newElement((Element)pages[j]), (IEvaluationContext)IntroEvaluationContext.getContext())) {
                IntroPage page = new IntroPage(pages[j], bundle, base);
                page.setParent(this);
                this.children.add(page);
            }
            ++j;
        }
    }

    private void tryResolvingExtensions() {
        int previousSize;
        do {
            previousSize = this.unresolvedConfigExt.size();
            ArrayList<ExtensionContent> stillUnresolved = new ArrayList<ExtensionContent>();
            for (ExtensionContent content : this.unresolvedConfigExt) {
                Element extensionContentElement = content.element;
                IConfigurationElement configExtElement = content.configExtElement;
                Bundle bundle = BundleUtil.getBundleFromConfigurationElement(configExtElement);
                String elementBase = this.getBase(configExtElement);
                this.processOneExtension(configExtElement, elementBase, bundle, extensionContentElement);
                if (!extensionContentElement.hasAttribute("failed")) continue;
                stillUnresolved.add(content);
            }
            this.unresolvedConfigExt = stillUnresolved;
        } while (this.unresolvedConfigExt.size() < previousSize);
    }

    private Element[] loadExtensionContent(Document dom, IConfigurationElement configExtElement, String base) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Element[] extensionContents = ModelUtil.getElementsByTagName(dom, "extensionContent");
        Element[] replacementContents = ModelUtil.getElementsByTagName(dom, "replacementContent");
        this.addUnfilteredExtensions(elements, extensionContents);
        this.addUnfilteredExtensions(elements, replacementContents);
        return elements.toArray(new Element[elements.size()]);
    }

    private void addUnfilteredExtensions(List<Element> elements, Element[] extensionContents) {
        int i = 0;
        while (i < extensionContents.length) {
            Element extensionContentElement = extensionContents[i];
            if (!UAContentFilter.isFiltered((Object)UAElementFactory.newElement((Element)extensionContentElement), (IEvaluationContext)IntroEvaluationContext.getContext())) {
                elements.add(extensionContentElement);
            }
            ++i;
        }
    }

    private void processOneExtension(IConfigurationElement configExtElement, String base, Bundle bundle, Element extensionContentElement) {
        IntroExtensionContent extensionContent = new IntroExtensionContent(extensionContentElement, bundle, base, configExtElement);
        boolean success = false;
        success = extensionContent.isXHTMLContent() ? this.loadXHTMLExtensionContent(extensionContent) : this.load3_0ExtensionContent(extensionContent);
        if (success) {
            if (extensionContentElement.hasAttribute("failed")) {
                extensionContentElement.removeAttribute("failed");
            }
        } else {
            extensionContentElement.setAttribute("failed", "true");
        }
    }

    private boolean loadXHTMLExtensionContent(IntroExtensionContent extensionContent) {
        String[] styles;
        String path = extensionContent.getPath();
        String[] pathSegments = StringUtil.split(path, "/");
        if (pathSegments.length != 2) {
            return false;
        }
        AbstractIntroPage targetPage = (AbstractIntroPage)this.findChild(pathSegments[0], 12);
        if (targetPage == null) {
            return false;
        }
        Document pageDom = targetPage.getDocument();
        Element targetElement = targetPage.findDomChild(pathSegments[1], "*");
        if (targetElement == null) {
            return false;
        }
        Element[] elements = extensionContent.getElements();
        int i = 0;
        while (i < elements.length) {
            Node targetNode = pageDom.importNode(elements[i], true);
            ModelUtil.updateResourceAttributes((Element)targetNode, extensionContent);
            targetElement.getParentNode().insertBefore(targetNode, targetElement);
            ++i;
        }
        if (extensionContent.getExtensionType() == 1) {
            targetElement.getParentNode().removeChild(targetElement);
        }
        if ((styles = extensionContent.getStyles()) != null) {
            int i2 = 0;
            while (i2 < styles.length) {
                ModelUtil.insertStyle(pageDom, styles[i2]);
                ++i2;
            }
        }
        return true;
    }

    private boolean load3_0ExtensionContent(IntroExtensionContent extensionContent) {
        String path = extensionContent.getPath();
        int type = extensionContent.getExtensionType();
        AbstractIntroElement target = this.findTarget(this, path, extensionContent.getId());
        if (target != null && target.isOfType(8192) == (type == 0)) {
            this.insertExtensionChildren(target, extensionContent, extensionContent.getBundle(), extensionContent.getBase());
            if (type == 1) {
                AbstractIntroContainer parent = (AbstractIntroContainer)target.getParent();
                parent.removeChild(target);
            }
            this.handleExtensionStyleInheritence(target, extensionContent);
            return true;
        }
        return false;
    }

    private void insertExtensionChildren(AbstractIntroElement target, IntroExtensionContent extensionContent, Bundle bundle, String base) {
        AbstractIntroContainer parent = (AbstractIntroContainer)target.getParent();
        String mixinStyle = this.getMixinStyle(extensionContent);
        Element[] children = extensionContent.getChildren();
        parent.insertElementsBefore(children, bundle, base, target, mixinStyle);
    }

    private String getMixinStyle(IntroExtensionContent extensionContent) {
        Path ipath;
        String s2;
        String path = extensionContent.getPath();
        if (!path.endsWith("/@")) {
            return null;
        }
        String pageId = path.substring(0, path.length() - 2);
        IntroModelRoot modelRoot = this.getModelRoot();
        if (modelRoot == null) {
            return null;
        }
        IntroConfigurer configurer = modelRoot.getConfigurer();
        if (configurer == null) {
            return null;
        }
        String extensionId = extensionContent.getId();
        if (extensionContent.getExtensionType() == 1 && (s2 = (ipath = new Path(extensionContent.getPath())).segment(1)) != null && s2.startsWith("@") && s2.length() > 1) {
            extensionId = s2.substring(1);
        }
        return configurer.getMixinStyle(pageId, extensionId);
    }

    private void handleExtensionStyleInheritence(AbstractIntroElement target, IntroExtensionContent extension) {
        Map<String, Bundle> altStyles;
        AbstractIntroContainer targetContainer = (AbstractIntroContainer)target.getParent();
        if (targetContainer.getType() == 16 && targetContainer.getParent().getType() == 1) {
            return;
        }
        String[] styles = extension.getStyles();
        if (styles != null) {
            targetContainer.getParentPage().addStyles(styles);
        }
        if ((altStyles = extension.getAltStyles()) != null) {
            targetContainer.getParentPage().addAltStyles(altStyles);
        }
    }

    private void setModelState(boolean loaded, boolean hasValidConfig) {
        this.loaded = loaded;
        this.hasValidConfig = hasValidConfig;
    }

    public boolean hasValidConfig() {
        return this.hasValidConfig;
    }

    public IntroPartPresentation getPresentation() {
        return this.introPartPresentation;
    }

    public IntroConfigurer getConfigurer() {
        return this.configurer;
    }

    public AbstractIntroPage getHomePage() {
        return this.homePage;
    }

    public IntroHomePage getRootPage() {
        return this.rootPage;
    }

    public AbstractIntroPage getStandbyPage() {
        return this.standbyPage;
    }

    public IntroPage[] getPages() {
        return (IntroPage[])this.getChildrenOfType(8);
    }

    public boolean isDynamic() {
        if ("swt".equals(this.getPresentation().getImplementationKind())) {
            return this.rootPage != null && this.rootPage.isDynamic();
        }
        return true;
    }

    public String getCurrentPageId() {
        return this.currentPageId;
    }

    public boolean setCurrentPageId(String pageId, boolean fireEvent) {
        if (pageId.equals(this.currentPageId)) {
            return true;
        }
        AbstractIntroPage page = (AbstractIntroPage)this.findChild(pageId, 12);
        if (page == null && !pageId.equals(this.rootPage.getId())) {
            Log.warning("Could not set current page to Intro page with id: " + pageId);
            return false;
        }
        this.currentPageId = pageId;
        if (fireEvent) {
            this.firePropertyChange(1);
        }
        return true;
    }

    public boolean setCurrentPageId(String pageId) {
        return this.setCurrentPageId(pageId, true);
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPropertyListener l = (IPropertyListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged((Object)this, propertyId);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    IntroModelRoot.this.propChangeListeners.remove((Object)l);
                }
            });
            ++i;
        }
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public AbstractIntroPage getCurrentPage() {
        if (!this.isDynamic()) {
            return null;
        }
        AbstractIntroPage page = (AbstractIntroPage)this.findChild(this.currentPageId, 12);
        if (page != null) {
            return page;
        }
        if (this.currentPageId.equals(this.rootPage.getId())) {
            return this.rootPage;
        }
        return null;
    }

    @Override
    public int getType() {
        return 1;
    }

    protected Document loadDOM(IConfigurationElement cfgElement) {
        String content = cfgElement.getAttribute(ATT_CONTENT);
        Bundle domBundle = BundleUtil.getBundleFromConfigurationElement(cfgElement);
        ModelUtil.ensureFileURLsExist(domBundle, content);
        content = BundleUtil.getResourceLocation(content, cfgElement);
        Document document = new IntroContentParser(content).getDocument();
        return document;
    }

    private String getBase(IConfigurationElement configElement) {
        String content = configElement.getAttribute(ATT_CONTENT);
        return ModelUtil.getParentFolderToString(content);
    }

    public String resolveVariables(String text) {
        if (text == null) {
            return null;
        }
        if (text.indexOf(36) == -1) {
            return text;
        }
        boolean inVariable = false;
        StringBuffer buf = new StringBuffer();
        int vindex = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '$') {
                if (!inVariable) {
                    inVariable = true;
                    vindex = i + 1;
                } else {
                    inVariable = false;
                    String variable = text.substring(vindex, i);
                    String value = this.getVariableValue(variable);
                    if (value == null) {
                        value = "$" + variable + "$";
                    }
                    buf.append(value);
                }
            } else if (!inVariable) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private String getVariableValue(String variable) {
        if (variable.equals(VAR_THEME) && this.theme != null) {
            return this.theme.getPath();
        }
        if (variable.equals("fontStyle")) {
            return FontSelection.getFontStyle();
        }
        if (variable.equals(VAR_DIRECTION)) {
            if (ProductPreferences.isRTL()) {
                return "rtl";
            }
            return "ltr";
        }
        if (this.configurer != null) {
            return this.configurer.getVariable(variable);
        }
        return null;
    }

    public String resolvePath(String extensionId, String path) {
        if (this.configurer == null) {
            return null;
        }
        return this.configurer.resolvePath(extensionId, path);
    }

    public IntroTheme getTheme() {
        return this.theme;
    }

    public String getStartPageId() {
        return this.startPageId;
    }

    private String getProcessPreference(String key, String pid) {
        String result = Platform.getPreferencesService().getString("org.eclipse.ui.intro", String.valueOf(pid) + '_' + key, "", null);
        if (result.length() == 0) {
            result = Platform.getPreferencesService().getString("org.eclipse.ui.intro", key, "", null);
        }
        return result;
    }

    private class ExtensionContent {
        Element element;
        IConfigurationElement configExtElement;

        ExtensionContent(Element element, IConfigurationElement configExtElement) {
            this.element = element;
            this.configExtElement = configExtElement;
        }
    }
}

