/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.inject.ComponentMethodsImpl;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.ConfigurableComponentHolder;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;

public class ComponentRegistry {
    private final Map<ComponentRegistryKey, ComponentHolder<?>> m_componentHoldersByName;
    private final Map<String, Set<ComponentHolder<?>>> m_componentHoldersByPid;
    private final Map<Long, AbstractComponentManager<?>> m_componentsById;
    private long m_componentCounter = -1L;
    private final Map<ServiceReference<?>, List<Entry<?, ?>>> m_missingDependencies = new HashMap();
    private final SimpleLogger m_logger;
    private final ThreadLocal<List<ServiceReference<?>>> circularInfos = new ThreadLocal<List<ServiceReference<?>>>(){

        @Override
        protected List<ServiceReference<?>> initialValue() {
            return new ArrayList();
        }
    };
    private final ConcurrentMap<Long, RegionConfigurationSupport> bundleToRcsMap = new ConcurrentHashMap<Long, RegionConfigurationSupport>();

    public ComponentRegistry(SimpleLogger logger) {
        this.m_logger = logger;
        this.m_componentHoldersByName = new HashMap();
        this.m_componentHoldersByPid = new HashMap();
        this.m_componentsById = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager<?> componentManager) {
        long componentId;
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            componentId = ++this.m_componentCounter;
            this.m_componentsById.put(componentId, componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(componentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ComponentRegistryKey checkComponentName(Bundle bundle, String name) {
        boolean present;
        ComponentRegistryKey key = new ComponentRegistryKey(bundle, name);
        ComponentHolder<?> existingRegistration = null;
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            present = this.m_componentHoldersByName.containsKey(key);
            if (!present) {
                this.m_componentHoldersByName.put(key, null);
            } else {
                existingRegistration = this.m_componentHoldersByName.get(key);
            }
        }
        if (present) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration != null) {
                Bundle cBundle = existingRegistration.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = existingRegistration.getComponentMetadata();
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponentHolder(ComponentRegistryKey key, ComponentHolder<?> componentHolder) {
        this.m_logger.log(4, "Registering component with pid {0} for bundle {1}", new Object[]{componentHolder.getComponentMetadata().getConfigurationPid(), key.getBundleId()}, null);
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            if (this.m_componentHoldersByName.get(key) != null) {
                throw new ComponentException("The component name '{0}" + componentHolder.getComponentMetadata().getName() + "' has already been registered.");
            }
            this.m_componentHoldersByName.put(key, componentHolder);
        }
        map = this.m_componentHoldersByPid;
        synchronized (map) {
            List<String> configurationPids = componentHolder.getComponentMetadata().getConfigurationPid();
            for (String configurationPid : configurationPids) {
                Set<ComponentHolder<?>> set = this.m_componentHoldersByPid.get(configurationPid);
                if (set == null) {
                    set = new HashSet();
                    this.m_componentHoldersByPid.put(configurationPid, set);
                }
                set.add(componentHolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder<?> getComponentHolder(Bundle bundle, String name) {
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.get(new ComponentRegistryKey(bundle, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<ComponentHolder<?>> getComponentHoldersByPid(TargetedPID targetedPid) {
        String pid = targetedPid.getServicePid();
        HashSet componentHoldersUsingPid = new HashSet();
        Map<String, Set<ComponentHolder<?>>> map = this.m_componentHoldersByPid;
        synchronized (map) {
            Set<ComponentHolder<?>> set = this.m_componentHoldersByPid.get(pid);
            if (set != null) {
                for (ComponentHolder<?> holder : set) {
                    Bundle bundle = holder.getActivator().getBundleContext().getBundle();
                    if (!targetedPid.matchesTarget(bundle)) continue;
                    componentHoldersUsingPid.add(holder);
                }
            }
        }
        return componentHoldersUsingPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ComponentHolder<?>> getComponentHolders() {
        ArrayList all = new ArrayList();
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            all.addAll(this.m_componentHoldersByName.values());
        }
        return all;
    }

    public final List<ComponentHolder<?>> getComponentHolders(Bundle ... bundles) {
        List<ComponentHolder<?>> all = this.getComponentHolders();
        ArrayList holders = new ArrayList();
        for (ComponentHolder<?> holder : all) {
            ComponentActivator activator = holder.getActivator();
            if (activator == null) continue;
            try {
                Bundle holderBundle = activator.getBundleContext().getBundle();
                for (Bundle b : bundles) {
                    if (b != holderBundle) continue;
                    holders.add(holder);
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return holders;
    }

    final void unregisterComponentHolder(Bundle bundle, String name) {
        this.unregisterComponentHolder(new ComponentRegistryKey(bundle, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentHolder(ComponentRegistryKey key) {
        ComponentHolder<?> component;
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            component = this.m_componentHoldersByName.remove(key);
        }
        if (component != null) {
            this.m_logger.log(4, "Unregistering component with pid {0} for bundle {1}", new Object[]{component.getComponentMetadata().getConfigurationPid(), key.getBundleId()}, null);
            map = this.m_componentHoldersByPid;
            synchronized (map) {
                List<String> configurationPids = component.getComponentMetadata().getConfigurationPid();
                for (String configurationPid : configurationPids) {
                    Set<ComponentHolder<?>> componentsForPid = this.m_componentHoldersByPid.get(configurationPid);
                    if (componentsForPid == null) continue;
                    componentsForPid.remove(component);
                    if (componentsForPid.size() != 0) continue;
                    this.m_componentHoldersByPid.remove(configurationPid);
                }
            }
        }
    }

    public <S> ComponentHolder<S> createComponentHolder(ComponentActivator activator, ComponentMetadata metadata) {
        return new DefaultConfigurableComponentHolder(activator, metadata);
    }

    static boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders("").get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    public <T> boolean enterCreate(ServiceReference<T> serviceReference) {
        List<ServiceReference<?>> info = this.circularInfos.get();
        if (info.contains(serviceReference)) {
            this.m_logger.log(1, "Circular reference detected trying to get service {0}\n stack of references: {1}", new Object[]{serviceReference, new Info(info)}, new Exception("stack trace"));
            return true;
        }
        this.m_logger.log(4, "getService  {0}: stack of references: {1}", new Object[]{serviceReference, info}, null);
        info.add(serviceReference);
        return false;
    }

    public <T> void leaveCreate(ServiceReference<T> serviceReference) {
        List<ServiceReference<?>> info = this.circularInfos.get();
        if (info != null) {
            if (!info.isEmpty() && info.iterator().next().equals(serviceReference)) {
                this.circularInfos.remove();
            } else {
                info.remove(serviceReference);
            }
        }
    }

    public synchronized <T> void missingServicePresent(final ServiceReference<T> serviceReference, ComponentActorThread actor) {
        final List<Entry<?, ?>> dependencyManagers = this.m_missingDependencies.remove(serviceReference);
        if (dependencyManagers != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (Entry entry : dependencyManagers) {
                        entry.getDm().invokeBindMethodLate(serviceReference, entry.getTrackingCount());
                    }
                    ComponentRegistry.this.m_logger.log(4, "Ran {0} asynchronously", new Object[]{this}, null);
                }

                public String toString() {
                    return "Late binding task of reference " + serviceReference + " for dependencyManagers " + dependencyManagers;
                }
            };
            this.m_logger.log(4, "Scheduling runnable {0} asynchronously", new Object[]{runnable}, null);
            actor.schedule(runnable);
        }
    }

    public synchronized <S, T> void registerMissingDependency(DependencyManager<S, T> dependencyManager, ServiceReference<T> serviceReference, int trackingCount) {
        if (serviceReference.getProperty("component.name") == null || serviceReference.getProperty("component.id") == null) {
            this.m_logger.log(4, "Missing service {0} for dependency manager {1} is not a DS service, cannot resolve circular dependency", new Object[]{serviceReference, dependencyManager}, null);
            return;
        }
        List<Entry<?, ?>> dependencyManagers = this.m_missingDependencies.get(serviceReference);
        if (dependencyManagers == null) {
            dependencyManagers = new ArrayList();
            this.m_missingDependencies.put(serviceReference, dependencyManagers);
        }
        dependencyManagers.add(new Entry(dependencyManager, trackingCount));
        this.m_logger.log(4, "Dependency managers {0} waiting for missing service {1}", new Object[]{dependencyManagers, serviceReference}, null);
    }

    public RegionConfigurationSupport registerRegionConfigurationSupport(ServiceReference<ConfigurationAdmin> reference) {
        RegionConfigurationSupport trialRcs = new RegionConfigurationSupport(this.m_logger, reference){

            @Override
            protected Collection<ComponentHolder<?>> getComponentHolders(TargetedPID pid) {
                return ComponentRegistry.this.getComponentHoldersByPid(pid);
            }
        };
        return this.registerRegionConfigurationSupport(trialRcs);
    }

    public RegionConfigurationSupport registerRegionConfigurationSupport(RegionConfigurationSupport trialRcs) {
        Long bundleId = trialRcs.getBundleId();
        RegionConfigurationSupport existing = null;
        RegionConfigurationSupport previous = null;
        while (true) {
            if ((existing = this.bundleToRcsMap.putIfAbsent(bundleId, trialRcs)) == null) {
                trialRcs.start();
                return trialRcs;
            }
            if (existing == previous) {
                return existing;
            }
            if (existing.reference()) {
                previous = existing;
                continue;
            }
            previous = null;
        }
    }

    public void unregisterRegionConfigurationSupport(RegionConfigurationSupport rcs) {
        if (rcs.dereference()) {
            this.bundleToRcsMap.remove(rcs.getBundleId());
        }
    }

    static class DefaultConfigurableComponentHolder<S>
    extends ConfigurableComponentHolder<S> {
        public DefaultConfigurableComponentHolder(ComponentActivator activator, ComponentMetadata metadata) {
            super(activator, metadata);
        }

        @Override
        protected ComponentMethods createComponentMethods() {
            return new ComponentMethodsImpl();
        }
    }

    private static class Entry<S, T> {
        private final DependencyManager<S, T> dm;
        private final int trackingCount;

        private Entry(DependencyManager<S, T> dm, int trackingCount) {
            this.dm = dm;
            this.trackingCount = trackingCount;
        }

        public DependencyManager<S, T> getDm() {
            return this.dm;
        }

        public int getTrackingCount() {
            return this.trackingCount;
        }

        public String toString() {
            return this.dm.toString() + "@" + this.trackingCount;
        }
    }

    private class Info {
        private final List<ServiceReference<?>> info;

        public Info(List<ServiceReference<?>> info) {
            this.info = info;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (ServiceReference<?> sr : this.info) {
                sb.append("ServiceReference: ").append(sr).append("\n");
                List entries = (List)ComponentRegistry.this.m_missingDependencies.get(sr);
                if (entries == null) continue;
                for (Entry entry : entries) {
                    sb.append("    Dependency: ").append(entry.getDm()).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

