/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.BaseProductCreationOperation;
import org.eclipse.pde.internal.ui.wizards.product.ProductFileWizardPage;
import org.eclipse.pde.internal.ui.wizards.product.ProductFromConfigOperation;
import org.eclipse.pde.internal.ui.wizards.product.ProductFromExtensionOperation;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewProductFileWizard
extends BasicNewResourceWizard {
    private ProductFileWizardPage fMainPage;

    public void addPages() {
        this.fMainPage = new ProductFileWizardPage("product", this.getSelection());
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, this.getOperation());
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IRunnableWithProgress getOperation() {
        IFile file = this.fMainPage.createNewFile();
        int option = this.fMainPage.getInitializationOption();
        if (option == 2) {
            return new ProductFromConfigOperation(file, this.fMainPage.getSelectedLaunchConfiguration());
        }
        if (option == 1) {
            return new ProductFromExtensionOperation(file, this.fMainPage.getSelectedProduct());
        }
        return new BaseProductCreationOperation(file);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(PDEUIMessages.NewProductFileWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PRODUCT_WIZ);
    }
}

