/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ChangeVetoException;
import org.eclipse.core.databinding.observable.value.IValueChangingListener;
import org.eclipse.core.databinding.observable.value.IVetoableValue;
import org.eclipse.core.databinding.observable.value.ValueChangingEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.internal.databinding.observable.Util;

public abstract class AbstractVetoableValue<T>
extends AbstractObservableValue<T>
implements IVetoableValue<T> {
    public AbstractVetoableValue() {
        this(Realm.getDefault());
    }

    public AbstractVetoableValue(Realm realm) {
        super(realm);
    }

    @Override
    protected final void doSetValue(T value) {
        Object currentValue = this.doGetValue();
        ValueDiff diff = Diffs.createValueDiff(currentValue, value);
        boolean okToProceed = this.fireValueChanging(diff);
        if (!okToProceed) {
            throw new ChangeVetoException("Change not permitted");
        }
        this.doSetApprovedValue(value);
        if (!Util.equals(diff.getOldValue(), diff.getNewValue())) {
            this.fireValueChange(diff);
        }
    }

    protected abstract void doSetApprovedValue(T var1);

    @Override
    public synchronized void addValueChangingListener(IValueChangingListener<T> listener) {
        this.addListener(ValueChangingEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeValueChangingListener(IValueChangingListener<T> listener) {
        this.removeListener(ValueChangingEvent.TYPE, listener);
    }

    protected boolean fireValueChanging(ValueDiff<T> diff) {
        this.checkRealm();
        ValueChangingEvent<T> event = new ValueChangingEvent<T>(this, diff);
        this.fireEvent(event);
        return !event.veto;
    }
}

