/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AbstractMethodCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class NewMethodCorrectionProposal
extends AbstractMethodCorrectionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private List<Expression> fArguments;

    public NewMethodCorrectionProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, List<Expression> arguments, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, invocationNode, binding, relevance, image);
        this.fArguments = arguments;
    }

    private int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.getSenderBinding().isAnnotation()) {
            return 0;
        }
        boolean isTargetInterface = this.getSenderBinding().isInterface();
        if (isTargetInterface && !JavaModelUtil.is18OrHigher((IJavaProject)this.getCompilationUnit().getJavaProject())) {
            return this.getInterfaceMethodModifiers(targetTypeDecl, true);
        }
        ASTNode invocationNode = this.getInvocationNode();
        if (invocationNode instanceof MethodInvocation) {
            ASTNode node;
            boolean isParentInterface;
            int modifiers = 0;
            Expression expression = ((MethodInvocation)invocationNode).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    modifiers |= 8;
                }
            } else if (org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.isInStaticContext((ASTNode)invocationNode)) {
                modifiers |= 8;
            }
            boolean bl = isParentInterface = (node = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.findParentType((ASTNode)invocationNode)) instanceof TypeDeclaration && ((TypeDeclaration)node).isInterface();
            if (isTargetInterface || isParentInterface) {
                if (expression == null && !targetTypeDecl.equals((Object)node)) {
                    modifiers |= 8;
                    modifiers = isTargetInterface ? (modifiers |= this.getInterfaceMethodModifiers(targetTypeDecl, false)) : (modifiers |= 4);
                } else {
                    modifiers = modifiers == 8 ? this.getInterfaceMethodModifiers(targetTypeDecl, false) | 8 : this.getInterfaceMethodModifiers(targetTypeDecl, true);
                }
            } else if (targetTypeDecl.equals((Object)node)) {
                modifiers |= 2;
            } else if (node instanceof AnonymousClassDeclaration && ASTNodes.isParent((ASTNode)node, (ASTNode)targetTypeDecl)) {
                modifiers |= 4;
                if (org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.isInStaticContext((ASTNode)node) && expression == null) {
                    modifiers |= 8;
                }
            } else {
                modifiers |= 1;
            }
            return modifiers;
        }
        return 1;
    }

    private int getInterfaceMethodModifiers(ASTNode targetTypeDecl, boolean createAbstractMethod) {
        if (targetTypeDecl instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)targetTypeDecl;
            MethodDeclaration[] methodDecls = type.getMethods();
            if (methodDecls.length > 0) {
                if (createAbstractMethod) {
                    MethodDeclaration[] methodDeclarationArray = methodDecls;
                    int n = methodDecls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
                        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
                        if (methodBinding != null && JdtFlags.isAbstract((IMethodBinding)methodBinding)) {
                            return methodDeclaration.getModifiers();
                        }
                        ++n2;
                    }
                }
                return methodDecls[0].getModifiers() & 1;
            }
            List bodyDecls = type.bodyDeclarations();
            if (bodyDecls.size() > 0) {
                return ((BodyDeclaration)bodyDecls.get(0)).getModifiers() & 1;
            }
        }
        return 0;
    }

    @Override
    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List<IExtendedModifier> modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers(targetTypeDecl)));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, modifiers, this.getSenderBinding().isInterface());
    }

    @Override
    protected boolean isConstructor() {
        ASTNode node = this.getInvocationNode();
        return node.getNodeType() != 32 && node.getNodeType() != 48;
    }

    @Override
    protected SimpleName getNewName(ASTRewrite rewrite) {
        ASTNode invocationNode = this.getInvocationNode();
        String name = invocationNode instanceof MethodInvocation ? ((MethodInvocation)invocationNode).getName().getIdentifier() : (invocationNode instanceof SuperMethodInvocation ? ((SuperMethodInvocation)invocationNode).getName().getIdentifier() : this.getSenderBinding().getName());
        AST ast = rewrite.getAST();
        SimpleName newNameNode = ast.newSimpleName(name);
        this.addLinkedPosition(rewrite.track((ASTNode)newNameNode), false, KEY_NAME);
        ASTNode invocationName = this.getInvocationNameNode();
        if (invocationName != null && invocationName.getAST() == ast) {
            this.addLinkedPosition(rewrite.track(invocationName), true, KEY_NAME);
        }
        return newNameNode;
    }

    private ASTNode getInvocationNameNode() {
        ASTNode node = this.getInvocationNode();
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).getName();
        }
        if (node instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node).getName();
        }
        if (node instanceof ClassInstanceCreation) {
            Type type = ((ClassInstanceCreation)node).getType();
            while (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getType();
            }
            return type;
        }
        return null;
    }

    @Override
    protected Type getNewMethodType(ASTRewrite rewrite, ImportRewrite.ImportRewriteContext importRewriteContext) throws CoreException {
        ITypeBinding[] bindings;
        MethodInvocation parent;
        ASTNode node = this.getInvocationNode();
        AST ast = rewrite.getAST();
        Type newTypeNode = null;
        ITypeBinding[] otherProposals = null;
        if (node.getParent() instanceof MethodInvocation && (parent = (MethodInvocation)node.getParent()).getExpression() == node && (bindings = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.getQualifierGuess((ASTNode)node.getRoot(), (String)parent.getName().getIdentifier(), (List)parent.arguments(), (IBinding)this.getSenderBinding())).length > 0) {
            newTypeNode = this.getImportRewrite().addImport(bindings[0], ast, importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
            otherProposals = bindings;
        }
        if (newTypeNode == null) {
            ITypeBinding binding = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.guessBindingForReference((ASTNode)node);
            if (binding != null && binding.isWildcardType()) {
                binding = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.normalizeWildcardType((ITypeBinding)binding, (boolean)false, (AST)ast);
            }
            if (binding != null) {
                newTypeNode = this.getImportRewrite().addImport(binding, ast, importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
            } else {
                ASTNode parent2 = node.getParent();
                if (parent2 instanceof ExpressionStatement) {
                    newTypeNode = ast.newPrimitiveType(PrimitiveType.VOID);
                } else {
                    newTypeNode = ASTResolving.guessTypeForReference(ast, node);
                    if (newTypeNode == null) {
                        newTypeNode = ast.newSimpleType((Name)ast.newSimpleName("Object"));
                    }
                }
            }
        }
        this.addLinkedPosition(rewrite.track(newTypeNode), false, KEY_TYPE);
        if (otherProposals != null) {
            int i = 0;
            while (i < otherProposals.length) {
                this.addLinkedPositionProposal(KEY_TYPE, (ITypeBinding)otherProposals[i]);
                ++i;
            }
        }
        return newTypeNode;
    }

    @Override
    protected void addNewParameters(ASTRewrite rewrite, List<String> takenNames, List<SingleVariableDeclaration> params, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        List<Expression> arguments = this.fArguments;
        int i = 0;
        while (i < arguments.size()) {
            Expression elem = arguments.get(i);
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            String argTypeKey = "arg_type_" + i;
            Type type = this.evaluateParameterType(ast, elem, argTypeKey, context);
            param.setType(type);
            String argNameKey = "arg_name_" + i;
            String name = this.evaluateParameterName(takenNames, elem, type, argNameKey);
            param.setName(ast.newSimpleName(name));
            params.add(param);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getType()), false, argTypeKey);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getName()), false, argNameKey);
            ++i;
        }
    }

    private Type evaluateParameterType(AST ast, Expression elem, String key, ImportRewrite.ImportRewriteContext context) {
        ITypeBinding binding = Bindings.normalizeTypeBinding((ITypeBinding)elem.resolveTypeBinding());
        if (binding != null && binding.isWildcardType()) {
            binding = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.normalizeWildcardType((ITypeBinding)binding, (boolean)true, (AST)ast);
        }
        if (binding != null) {
            ITypeBinding[] typeProposals = org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)binding);
            int i = 0;
            while (i < typeProposals.length) {
                this.addLinkedPositionProposal(key, typeProposals[i]);
                ++i;
            }
            return this.getImportRewrite().addImport(binding, ast, context, ImportRewrite.TypeLocation.PARAMETER);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private String evaluateParameterName(List<String> takenNames, Expression argNode, Type type, String key) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] names = StubUtility.getVariableNameSuggestions(4, project, type, argNode, takenNames);
        int i = 0;
        while (i < names.length) {
            this.addLinkedPositionProposal(key, names[i], null);
            ++i;
        }
        String favourite = names[0];
        takenNames.add(favourite);
        return favourite;
    }

    @Override
    protected void addNewExceptions(ASTRewrite rewrite, List<Type> exceptions, ImportRewrite.ImportRewriteContext context) throws CoreException {
    }

    @Override
    protected void addNewTypeParameters(ASTRewrite rewrite, List<String> takenNames, List<TypeParameter> params, ImportRewrite.ImportRewriteContext context) throws CoreException {
    }
}

