/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;

public class IllegalFieldReferenceDetector
extends AbstractProblemDetector {
    private Map<MethodKey, IFieldDescriptor> fIllegalFields = new HashMap<MethodKey, IFieldDescriptor>();
    private Map<String, String> fIllegalTypes = new HashMap<String, String>();
    private Map<IFieldDescriptor, String> fFieldComponents = new HashMap<IFieldDescriptor, String>();

    void addIllegalField(IFieldDescriptor field, String componentId) {
        this.fIllegalFields.put(new MethodKey(field.getEnclosingType().getQualifiedName(), field.getName(), null, true), field);
        this.fFieldComponents.put(field, componentId);
    }

    void addIllegalType(IReferenceTypeDescriptor type, String componentid) {
        this.fIllegalTypes.put(type.getQualifiedName(), componentid);
    }

    @Override
    public boolean considerReference(IReference reference) {
        MethodKey key = new MethodKey(reference.getReferencedTypeName(), reference.getReferencedMemberName(), reference.getReferencedSignature(), true);
        if (super.considerReference(reference) && this.fIllegalFields.containsKey(key) || this.isEnclosedBy(reference.getReferencedTypeName(), this.fIllegalTypes.keySet())) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    @Override
    public int getReferenceKinds() {
        return 30720;
    }

    @Override
    protected int getProblemKind() {
        return 3;
    }

    @Override
    protected String getSeverityKey() {
        return "ILLEGAL_REFERENCE";
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        return 9;
    }

    @Override
    protected int getElementType(IReference reference) {
        return 5;
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiField field = (IApiField)reference.getResolvedReference();
        return new String[]{this.getSimpleTypeName(field), this.getSimpleTypeName(reference.getMember()), field.getName()};
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiField field = (IApiField)reference.getResolvedReference();
        return new String[]{this.getQualifiedTypeName(field), this.getQualifiedTypeName(reference.getMember()), field.getName()};
    }

    @Override
    protected Position getSourceRange(IType type, IDocument document, IReference reference) throws CoreException, BadLocationException {
        return this.getFieldNameRange((IApiField)reference.getResolvedReference(), document, reference);
    }

    @Override
    protected boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) {
            return false;
        }
        String componentId = this.fFieldComponents.get(reference.getResolvedReference().getHandle());
        if (componentId != null) {
            return this.isReferenceFromComponent(reference, componentId);
        }
        StringTokenizer tokenizer = new StringTokenizer(reference.getReferencedTypeName(), "$");
        while (tokenizer.hasMoreTokens()) {
            componentId = this.fIllegalTypes.get(tokenizer.nextToken());
            if (componentId != null) break;
        }
        return this.isReferenceFromComponent(reference, componentId);
    }
}

