/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs.cpd;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.cpd.CustomizePerspectiveDialog;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.wizards.IWizardDescriptor;

abstract class NameAndDescriptionToolTip
extends ToolTip {
    public NameAndDescriptionToolTip(Control control, int style) {
        super(control, style, false);
    }

    protected abstract Object getModelElement(Event var1);

    protected boolean shouldCreateToolTip(Event event) {
        return super.shouldCreateToolTip(event) && this.getModelElement(event) != null;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Object modelElement = this.getModelElement(event);
        Image iconImage = null;
        String nameString = null;
        if (modelElement instanceof CustomizePerspectiveDialog.DisplayItem) {
            iconImage = ((CustomizePerspectiveDialog.DisplayItem)modelElement).getImage();
            nameString = ((CustomizePerspectiveDialog.DisplayItem)modelElement).getLabel();
        } else if (modelElement instanceof CustomizePerspectiveDialog.ActionSet) {
            nameString = ((CustomizePerspectiveDialog.ActionSet)modelElement).descriptor.getLabel();
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(29));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label title = this.createEntry(composite, iconImage, nameString);
        title.setFont(this.getTitleFont());
        GridDataFactory.createFrom((GridData)((GridData)title.getLayoutData())).hint(-1, -1).minSize(160, 1).applyTo((Control)title);
        String descriptionString = NameAndDescriptionToolTip.getDescription(modelElement);
        if (descriptionString != null) {
            this.createEntry(composite, null, descriptionString);
        }
        this.addContent(composite, modelElement);
        return composite;
    }

    Font getTitleFont() {
        return JFaceResources.getFontRegistry().getBold(NameAndDescriptionToolTip.class.getName());
    }

    protected Label createEntry(Composite parent, Image icon, String text) {
        Color fg = parent.getDisplay().getSystemColor(28);
        Color bg = parent.getDisplay().getSystemColor(29);
        if (icon != null) {
            Label iconLabel = new Label(parent, 0);
            iconLabel.setImage(icon);
            iconLabel.setForeground(fg);
            iconLabel.setBackground(bg);
            iconLabel.setData((Object)new GridData());
        }
        Label textLabel = new Label(parent, 64);
        if (icon == null) {
            GridDataFactory.generate((Control)textLabel, (int)2, (int)1);
        } else {
            GridDataFactory.generate((Control)textLabel, (int)1, (int)1);
        }
        if (text != null) {
            textLabel.setText(text);
        }
        textLabel.setForeground(fg);
        textLabel.setBackground(bg);
        return textLabel;
    }

    protected Link createEntryWithLink(Composite parent, Image icon, String text) {
        Color fg = parent.getDisplay().getSystemColor(28);
        Color bg = parent.getDisplay().getSystemColor(29);
        if (icon != null) {
            Label iconLabel = new Label(parent, 0);
            iconLabel.setImage(icon);
            iconLabel.setForeground(fg);
            iconLabel.setBackground(bg);
            iconLabel.setData((Object)new GridData());
        }
        Link textLink = new Link(parent, 64);
        if (icon == null) {
            GridDataFactory.generate((Control)textLink, (int)2, (int)1);
        }
        textLink.setText(text);
        textLink.setForeground(fg);
        textLink.setBackground(bg);
        return textLink;
    }

    protected void addContent(Composite destination, Object modelElement) {
    }

    static String getDescription(IContributionItem item) {
        if (item instanceof ActionContributionItem) {
            ActionContributionItem aci = (ActionContributionItem)item;
            IAction action = aci.getAction();
            if (action == null) {
                return null;
            }
            return action.getDescription();
        }
        if (item instanceof ActionSetContributionItem) {
            ActionSetContributionItem asci = (ActionSetContributionItem)item;
            IContributionItem subitem = asci.getInnerItem();
            return NameAndDescriptionToolTip.getDescription(subitem);
        }
        return null;
    }

    static String getDescription(Object object) {
        if (object instanceof CustomizePerspectiveDialog.DisplayItem) {
            CustomizePerspectiveDialog.DisplayItem item = (CustomizePerspectiveDialog.DisplayItem)object;
            if (CustomizePerspectiveDialog.isNewWizard(item)) {
                CustomizePerspectiveDialog.ShortcutItem shortcut = (CustomizePerspectiveDialog.ShortcutItem)item;
                IWizardDescriptor descriptor = (IWizardDescriptor)shortcut.getDescriptor();
                return descriptor.getDescription();
            }
            if (CustomizePerspectiveDialog.isShowPerspective(item)) {
                CustomizePerspectiveDialog.ShortcutItem shortcut = (CustomizePerspectiveDialog.ShortcutItem)item;
                IPerspectiveDescriptor descriptor = (IPerspectiveDescriptor)shortcut.getDescriptor();
                return descriptor.getDescription();
            }
            if (CustomizePerspectiveDialog.isShowView(item)) {
                CustomizePerspectiveDialog.ShortcutItem shortcut = (CustomizePerspectiveDialog.ShortcutItem)item;
                IViewDescriptor descriptor = (IViewDescriptor)shortcut.getDescriptor();
                return descriptor.getDescription();
            }
            if (item instanceof CustomizePerspectiveDialog.DynamicContributionItem) {
                return WorkbenchMessages.HideItems_dynamicItemDescription;
            }
            IContributionItem contrib = item.getIContributionItem();
            return NameAndDescriptionToolTip.getDescription(contrib);
        }
        if (object instanceof CustomizePerspectiveDialog.ActionSet) {
            CustomizePerspectiveDialog.ActionSet actionSet = (CustomizePerspectiveDialog.ActionSet)object;
            return actionSet.descriptor.getDescription();
        }
        return null;
    }
}

