/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.field;

import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.eclipse.jdt.internal.core.nd.field.BaseField;

public class FieldByte
extends BaseField {
    private final ModificationLog.Tag tag;

    public FieldByte(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.tag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public byte get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getByte(address + (long)this.offset);
    }

    public void put(Nd nd, long address, byte newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.tag);
        try {
            db.putByte(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.tag);
        }
    }

    @Override
    public int getRecordSize() {
        return 1;
    }
}

