/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTImageHelper;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.GradientBackgroundListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyBackgroundSWTHandler
extends AbstractCSSPropertyBackgroundHandler {
    public static final ICSSPropertyBackgroundHandler INSTANCE = new CSSPropertyBackgroundSWTHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            super.applyCSSProperty(element, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            return super.retrieveCSSProperty((Object)widget, property, pseudo, engine);
        }
        return null;
    }

    public void applyCSSPropertyBackgroundColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)((WidgetElement)element).getNativeWidget();
        if (value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
            if (widget instanceof CTabItem) {
                CTabFolder folder = ((CTabItem)widget).getParent();
                if ("selected".equals(pseudo)) {
                    CSSSWTColorHelper.setSelectionBackground(folder, newColor);
                } else {
                    CSSSWTColorHelper.setBackground((Control)folder, newColor);
                }
            } else if (widget instanceof Control) {
                GradientBackgroundListener.remove((Control)widget);
                CSSSWTColorHelper.setBackground((Control)widget, newColor);
                CompositeElement.setBackgroundOverriddenByCSSMarker(widget);
            }
        } else if (value.getCssValueType() == 2) {
            Gradient grad = (Gradient)engine.convert(value, Gradient.class, (Object)widget.getDisplay());
            if (grad == null) {
                return;
            }
            if (widget instanceof CTabItem) {
                CTabFolder folder = ((CTabItem)widget).getParent();
                Color[] colors = CSSSWTColorHelper.getSWTColors(grad, folder.getDisplay(), engine);
                int[] percents = CSSSWTColorHelper.getPercents(grad);
                if ("selected".equals(pseudo)) {
                    folder.setSelectionBackground(colors, percents, true);
                } else {
                    folder.setBackground(colors, percents, true);
                }
            } else if (widget instanceof Control) {
                GradientBackgroundListener.handle((Control)widget, grad);
                CompositeElement.setBackgroundOverriddenByCSSMarker(widget);
            }
        }
    }

    public void applyCSSPropertyBackgroundImage(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)((WidgetElement)element).getNativeWidget();
        Image image = (Image)engine.convert(value, Image.class, (Object)widget.getDisplay());
        if (widget instanceof CTabFolder && "selected".equals(pseudo)) {
            ((CTabFolder)widget).setSelectionBackground(image);
        } else if (widget instanceof Button) {
            Button button = (Button)widget;
            CSSSWTImageHelper.setImage(button, image);
        } else if (widget instanceof Control) {
            CSSSWTImageHelper.setBackgroundImage((Control)widget, image);
        }
    }

    public String retrieveCSSPropertyBackgroundAttachment(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyBackgroundColor(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        Color color = null;
        if (widget instanceof CTabItem) {
            color = "selected".equals(pseudo) ? ((CTabItem)widget).getParent().getSelectionBackground() : ((CTabItem)widget).getParent().getBackground();
        } else if (widget instanceof Control) {
            color = ((Control)widget).getBackground();
        }
        return engine.convert((Object)color, Color.class, null);
    }

    public String retrieveCSSPropertyBackgroundImage(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return "none";
    }

    public String retrieveCSSPropertyBackgroundPosition(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyBackgroundRepeat(Object widget, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

