/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

class WorkbenchColors {
    private static boolean init = false;
    private static Map<Object, Color> colorMap;
    private static Color[] activeGradient;
    private static int[] activePercentages;
    private static final String CLR_GRAD_START = "clrGradStart";
    private static final String CLR_GRAD_MID = "clrGradMid";
    private static final String CLR_GRAD_END = "clrGradEnd";
    protected static Image gradient;
    protected static Image mirrorGradient;

    WorkbenchColors() {
    }

    public static Color[] getActiveGradient() {
        return activeGradient;
    }

    public static Color getActiveGradientStart() {
        Color clr = colorMap.get(CLR_GRAD_START);
        return clr;
    }

    public static Color getActiveGradientEnd() {
        Color clr = colorMap.get(CLR_GRAD_END);
        return clr;
    }

    public static int[] getActiveGradientPercents() {
        return activePercentages;
    }

    public static Color getColor(RGB rgbValue) {
        Color clr = colorMap.get(rgbValue);
        if (clr == null) {
            Display disp = Display.getDefault();
            clr = new Color((Device)disp, rgbValue);
            colorMap.put(rgbValue, clr);
        }
        return clr;
    }

    public static Color getSystemColor(int swtId) {
        Integer bigInt = swtId;
        Color clr = colorMap.get(bigInt);
        if (clr == null) {
            Display disp = Display.getDefault();
            clr = disp.getSystemColor(swtId);
            colorMap.put(bigInt, clr);
        }
        return clr;
    }

    public static void shutdown() {
        if (!init) {
            return;
        }
        for (Color color : colorMap.values()) {
            color.dispose();
        }
        colorMap.clear();
        gradient.dispose();
    }

    public static void startup() {
        if (init) {
            return;
        }
        init = true;
        Display disp = Display.getDefault();
        colorMap = new HashMap<Object, Color>(10);
        Color clr1 = disp.getSystemColor(31);
        Color clr2 = disp.getSystemColor(32);
        Color clr3 = disp.getSystemColor(22);
        int r = clr1.getRGB().red + 2 * (clr3.getRGB().red - clr1.getRGB().red) / 3;
        r = clr3.getRGB().red > clr1.getRGB().red ? Math.min(r, clr3.getRGB().red) : Math.max(r, clr3.getRGB().red);
        int g = clr1.getRGB().green + 2 * (clr3.getRGB().green - clr1.getRGB().green) / 3;
        g = clr3.getRGB().green > clr1.getRGB().green ? Math.min(g, clr3.getRGB().green) : Math.max(g, clr3.getRGB().green);
        int b = clr1.getRGB().blue + 2 * (clr3.getRGB().blue - clr1.getRGB().blue) / 3;
        b = clr3.getRGB().blue > clr1.getRGB().blue ? Math.min(b, clr3.getRGB().blue) : Math.max(b, clr3.getRGB().blue);
        Color clr4 = new Color((Device)disp, r, g, b);
        colorMap.put(CLR_GRAD_START, clr4);
        colorMap.put(CLR_GRAD_MID, clr2);
        colorMap.put(CLR_GRAD_END, clr3);
        activeGradient = new Color[]{clr4, clr3, clr3};
        activePercentages = new int[]{25, 100};
        WorkbenchColors.getSystemColor(21);
        WorkbenchColors.getSystemColor(22);
    }

    public static Image getGradient() {
        return WorkbenchColors.getGradient(true);
    }

    public static Image getGradient(boolean leftToRight) {
        if (leftToRight) {
            if (gradient == null) {
                gradient = WorkbenchColors.createGradient(true);
            }
            return gradient;
        }
        if (mirrorGradient == null) {
            mirrorGradient = WorkbenchColors.createGradient(false);
        }
        return mirrorGradient;
    }

    protected static Image createGradient(boolean leftToRight) {
        int width = 20;
        int height = 10;
        Display display = Display.getDefault();
        Image gradient = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)gradient);
        Color startColor = display.getSystemColor(leftToRight ? 22 : 31);
        RGB rgb1 = startColor.getRGB();
        Color endColor = display.getSystemColor(leftToRight ? 31 : 22);
        RGB rgb2 = endColor.getRGB();
        int k = 0;
        while (k < width) {
            int r = rgb1.red + k * (rgb2.red - rgb1.red) / width;
            r = rgb2.red > rgb1.red ? Math.min(r, rgb2.red) : Math.max(r, rgb2.red);
            int g = rgb1.green + k * (rgb2.green - rgb1.green) / width;
            g = rgb2.green > rgb1.green ? Math.min(g, rgb2.green) : Math.max(g, rgb2.green);
            int b = rgb1.blue + k * (rgb2.blue - rgb1.blue) / width;
            b = rgb2.blue > rgb1.blue ? Math.min(b, rgb2.blue) : Math.max(b, rgb2.blue);
            Color color = new Color((Device)display, r, g, b);
            gc.setBackground(color);
            gc.fillRectangle(width - k - 1, 0, 1, height);
            color.dispose();
            ++k;
        }
        gc.dispose();
        return gradient;
    }
}

