/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.junit.BasicElementLabels;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;

public class JUnitQuickFixProcessor
implements IQuickFixProcessor {
    private static final HashSet<String> ASSERT_METHOD_NAMES = new HashSet();

    public JUnitQuickFixProcessor() {
        ASSERT_METHOD_NAMES.add("fail");
        ASSERT_METHOD_NAMES.add("assertTrue");
        ASSERT_METHOD_NAMES.add("assertFalse");
        ASSERT_METHOD_NAMES.add("assertEquals");
        ASSERT_METHOD_NAMES.add("assertNotNull");
        ASSERT_METHOD_NAMES.add("assertNull");
        ASSERT_METHOD_NAMES.add("assertSame");
        ASSERT_METHOD_NAMES.add("assertNotSame");
        ASSERT_METHOD_NAMES.add("failNotEquals");
        ASSERT_METHOD_NAMES.add("failSame");
        ASSERT_METHOD_NAMES.add("failNotSame");
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 0x1000002 || problemId == 0x4000064;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) {
        ArrayList<IJavaCompletionProposal> res = null;
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            int id = problem.getProblemId();
            if (0x1000002 == id) {
                res = this.getAddJUnitToBuildPathProposals(context, problem, res);
            } else if (id == 0x4000064) {
                res = this.getAddAssertImportProposals(context, problem, res);
            }
            ++n2;
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        return res.toArray(new IJavaCompletionProposal[res.size()]);
    }

    private ArrayList<IJavaCompletionProposal> getAddAssertImportProposals(IInvocationContext context, IProblemLocation problem, ArrayList<IJavaCompletionProposal> proposals) {
        String methodName;
        String[] args = problem.getProblemArguments();
        if (args.length > 1 && ASSERT_METHOD_NAMES.contains(methodName = args[1]) && this.isInsideJUnit4Test(context)) {
            if (proposals == null) {
                proposals = new ArrayList();
            }
            proposals.add(new AddAssertProposal(context.getASTRoot(), methodName, 9));
            proposals.add(new AddAssertProposal(context.getASTRoot(), "*", 10));
        }
        return proposals;
    }

    private ArrayList<IJavaCompletionProposal> getAddJUnitToBuildPathProposals(IInvocationContext context, IProblemLocation location, ArrayList<IJavaCompletionProposal> proposals) {
        try {
            ICompilationUnit unit = context.getCompilationUnit();
            String qualifiedName = null;
            String s = unit.getBuffer().getText(location.getOffset(), location.getLength());
            if (s.equals("TestCase") || s.equals("TestSuite")) {
                qualifiedName = "junit.framework." + s;
            } else if (s.equals("RunWith")) {
                qualifiedName = "org.junit.runner.RunWith";
            } else if (s.equals("Test")) {
                ASTNode node = location.getCoveredNode(context.getASTRoot());
                qualifiedName = node != null && node.getLocationInParent() == MarkerAnnotation.TYPE_NAME_PROPERTY ? "org.junit.Test" : "junit.framework.Test";
            }
            if (qualifiedName != null) {
                ClasspathFixProcessor.ClasspathFixProposal[] fixProposals;
                IJavaProject javaProject = unit.getJavaProject();
                if (javaProject.findType(qualifiedName) != null) {
                    return proposals;
                }
                ClasspathFixProcessor.ClasspathFixProposal[] classpathFixProposalArray = fixProposals = ClasspathFixProcessor.getContributedFixImportProposals((IJavaProject)javaProject, (String)qualifiedName, null);
                int n = fixProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ClasspathFixProcessor.ClasspathFixProposal fixProposal = classpathFixProposalArray[n2];
                    if (proposals == null) {
                        proposals = new ArrayList();
                    }
                    proposals.add(new JUnitClasspathFixCorrectionProposal(javaProject, fixProposal, this.getImportRewrite(context.getASTRoot(), qualifiedName)));
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e.getStatus());
        }
        return proposals;
    }

    private ImportRewrite getImportRewrite(CompilationUnit astRoot, String typeToImport) {
        if (typeToImport != null) {
            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
            importRewrite.addImport(typeToImport);
            return importRewrite;
        }
        return null;
    }

    private boolean isInsideJUnit4Test(IInvocationContext context) {
        IMethodBinding binding;
        if (!JUnitStubUtility.is50OrHigher(context.getCompilationUnit().getJavaProject())) {
            return false;
        }
        ASTNode node = context.getCoveringNode();
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        if (node instanceof MethodDeclaration && (binding = ((MethodDeclaration)node).resolveBinding()) != null) {
            IAnnotationBinding[] annotations;
            IAnnotationBinding[] iAnnotationBindingArray = annotations = binding.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                ITypeBinding annotationType = annotation.getAnnotationType();
                if (annotationType != null && "org.junit.Test".equals(annotationType.getQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static class AddAssertProposal
    implements IJavaCompletionProposal {
        private final CompilationUnit fAstRoot;
        private final String fMethodName;
        private final int fRelevance;

        public AddAssertProposal(CompilationUnit astRoot, String methodName, int relevance) {
            this.fAstRoot = astRoot;
            this.fMethodName = methodName;
            this.fRelevance = relevance;
        }

        public int getRelevance() {
            return this.fRelevance;
        }

        public void apply(IDocument document) {
            try {
                ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.fAstRoot, (boolean)true);
                rewrite.addStaticImport("org.junit.Assert", this.fMethodName, true);
                TextEdit edit = rewrite.rewriteImports(null);
                edit.apply(document);
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {}
        }

        public String getAdditionalProposalInfo() {
            return Messages.format((String)JUnitMessages.JUnitQuickFixProcessor_add_assert_info, (Object)BasicElementLabels.getJavaElementName((String)("org.junit.Assert." + this.fMethodName)));
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return Messages.format((String)JUnitMessages.JUnitQuickFixProcessor_add_assert_description, (Object)BasicElementLabels.getJavaElementName((String)("org.junit.Assert." + this.fMethodName)));
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.imp_obj.gif");
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }

    private static class JUnitClasspathFixCorrectionProposal
    implements IJavaCompletionProposal {
        private final ClasspathFixProcessor.ClasspathFixProposal fClasspathFixProposal;
        private final ImportRewrite fImportRewrite;
        private final IJavaProject fJavaProject;

        public JUnitClasspathFixCorrectionProposal(IJavaProject javaProject, ClasspathFixProcessor.ClasspathFixProposal cpfix, ImportRewrite rewrite) {
            this.fJavaProject = javaProject;
            this.fClasspathFixProposal = cpfix;
            this.fImportRewrite = rewrite;
        }

        protected Change createChange() throws CoreException {
            Change change = this.fClasspathFixProposal.createChange(null);
            if (this.fImportRewrite != null) {
                TextFileChange cuChange = new TextFileChange("Add import", (IFile)this.fImportRewrite.getCompilationUnit().getResource());
                cuChange.setEdit(this.fImportRewrite.rewriteImports(null));
                CompositeChange composite = new CompositeChange(this.getDisplayString());
                composite.add(change);
                composite.add((Change)cuChange);
                return composite;
            }
            return change;
        }

        public void apply(IDocument document) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            Change change = this.createChange();
                            change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                            PerformChangeOperation op = new PerformChangeOperation(change);
                            op.setUndoManager(RefactoringCore.getUndoManager(), this.getDisplayString());
                            op.setSchedulingRule((ISchedulingRule)fJavaProject.getProject().getWorkspace().getRoot());
                            op.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, JUnitPlugin.getActiveWorkbenchShell(), JUnitMessages.JUnitQuickFixProcessor_apply_problem_title, JUnitMessages.JUnitQuickFixProcessor_apply_problem_description);
            }
            catch (InterruptedException interruptedException) {}
        }

        public String getAdditionalProposalInfo() {
            return this.fClasspathFixProposal.getAdditionalProposalInfo();
        }

        public int getRelevance() {
            return this.fClasspathFixProposal.getRelevance();
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.fClasspathFixProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fClasspathFixProposal.getImage();
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }
}

