/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.ScenarioProperty;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.PropertySuggestionManager;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SuggestionItem;
import org.eclipse.rcptt.ui.editors.IQ7EditorActionsProvider;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.PropertyCellEditor;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScenarioProperties
extends AbstractEmbeddedComposite
implements IQ7EditorActionsProvider {
    private static final String NAME_PROPERTY = "name";
    private static final String VALUE_PROPERTY = "value";
    private static final String[] NAME_PROPERTIES = new String[]{"name"};
    private static final String[] VALUE_PROPERTIES = new String[]{"value"};
    private static ScenarioProperty newParameterItem = ScenarioFactory.eINSTANCE.createScenarioProperty();
    private Table table;
    private TableViewer viewer;
    private ToolTip tip;
    private String lastNewName = "";
    private TableColumn nameColumn;
    private TableColumn valueColumn;
    private HashMap<String, Integer> nameToIndex = new HashMap();
    private Scenario namedElement;
    protected final DataBindingContext dbc = new DataBindingContext();
    private FormToolkit toolkit;
    private final NamedElementEditorActions.INamedElementActions actions = new NamedElementEditorActions.INamedElementActions(){

        @Override
        public void undo() {
        }

        @Override
        public void redo() {
        }

        @Override
        public void paste() {
        }

        @Override
        public void cut() {
        }

        @Override
        public void copy() {
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public boolean canRedo() {
            return false;
        }

        @Override
        public boolean canPaste() {
            return false;
        }

        @Override
        public boolean canCut() {
            return false;
        }

        @Override
        public boolean canCopy() {
            return false;
        }
    };
    private Composite control;

    static {
        newParameterItem.setName("Add new property");
        newParameterItem.setValue("");
    }

    public void setSelectionAtLine(int line) {
        if (this.table != null && line < this.table.getItemCount()) {
            this.table.deselectAll();
            this.table.select(line);
            this.table.setFocus();
        }
    }

    public ScenarioProperties(Scenario scenario, FormToolkit toolkit) {
        this.setNamedElement(scenario);
        this.toolkit = toolkit;
    }

    @Override
    public void dispose() {
        this.tip.setVisible(false);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = this.toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.control);
        this.viewer = this.createTable(this.control, this.toolkit);
        this.createPanel(this.control, this.toolkit);
        this.tip = new ToolTip(parent.getShell(), 4096);
        this.tip.setText("Error");
    }

    private void sortBy(TableColumn column) {
        if (this.table.getSortColumn() != column) {
            this.table.setSortColumn(column);
            this.table.setSortDirection(128);
            this.viewer.setComparator((ViewerComparator)new Comparator(column, 128));
        } else if (this.table.getSortDirection() == 128) {
            this.table.setSortDirection(1024);
            this.viewer.setComparator((ViewerComparator)new Comparator(column, 1024));
        } else {
            this.table.setSortColumn(null);
            this.table.setSortDirection(0);
            this.viewer.setComparator((ViewerComparator)new Comparator());
        }
        this.viewer.refresh();
    }

    private TableViewer createTable(Composite parent, FormToolkit toolkit) {
        this.table = new Table(parent, 67586);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)this.table);
        this.table.setHeaderVisible(true);
        toolkit.adapt((Composite)this.table);
        this.table.setLinesVisible(true);
        this.nameColumn = new TableColumn(this.table, 16384);
        this.nameColumn.setText("Name");
        this.nameColumn.setWidth(200);
        this.nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioProperties.this.sortBy(ScenarioProperties.this.nameColumn);
            }
        });
        this.valueColumn = new TableColumn(this.table, 16384);
        this.valueColumn.setText("Value");
        this.valueColumn.setWidth(350);
        this.valueColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioProperties.this.sortBy(ScenarioProperties.this.valueColumn);
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 127: {
                        ScenarioProperties.this.removeSelected();
                        break;
                    }
                    case 0x1000009: {
                        ScenarioProperties.this.addNew();
                        break;
                    }
                    case 13: 
                    case 0x100000B: {
                        ScenarioProperties.this.lastNewName = "";
                        Object el = ((StructuredSelection)ScenarioProperties.this.viewer.getSelection()).getFirstElement();
                        if (el != null) {
                            ScenarioProperties.this.viewer.editElement(el, 0);
                            break;
                        }
                        ScenarioProperties.this.viewer.editElement((Object)newParameterItem, 0);
                    }
                }
            }
        });
        final TableViewer viewer = new TableViewer(this.table);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem item = ScenarioProperties.this.table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    viewer.cancelEditing();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Scenario ctx = (Scenario)inputElement;
                ArrayList<ScenarioProperty> elements = new ArrayList<ScenarioProperty>();
                elements.addAll((Collection<ScenarioProperty>)ctx.getProperties());
                elements.add(newParameterItem);
                return elements.toArray();
            }
        });
        TableViewerColumn nameViewerColumn = new TableViewerColumn(viewer, this.nameColumn);
        nameViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ScenarioProperty p = (ScenarioProperty)element;
                return p.getName();
            }

            public Image getImage(Object element) {
                return element == newParameterItem ? Images.getImageDescriptor("IMG_OBJ_ADD").createImage() : Images.getImage("icons/parameter.gif");
            }

            public Font getFont(Object element) {
                if (element == newParameterItem) {
                    Font tableFont = ScenarioProperties.this.table.getFont();
                    FontData fd = tableFont.getFontData()[0];
                    fd.setHeight(fd.getHeight() - 2);
                    return new Font(tableFont.getDevice(), fd);
                }
                return null;
            }
        });
        nameViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected CellEditor getCellEditor(final Object element) {
                Scenario scenario = ScenarioProperties.this.getNamedElement();
                List<SuggestionItem> suggestions = PropertySuggestionManager.getInstance().getScenarioProperties(scenario);
                final PropertyCellEditor editor = new PropertyCellEditor((Composite)ScenarioProperties.this.table, suggestions){

                    @Override
                    public void completeEdit() {
                        viewer.applyEditorValue();
                    }
                };
                editor.setFilterEnabled(false);
                editor.getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        Text cfr_ignored_0 = (Text)editor.getControl();
                        switch (e.detail) {
                            case 16: {
                                viewer.editElement(element, 1);
                                e.detail = 0;
                                e.doit = false;
                            }
                        }
                    }
                });
                return editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (ScenarioProperties.this.lastNewName.length() > 0) {
                    return ScenarioProperties.this.lastNewName;
                }
                if (element == newParameterItem) {
                    return "";
                }
                ScenarioProperty p = (ScenarioProperty)element;
                return p.getName();
            }

            protected void setValue(Object element, Object value) {
                String name = (String)value;
                ScenarioProperty param = (ScenarioProperty)element;
                Scenario ctx = ScenarioProperties.this.getNamedElement();
                if (ScenarioProperties.this.isNewAndBlank(element, name)) {
                    ScenarioProperties.this.lastNewName = "";
                    return;
                }
                if (param != newParameterItem) {
                    if (!param.getName().equals(name)) {
                        Integer index = (Integer)ScenarioProperties.this.nameToIndex.get(param.getName());
                        ScenarioProperties.this.nameToIndex.remove(param.getName());
                        ScenarioProperties.this.nameToIndex.put(name, index);
                        param.setName(name);
                        viewer.update(element, NAME_PROPERTIES);
                    }
                } else {
                    final ScenarioProperty newParam = ScenarioFactory.eINSTANCE.createScenarioProperty();
                    newParam.setName(name);
                    newParam.setValue("");
                    ScenarioProperties.this.nameToIndex.put(name, ScenarioProperties.this.table.getItemCount() - 1);
                    ctx.getProperties().add((Object)newParam);
                    viewer.add((Object)newParam);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)newParam), true);
                    ScenarioProperties.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            viewer.editElement((Object)newParam, 1);
                        }
                    });
                }
            }
        });
        TableViewerColumn valueViewerColumn = new TableViewerColumn(viewer, this.valueColumn);
        valueViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ScenarioProperty p = (ScenarioProperty)element;
                return p.getValue();
            }
        });
        valueViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected CellEditor getCellEditor(final Object element) {
                ScenarioProperty param = (ScenarioProperty)element;
                List<SuggestionItem> suggestions = PropertySuggestionManager.getInstance().getScenarioPropertySuggestions(param.getName());
                final PropertyCellEditor editor = new PropertyCellEditor((Composite)ScenarioProperties.this.table, suggestions){

                    @Override
                    public void completeEdit() {
                        viewer.applyEditorValue();
                    }
                };
                editor.setFilterEnabled(true);
                editor.getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        Text cfr_ignored_0 = (Text)editor.getControl();
                        switch (e.detail) {
                            case 8: {
                                viewer.editElement(element, 0);
                                e.detail = 0;
                                e.doit = false;
                            }
                        }
                    }
                });
                return editor;
            }

            protected boolean canEdit(Object element) {
                return element != newParameterItem;
            }

            protected Object getValue(Object element) {
                ScenarioProperty p = (ScenarioProperty)element;
                return p.getValue();
            }

            protected void setValue(Object element, Object value) {
                ScenarioProperty p = (ScenarioProperty)element;
                String v = (String)value;
                if (!p.getValue().equals(v)) {
                    p.setValue((String)value);
                    viewer.update(element, VALUE_PROPERTIES);
                }
            }
        });
        this.updateIndexes();
        viewer.setComparator((ViewerComparator)new Comparator());
        viewer.setInput((Object)this.getNamedElement());
        return viewer;
    }

    public Scenario getNamedElement() {
        return this.namedElement;
    }

    public void setNamedElement(Scenario namedElement) {
        this.namedElement = namedElement;
    }

    private void updateIndexes() {
        this.nameToIndex.clear();
        EList params = this.getNamedElement().getProperties();
        int i = 0;
        while (i < params.size()) {
            this.nameToIndex.put(((ScenarioProperty)params.get(i)).getName(), i);
            ++i;
        }
    }

    private void createPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(panel);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)panel);
        Button addButton = toolkit.createButton(panel, "Add", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addButton);
        addButton.setImage(Images.getImageDescriptor("IMG_OBJ_ADD").createImage());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioProperties.this.addNew();
            }
        });
        Button removeButton = toolkit.createButton(panel, "Remove", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)removeButton);
        removeButton.setImage(Images.getImageDescriptor("IMG_ETOOL_DELETE").createImage());
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)removeButton), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                IViewerObservableList selection = ViewersObservables.observeMultiSelection((Viewer)ScenarioProperties.this.viewer);
                if (selection.size() == 1 && selection.get(0) == newParameterItem) {
                    return false;
                }
                return !selection.isEmpty();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioProperties.this.removeSelected();
            }
        });
    }

    protected void addNew() {
        this.lastNewName = "";
        this.viewer.editElement((Object)newParameterItem, 0);
    }

    protected void removeSelected() {
        Object[] selection = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        ArrayList<Object> removed = new ArrayList<Object>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != newParameterItem) {
                this.getNamedElement().getProperties().remove(o);
                this.nameToIndex.remove(((ScenarioProperty)o).getName());
                removed.add(o);
            }
            ++n2;
        }
        this.viewer.remove(removed.toArray());
    }

    private boolean validateName(Object element, String name) {
        ScenarioProperty param = (ScenarioProperty)element;
        String error = null;
        if (StringUtils.isBlank((String)name)) {
            error = "Blank name";
        } else {
            for (ScenarioProperty p : this.getNamedElement().getProperties()) {
                if (p == param || !p.getName().equals(name)) continue;
                error = "Duplicate property name";
                break;
            }
            if (error == null) {
                char[] cArray = name.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (Character.isSpaceChar(c)) {
                        error = "Space characters are not supported as key names";
                        break;
                    }
                    if (c == '\"') {
                        error = "Quatations are not supported as key names";
                        break;
                    }
                    ++n2;
                }
                if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                    error = "Invalid key name";
                }
            }
        }
        if (error != null && this.table.getSelection().length > 0) {
            this.lastNewName = name;
            Rectangle b = this.table.getSelection()[0].getBounds();
            Point p = this.table.toDisplay(b.x, b.y);
            this.tip.setLocation(p.x + 16, p.y + b.height);
            this.tip.setMessage(error);
            this.tip.setVisible(false);
            this.tip.setVisible(true);
            return false;
        }
        this.tip.setVisible(false);
        this.lastNewName = "";
        return true;
    }

    private boolean isNewAndBlank(Object element, String name) {
        return element == newParameterItem && StringUtils.isBlank((String)name);
    }

    @Override
    public NamedElementEditorActions.INamedElementActions createActions() {
        return this.actions;
    }

    @Override
    public String getName() {
        return "Properties";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public void update(Scenario element) {
        this.setNamedElement(element);
        this.viewer.setInput((Object)element);
    }

    private class Comparator
    extends ViewerComparator {
        private final TableColumn column;
        private final int direction;

        public Comparator() {
            this(null, 0);
        }

        public Comparator(TableColumn column, int direction) {
            this.column = column;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ScenarioProperty a = (ScenarioProperty)e1;
            ScenarioProperty b = (ScenarioProperty)e2;
            if (a == newParameterItem) {
                return 1;
            }
            if (b == newParameterItem) {
                return -1;
            }
            if (this.column == null && ScenarioProperties.this.nameToIndex.containsKey(a.getName()) && ScenarioProperties.this.nameToIndex.containsKey(b.getName())) {
                return (Integer)ScenarioProperties.this.nameToIndex.get(a.getName()) - (Integer)ScenarioProperties.this.nameToIndex.get(b.getName());
            }
            String strA = this.column == ScenarioProperties.this.nameColumn ? a.getName() : a.getValue();
            String strB = this.column == ScenarioProperties.this.nameColumn ? b.getName() : b.getValue();
            int r = strA.compareTo(strB);
            return this.direction == 128 ? r : -r;
        }

        public boolean isSorterProperty(Object element, String property) {
            if (this.column == ScenarioProperties.this.nameColumn) {
                return ScenarioProperties.NAME_PROPERTY.equals(property);
            }
            if (this.column == ScenarioProperties.this.valueColumn) {
                return ScenarioProperties.VALUE_PROPERTY.equals(property);
            }
            return false;
        }
    }
}

