/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.rap;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class RAPLaunchConfig {
    public static final int MIN_PORT_NUMBER = 0;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_SESSION_TIMEOUT = 0;
    public static final int MAX_SESSION_TIMEOUT = Integer.MAX_VALUE;
    private static final String PREFIX = "org.eclipse.rap.launch.";
    public static final String SERVLET_PATH = "org.eclipse.rap.launch.servletPath";
    public static final String BROWSER_COMMAND = "org.eclipse.rap.launch.browserCommand";
    public static final String OPEN_BROWSER = "org.eclipse.rap.launch.openBrowser";
    public static final String BROWSER_MODE = "org.eclipse.rap.launch.browserMode";
    public static final String PORT = "org.eclipse.rap.launch.port";
    public static final String USE_MANUAL_PORT = "org.eclipse.rap.launch.useManualPort";
    public static final String CONTEXTPATH = "org.eclipse.rap.launch.contextpath";
    public static final String USE_MANUAL_CONTEXTPATH = "org.eclipse.rap.launch.useManualContextPath";
    public static final String SESSION_TIMEOUT = "org.eclipse.rap.launch.sessionTimeout";
    public static final String USE_SESSION_TIMEOUT = "org.eclipse.rap.launch.useSessionTimeout";
    public static final String DEVELOPMENT_MODE = "org.eclipse.rap.launch.developmentMode";
    public static final String USE_DEFAULT_DATA_LOCATION = "org.eclipse.rap.launch.useDefaultDataLocation";
    public static final String DATA_LOCATION = "org.eclipse.rap.launch.dataLocation";
    private static final String DEFAULT_SERVLET_PATH = "/";
    private static final BrowserMode DEFAULT_BROWSER_MODE = BrowserMode.EXTERNAL;
    private static final int DEFAULT_PORT = 10080;
    private static final boolean DEFAULT_USE_MANUAL_PORT = true;
    private static final String DEFAULT_CONTEXTPATH = "/";
    private static final boolean DEFAULT_USE_MANUAL_CONTEXTPATH = false;
    private static final int DEFAULT_SESSION_TIMEOUT = 0;
    private static final boolean DEFAULT_USE_SESSION_TIMEOUT = false;
    private static final String DEFAULT_DATA_LOCATION = "${workspace_loc}/.metadata/.plugins/";
    private final ILaunchConfiguration config;
    private final ILaunchConfigurationWorkingCopy workingCopy;

    public static void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(SERVLET_PATH, "/");
        config.setAttribute(BROWSER_MODE, DEFAULT_BROWSER_MODE.getName());
        config.setAttribute(PORT, 10080);
        config.setAttribute(USE_MANUAL_PORT, true);
        config.setAttribute(CONTEXTPATH, "/");
        config.setAttribute(USE_MANUAL_CONTEXTPATH, false);
        config.setAttribute(SESSION_TIMEOUT, 0);
        config.setAttribute(USE_SESSION_TIMEOUT, false);
        config.setAttribute(DEVELOPMENT_MODE, false);
        config.setAttribute(USE_DEFAULT_DATA_LOCATION, true);
        config.setAttribute("clearws", false);
        config.setAttribute("askclear", false);
        String defaultDataLocation = RAPLaunchConfig.getDefaultDataLocation(config.getName());
        config.setAttribute(DATA_LOCATION, defaultDataLocation);
        config.setAttribute(BROWSER_COMMAND, null);
    }

    public static String getDefaultDataLocation(String name) {
        return "${workspace_loc}/.metadata/.plugins/org.eclipse.rcptt.launching.rap/" + name.replaceAll("\\s", "");
    }

    public RAPLaunchConfig(ILaunchConfiguration config) {
        this.config = config;
        this.workingCopy = config instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)config : null;
    }

    public String getName() {
        return this.config.getName();
    }

    public ILaunchConfiguration getUnderlyingLaunchConfig() {
        return this.config;
    }

    public String getBrowserCommand() throws CoreException {
        return this.config.getAttribute(BROWSER_COMMAND, null);
    }

    public void setBrowserCommand(String cmd) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(BROWSER_COMMAND, cmd);
    }

    public boolean getAskClearDataLocation() throws CoreException {
        return this.config.getAttribute("askclear", false);
    }

    public void setAskClearDataLocation(boolean askClear) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute("askclear", askClear);
    }

    public boolean getDoClearDataLocation() throws CoreException {
        return this.config.getAttribute("clearws", false);
    }

    public void setDoClearDataLocation(boolean doClear) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute("clearws", doClear);
    }

    public boolean getUseDefaultDatatLocation() throws CoreException {
        return this.config.getAttribute(USE_DEFAULT_DATA_LOCATION, true);
    }

    public void setUseDefaultDataLocation(boolean useDefaultDataLocation) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_DEFAULT_DATA_LOCATION, useDefaultDataLocation);
    }

    public String getDataLocation() throws CoreException {
        return this.config.getAttribute(DATA_LOCATION, RAPLaunchConfig.getDefaultDataLocation(this.getName()));
    }

    public void setDataLocation(String dataLocation) {
        if (dataLocation == null) {
            throw new NullPointerException("dataLocation");
        }
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(DATA_LOCATION, dataLocation);
    }

    public String getServletPath() throws CoreException {
        return this.config.getAttribute(SERVLET_PATH, "/");
    }

    public void setServletPath(String servletPath) {
        if (servletPath == null) {
            throw new NullPointerException("servletPath");
        }
        this.checkWorkingCopy();
        if (!servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        this.workingCopy.setAttribute(SERVLET_PATH, servletPath);
    }

    public boolean getOpenBrowser() throws CoreException {
        return this.config.getAttribute(OPEN_BROWSER, true);
    }

    public void setOpenBrowser(boolean openBrowser) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(OPEN_BROWSER, openBrowser);
    }

    public BrowserMode getBrowserMode() throws CoreException {
        String value = this.config.getAttribute(BROWSER_MODE, BrowserMode.INTERNAL.getName());
        return BrowserMode.parse(value);
    }

    public void setBrowserMode(BrowserMode browserMode) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(BROWSER_MODE, browserMode.getName());
    }

    public boolean getUseManualPort() throws CoreException {
        return this.config.getAttribute(USE_MANUAL_PORT, true);
    }

    public void setUseManualPort(boolean useManualPort) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_MANUAL_PORT, useManualPort);
    }

    public int getPort() throws CoreException {
        return this.config.getAttribute(PORT, 10080);
    }

    public void setPort(int port) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(PORT, port);
    }

    public boolean getUseManualContextPath() throws CoreException {
        return this.config.getAttribute(USE_MANUAL_CONTEXTPATH, false);
    }

    public void setUseManualContextPath(boolean useManualContextPath) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_MANUAL_CONTEXTPATH, useManualContextPath);
    }

    public String getContextPath() throws CoreException {
        return this.config.getAttribute(CONTEXTPATH, "/");
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new NullPointerException("contextPath");
        }
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(CONTEXTPATH, contextPath);
    }

    public boolean getUseSessionTimeout() throws CoreException {
        return this.config.getAttribute(USE_SESSION_TIMEOUT, false);
    }

    public void setUseSessionTimeout(boolean useSessionTimeout) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_SESSION_TIMEOUT, useSessionTimeout);
    }

    public int getSessionTimeout() throws CoreException {
        return this.config.getAttribute(SESSION_TIMEOUT, 0);
    }

    public void setSessionTimeout(int timeout) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(SESSION_TIMEOUT, timeout);
    }

    public boolean getDevelopmentMode() throws CoreException {
        return this.config.getAttribute(DEVELOPMENT_MODE, false);
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(DEVELOPMENT_MODE, developmentMode);
    }

    private void checkWorkingCopy() {
        if (this.workingCopy == null) {
            String msg = "Launch configuration cannot be modified, no working copy available";
            throw new IllegalStateException(msg);
        }
    }

    public static final class BrowserMode {
        public static final BrowserMode INTERNAL = new BrowserMode("INTERNAL");
        public static final BrowserMode EXTERNAL = new BrowserMode("EXTERNAL");
        private final String name;

        private BrowserMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static BrowserMode[] values() {
            return new BrowserMode[]{INTERNAL, EXTERNAL};
        }

        public static BrowserMode parse(String name) {
            BrowserMode result = null;
            BrowserMode[] knownValues = BrowserMode.values();
            int i = 0;
            while (result == null && i < knownValues.length) {
                if (knownValues[i].getName().equalsIgnoreCase(name)) {
                    result = knownValues[i];
                }
                ++i;
            }
            if (result == null) {
                String text = "Unknown BrowserMode ''{0}''.";
                String msg = MessageFormat.format(text, name);
                throw new IllegalArgumentException(msg);
            }
            return result;
        }
    }
}

