/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import java.util.Arrays;
import org.eclipse.rcptt.expandbar.runtime.internal.ExpandBarPlayerExtension;
import org.eclipse.rcptt.expandbar.widgets.ExpandItem;
import org.eclipse.rcptt.expandbar.widgets.WidgetsFactory;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.Collapse;
import org.eclipse.rcptt.tesla.core.protocol.Expand;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.ui.Control;
import org.eclipse.rcptt.tesla.core.ui.Image;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.SWTElementMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTModelMapperExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.widgets.ExpandBar;

public class ExpandBarUIProcessor
implements ISWTModelMapperExtension,
ITeslaCommandProcessor {
    private final ExpandBarPlayerExtension ext = new ExpandBarPlayerExtension();
    private AbstractTeslaClient client;

    public int getPriority() {
        return 325;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
        SWTUIPlayer.addExtension((ISWTUIPlayerExtension)this.ext);
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void terminate() {
        SWTUIPlayer.removeExtension((ISWTUIPlayerExtension)this.ext);
        this.client = null;
    }

    public Widget mapExtraValues(SWTUIElement element, Widget result) {
        return ExpandBarUIProcessor.mapWidget(element, result);
    }

    public static Widget mapWidget(SWTUIElement element, Widget result) {
        org.eclipse.swt.widgets.Widget widget = element.unwrap();
        if (widget instanceof org.eclipse.swt.widgets.ExpandItem) {
            return ExpandBarUIProcessor.mapItem((org.eclipse.swt.widgets.ExpandItem)widget);
        }
        if (widget instanceof ExpandBar) {
            return ExpandBarUIProcessor.mapBar((ExpandBar)widget);
        }
        return result;
    }

    private static org.eclipse.rcptt.expandbar.widgets.ExpandBar mapBar(ExpandBar bar) {
        org.eclipse.rcptt.expandbar.widgets.ExpandBar result = WidgetsFactory.eINSTANCE.createExpandBar();
        SWTModelMapper.fillControl((Control)result, (org.eclipse.swt.widgets.Control)bar);
        org.eclipse.swt.widgets.ExpandItem[] expandItemArray = bar.getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.swt.widgets.ExpandItem item = expandItemArray[n2];
            result.getItems().add((Object)ExpandBarUIProcessor.mapItem(item));
            ++n2;
        }
        return result;
    }

    private static ExpandItem mapItem(org.eclipse.swt.widgets.ExpandItem item) {
        int index = Arrays.asList(item.getParent().getItems()).indexOf(item);
        ExpandItem result = WidgetsFactory.eINSTANCE.createExpandItem();
        result.setCaption(item.getText());
        result.setExpanded(item.getExpanded());
        result.setIndex(index);
        Image image = SWTModelMapper.mapImage((org.eclipse.swt.graphics.Image)item.getImage());
        if (image != null) {
            result.setImage(image);
        }
        return result;
    }

    public boolean isSelectorSupported(String kind) {
        return "org.eclipse.swt.widgets.ExpandBar".equals(kind);
    }

    public boolean isCommandSupported(Command cmd) {
        return cmd instanceof Expand || cmd instanceof Collapse;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void postSelect(Element element, IElementProcessorMapper processorMapper) {
        SWTElementMapper elementMapper = this.getMapper();
        if (elementMapper == null) {
            return;
        }
        SWTUIElement swtElement = (SWTUIElement)elementMapper.get(element);
        if (swtElement == null) {
            return;
        }
        org.eclipse.swt.widgets.Widget widget = swtElement.unwrap();
        if (widget instanceof org.eclipse.swt.widgets.ExpandItem) {
            processorMapper.map(element, (ITeslaCommandProcessor)this);
        }
    }

    private SWTElementMapper getMapper() {
        return this.getSWTProcessor().getMapper();
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        if (command instanceof Collapse) {
            SWTUIElement element = (SWTUIElement)this.getMapper().get(((Collapse)command).getElement());
            org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget((SWTUIElement)element);
            if (widget instanceof ExpandBar) {
                return SWTUIProcessor.failResponse((String)"'collapse' can be used only with ExpandBar items. Use 'collapse-all' to collapse all items.");
            }
            if (!(widget instanceof org.eclipse.swt.widgets.ExpandItem)) {
                return null;
            }
            final org.eclipse.swt.widgets.ExpandItem item = (org.eclipse.swt.widgets.ExpandItem)widget;
            this.getPlayer().exec("Collapsing ExpandItem", new Runnable(){

                @Override
                public void run() {
                    ExpandBarUIProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)item.getParent(), (org.eclipse.swt.widgets.Widget)item, 18);
                    item.setExpanded(false);
                }
            });
            return SWTUIProcessor.okResponse();
        }
        if (command instanceof Expand) {
            SWTUIElement element = (SWTUIElement)this.getMapper().get(((Expand)command).getElement());
            org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget((SWTUIElement)element);
            if (widget instanceof ExpandBar) {
                return SWTUIProcessor.failResponse((String)"'expand' can be used only with ExpandBar items. Use 'expand-all' to expand all items.");
            }
            if (!(widget instanceof org.eclipse.swt.widgets.ExpandItem)) {
                return null;
            }
            final org.eclipse.swt.widgets.ExpandItem item = (org.eclipse.swt.widgets.ExpandItem)widget;
            this.getPlayer().exec("Expanding ExpandItem", new Runnable(){

                @Override
                public void run() {
                    ExpandBarUIProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)item.getParent(), (org.eclipse.swt.widgets.Widget)item, 17);
                    item.setExpanded(true);
                }
            });
            return SWTUIProcessor.okResponse();
        }
        return null;
    }

    private SWTUIProcessor getSWTProcessor() {
        return (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
    }

    private SWTUIPlayer getPlayer() {
        return this.getSWTProcessor().getPlayer();
    }

    public String getFeatureID() {
        return this.getSWTProcessor().getFeatureID();
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        return this.getSWTProcessor().select(cmd, generator, mapper);
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return null;
    }

    public boolean isInactivityRequired() {
        return true;
    }

    public void clean() {
    }

    public void checkHang() {
    }

    public void notifyUI() {
    }
}

