/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.fix.ImportsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ImportsCleanUp
extends AbstractCleanUp {
    private CodeGenerationSettings fCodeGeneratorSettings;
    private RefactoringStatus fStatus;

    public ImportsCleanUp(Map<String, String> options) {
        super(options);
    }

    public ImportsCleanUp() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean isOrganizeImports = this.isEnabled("cleanup.organize_imports");
        return new CleanUpRequirements(isOrganizeImports, isOrganizeImports, false, null);
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        return ImportsFix.createCleanUp(compilationUnit, this.fCodeGeneratorSettings, this.isEnabled("cleanup.organize_imports"), this.fStatus);
    }

    @Override
    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        if (this.isEnabled("cleanup.organize_imports")) {
            this.fCodeGeneratorSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
            this.fStatus = new RefactoringStatus();
        }
        return super.checkPreConditions(project, compilationUnits, monitor);
    }

    @Override
    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        this.fCodeGeneratorSettings = null;
        try {
            if (this.fStatus == null || this.fStatus.isOK()) {
                RefactoringStatus refactoringStatus = super.checkPostConditions(monitor);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = this.fStatus;
            return refactoringStatus;
        }
        finally {
            this.fStatus = null;
        }
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.organize_imports")) {
            return new String[]{MultiFixMessages.ImportsCleanUp_OrganizeImports_Description};
        }
        return null;
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.organize_imports")) {
            buf.append("import org.model.Engine;\n");
        } else {
            buf.append("import org.model.*;\n");
        }
        return buf.toString();
    }
}

