/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.InferTypeArgumentsDescriptor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;

public class InferTypeArgumentsRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_CLONE = "clone";
    private static final String ATTRIBUTE_LEAVE = "leave";
    private static final String REWRITTEN = "InferTypeArgumentsRefactoring.rewritten";
    private TextChangeManager fChangeManager;
    private IJavaElement[] fElements;
    private InferTypeArgumentsTCModel fTCModel;
    private boolean fAssumeCloneReturnsSameType;
    private boolean fLeaveUnconstrainedRaw;

    public InferTypeArgumentsRefactoring(IJavaElement[] elements) {
        this.fElements = elements;
    }

    public InferTypeArgumentsRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public String getName() {
        return RefactoringCoreMessages.InferTypeArgumentsRefactoring_name;
    }

    public void setAssumeCloneReturnsSameType(boolean assume) {
        this.fAssumeCloneReturnsSameType = assume;
    }

    public boolean getAssumeCloneReturnsSameType() {
        return this.fAssumeCloneReturnsSameType;
    }

    public void setLeaveUnconstrainedRaw(boolean raw) {
        this.fLeaveUnconstrainedRaw = raw;
    }

    public boolean getLeaveUnconstrainedRaw() {
        return this.fLeaveUnconstrainedRaw;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = this.check15();
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<IJavaProject, ArrayList<IJavaElement>> projectsToElements = this.getJavaElementsPerProject(this.fElements);
        pm.beginTask("", projectsToElements.size() + 2);
        final RefactoringStatus result = new RefactoringStatus();
        try {
            this.fTCModel = new InferTypeArgumentsTCModel();
            final InferTypeArgumentsConstraintCreator unitCollector = new InferTypeArgumentsConstraintCreator(this.fTCModel, this.fAssumeCloneReturnsSameType);
            for (Map.Entry<IJavaProject, ArrayList<IJavaElement>> entry : projectsToElements.entrySet()) {
                IJavaProject project = entry.getKey();
                ArrayList<IJavaElement> javaElementsList = entry.getValue();
                IJavaElement[] javaElements = javaElementsList.toArray(new IJavaElement[javaElementsList.size()]);
                List<ICompilationUnit> cus = Arrays.asList(JavaModelUtil.getAllCompilationUnits((IJavaElement[])javaElements));
                int batchSize = 150;
                int batches = (cus.size() - 1) / batchSize + 1;
                SubProgressMonitor projectMonitor = new SubProgressMonitor(pm, 1);
                projectMonitor.beginTask("", batches);
                projectMonitor.setTaskName(RefactoringCoreMessages.InferTypeArgumentsRefactoring_building);
                int i = 0;
                while (i < batches) {
                    List<ICompilationUnit> batch = cus.subList(i * batchSize, Math.min(cus.size(), (i + 1) * batchSize));
                    ICompilationUnit[] batchCus = batch.toArray(new ICompilationUnit[batch.size()]);
                    final SubProgressMonitor batchMonitor = new SubProgressMonitor((IProgressMonitor)projectMonitor, 1);
                    batchMonitor.subTask(RefactoringCoreMessages.InferTypeArgumentsRefactoring_calculating_dependencies);
                    ASTParser parser = ASTParser.newParser((int)8);
                    parser.setProject(project);
                    parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
                    parser.setResolveBindings(true);
                    parser.createASTs(batchCus, new String[0], new ASTRequestor(){

                        public void acceptAST(final ICompilationUnit source, final CompilationUnit ast) {
                            batchMonitor.subTask(BasicElementLabels.getFileName((ITypeRoot)source));
                            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                public void run() throws Exception {
                                    IProblem[] problems = ast.getProblems();
                                    int p = 0;
                                    while (p < problems.length) {
                                        if (problems[p].isError()) {
                                            String cuName = JavaElementLabels.getElementLabel((IJavaElement)source, 0x80000000L);
                                            String msg = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_error_in_cu_skipped, new Object[]{cuName});
                                            result.addError(msg, JavaStatusContext.create((ITypeRoot)source, SourceRangeFactory.create(problems[p])));
                                            return;
                                        }
                                        ++p;
                                    }
                                    ast.accept((ASTVisitor)unitCollector);
                                }

                                public void handleException(Throwable exception) {
                                    String cuName = JavaElementLabels.getElementLabel((IJavaElement)source, 0x80000000L);
                                    String msg = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_internal_error, new Object[]{cuName});
                                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null));
                                    String msg2 = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_error_skipped, new Object[]{cuName});
                                    result.addError(msg2, JavaStatusContext.create((ITypeRoot)source));
                                }
                            });
                            InferTypeArgumentsRefactoring.this.fTCModel.newCu();
                        }

                        public void acceptBinding(String bindingKey, IBinding binding) {
                        }
                    }, (IProgressMonitor)batchMonitor);
                    ++i;
                }
                projectMonitor.done();
                this.fTCModel.newCu();
            }
            pm.setTaskName(RefactoringCoreMessages.InferTypeArgumentsRefactoring_solving);
            InferTypeArgumentsConstraintsSolver solver = new InferTypeArgumentsConstraintsSolver(this.fTCModel);
            InferTypeArgumentsUpdate updates = solver.solveConstraints((IProgressMonitor)new SubProgressMonitor(pm, 1));
            solver = null;
            this.fChangeManager = new TextChangeManager();
            this.rewriteDeclarations(updates, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IFile[] filesToModify = ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
            result.merge(Checks.validateModifiesFiles(filesToModify, this.getValidationContext()));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
            this.clearGlobalState();
        }
    }

    private void clearGlobalState() {
        TypeSet.resetCount();
        EnumeratedTypeSet.resetCount();
        this.fTCModel = null;
    }

    private HashMap<IJavaProject, ArrayList<IJavaElement>> getJavaElementsPerProject(IJavaElement[] elements) {
        HashMap<IJavaProject, ArrayList<IJavaElement>> result = new HashMap<IJavaProject, ArrayList<IJavaElement>>();
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            IJavaProject javaProject = element.getJavaProject();
            ArrayList<Object> javaElements = result.get(javaProject);
            if (javaElements == null) {
                javaElements = new ArrayList();
                result.put(javaProject, javaElements);
            }
            javaElements.add(element);
            ++i;
        }
        return result;
    }

    private RefactoringStatus check15() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        HashSet<IJavaProject> checkedProjects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < this.fElements.length) {
            IJavaProject javaProject = this.fElements[i].getJavaProject();
            if (!checkedProjects.contains(javaProject)) {
                String message;
                if (!JavaModelUtil.is50OrHigher((IJavaProject)javaProject)) {
                    message = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_not50, BasicElementLabels.getJavaElementName((String)javaProject.getElementName()));
                    result.addFatalError(message);
                } else if (!JavaModelUtil.is50OrHigherJRE((IJavaProject)javaProject)) {
                    message = Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_not50Library, BasicElementLabels.getJavaElementName((String)javaProject.getElementName()));
                    result.addFatalError(message);
                }
                checkedProjects.add(javaProject);
            }
            ++i;
        }
        return result;
    }

    private void rewriteDeclarations(InferTypeArgumentsUpdate update, IProgressMonitor pm) throws CoreException {
        HashMap<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate> updates = update.getUpdates();
        Set<Map.Entry<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate>> entrySet = updates.entrySet();
        pm.beginTask("", entrySet.size());
        pm.setTaskName(RefactoringCoreMessages.InferTypeArgumentsRefactoring_creatingChanges);
        Iterator<Map.Entry<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Map.Entry<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate> entry = iter.next();
            ICompilationUnit cu = entry.getKey();
            pm.worked(1);
            pm.subTask(BasicElementLabels.getFileName((ITypeRoot)cu));
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(cu);
            rewrite.setResolveBindings(false);
            InferTypeArgumentsUpdate.CuUpdate cuUpdate = entry.getValue();
            for (ConstraintVariable2 constraintVariable2 : cuUpdate.getDeclarations()) {
                InferTypeArgumentsRefactoring.rewriteConstraintVariable(constraintVariable2, rewrite, this.fTCModel, this.fLeaveUnconstrainedRaw, null);
            }
            for (CastVariable2 castVariable2 : cuUpdate.getCastsToRemove()) {
                InferTypeArgumentsRefactoring.rewriteCastVariable(castVariable2, rewrite, this.fTCModel);
            }
            CompilationUnitChange change = rewrite.createChange(true);
            if (change == null) continue;
            this.fChangeManager.manage(cu, (TextChange)change);
        }
    }

    public static ParameterizedType[] inferArguments(SimpleType[] types, InferTypeArgumentsUpdate update, InferTypeArgumentsTCModel model, CompilationUnitRewrite rewrite) {
        int i = 0;
        while (i < types.length) {
            types[i].setProperty(REWRITTEN, null);
            ++i;
        }
        ArrayList<ParameterizedType> result = new ArrayList<ParameterizedType>();
        HashMap<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate> updates = update.getUpdates();
        Set<Map.Entry<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate>> entrySet = updates.entrySet();
        for (Map.Entry<ICompilationUnit, InferTypeArgumentsUpdate.CuUpdate> entry : entrySet) {
            rewrite.setResolveBindings(false);
            InferTypeArgumentsUpdate.CuUpdate cuUpdate = entry.getValue();
            for (ConstraintVariable2 constraintVariable2 : cuUpdate.getDeclarations()) {
                ParameterizedType newNode = InferTypeArgumentsRefactoring.rewriteConstraintVariable(constraintVariable2, rewrite, model, false, types);
                if (newNode == null) continue;
                result.add(newNode);
            }
        }
        return result.toArray(new ParameterizedType[result.size()]);
    }

    private static ParameterizedType rewriteConstraintVariable(ConstraintVariable2 cv, CompilationUnitRewrite rewrite, InferTypeArgumentsTCModel tCModel, boolean leaveUnconstraindRaw, SimpleType[] types) {
        ConstraintVariable2 parentElement;
        if (cv instanceof CollectionElementVariable2 && (parentElement = ((CollectionElementVariable2)cv).getParentConstraintVariable()) instanceof TypeVariable2) {
            TypeVariable2 typeCv = (TypeVariable2)parentElement;
            return InferTypeArgumentsRefactoring.rewriteTypeVariable(typeCv, rewrite, tCModel, leaveUnconstraindRaw, types);
        }
        return null;
    }

    private static ParameterizedType rewriteTypeVariable(TypeVariable2 typeCv, CompilationUnitRewrite rewrite, InferTypeArgumentsTCModel tCModel, boolean leaveUnconstraindRaw, SimpleType[] types) {
        ASTNode node = typeCv.getRange().getNode(rewrite.getRoot());
        if (node instanceof Name && node.getParent() instanceof Type) {
            Type originalType = (Type)node.getParent();
            if (types != null && !InferTypeArgumentsRefactoring.has(types, originalType)) {
                return null;
            }
            Object rewritten = originalType.getProperty(REWRITTEN);
            if (rewritten == REWRITTEN) {
                return null;
            }
            originalType.setProperty(REWRITTEN, (Object)REWRITTEN);
            ArrayList<CollectionElementVariable2> typeArgumentCvs = InferTypeArgumentsRefactoring.getTypeArgumentCvs(typeCv, tCModel);
            Type[] typeArguments = InferTypeArgumentsRefactoring.getTypeArguments(originalType, typeArgumentCvs, rewrite, tCModel, leaveUnconstraindRaw);
            if (typeArguments == null) {
                return null;
            }
            Type movingType = (Type)rewrite.getASTRewrite().createMoveTarget((ASTNode)originalType);
            ParameterizedType newType = rewrite.getAST().newParameterizedType(movingType);
            int i = 0;
            while (i < typeArguments.length) {
                newType.typeArguments().add(typeArguments[i]);
                ++i;
            }
            rewrite.getASTRewrite().replace((ASTNode)originalType, (ASTNode)newType, rewrite.createGroupDescription(RefactoringCoreMessages.InferTypeArgumentsRefactoring_addTypeArguments));
            return newType;
        }
        return null;
    }

    private static boolean has(SimpleType[] types, Type originalType) {
        int i = 0;
        while (i < types.length) {
            if (types[i] == originalType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Type[] getTypeArguments(Type baseType, ArrayList<CollectionElementVariable2> typeArgumentCvs, CompilationUnitRewrite rewrite, InferTypeArgumentsTCModel tCModel, boolean leaveUnconstraindRaw) {
        if (typeArgumentCvs.size() == 0) {
            return null;
        }
        Type[] typeArguments = new Type[typeArgumentCvs.size()];
        int i = 0;
        while (i < typeArgumentCvs.size()) {
            WildcardType typeArgument;
            CollectionElementVariable2 elementCv = typeArgumentCvs.get(i);
            TType chosenType = InferTypeArgumentsConstraintsSolver.getChosenType(elementCv);
            if (chosenType != null) {
                ArrayList<CollectionElementVariable2> nestedTypeArgumentCvs;
                if (chosenType.isWildcardType() && !InferTypeArgumentsRefactoring.unboundedWildcardAllowed(baseType)) {
                    return null;
                }
                if (chosenType.isParameterizedType()) {
                    chosenType = chosenType.getTypeDeclaration();
                }
                BindingKey bindingKey = new BindingKey(chosenType.getBindingKey());
                typeArgument = rewrite.getImportRewrite().addImportFromSignature(bindingKey.toSignature(), rewrite.getAST());
                Type[] nestedTypeArguments = InferTypeArgumentsRefactoring.getTypeArguments((Type)typeArgument, nestedTypeArgumentCvs = InferTypeArgumentsRefactoring.getTypeArgumentCvs(elementCv, tCModel), rewrite, tCModel, leaveUnconstraindRaw);
                if (nestedTypeArguments != null) {
                    ParameterizedType parameterizedType = rewrite.getAST().newParameterizedType((Type)typeArgument);
                    int j = 0;
                    while (j < nestedTypeArguments.length) {
                        parameterizedType.typeArguments().add(nestedTypeArguments[j]);
                        ++j;
                    }
                    typeArgument = parameterizedType;
                }
            } else {
                if (leaveUnconstraindRaw) {
                    return null;
                }
                if (InferTypeArgumentsRefactoring.unboundedWildcardAllowed(baseType)) {
                    typeArgument = rewrite.getAST().newWildcardType();
                } else {
                    String object = rewrite.getImportRewrite().addImport("java.lang.Object");
                    typeArgument = (Type)rewrite.getASTRewrite().createStringPlaceholder(object, 43);
                }
            }
            typeArguments[i] = typeArgument;
            ++i;
        }
        return typeArguments;
    }

    private static ArrayList<CollectionElementVariable2> getTypeArgumentCvs(ConstraintVariable2 baseCv, InferTypeArgumentsTCModel tCModel) {
        Map<String, CollectionElementVariable2> elementCvs = tCModel.getElementVariables(baseCv);
        ArrayList<CollectionElementVariable2> typeArgumentCvs = new ArrayList<CollectionElementVariable2>();
        for (CollectionElementVariable2 elementCv : elementCvs.values()) {
            int index = elementCv.getDeclarationTypeVariableIndex();
            if (index == -1) continue;
            while (index >= typeArgumentCvs.size()) {
                typeArgumentCvs.add(null);
            }
            typeArgumentCvs.set(index, elementCv);
        }
        return typeArgumentCvs;
    }

    private static boolean unboundedWildcardAllowed(Type originalType) {
        ASTNode parent = originalType.getParent();
        while (parent instanceof Type) {
            parent = parent.getParent();
        }
        if (parent instanceof ClassInstanceCreation) {
            return false;
        }
        if (parent instanceof AbstractTypeDeclaration) {
            return false;
        }
        return !(parent instanceof TypeLiteral);
    }

    private static ASTNode rewriteCastVariable(CastVariable2 castCv, CompilationUnitRewrite rewrite, InferTypeArgumentsTCModel tCModel) {
        ASTNode node = castCv.getRange().getNode(rewrite.getRoot());
        ConstraintVariable2 expressionVariable = castCv.getExpressionVariable();
        ConstraintVariable2 methodReceiverCv = tCModel.getMethodReceiverCv(expressionVariable);
        if (methodReceiverCv != null) {
            TType chosenReceiverType = InferTypeArgumentsConstraintsSolver.getChosenType(methodReceiverCv);
            if (chosenReceiverType == null) {
                return null;
            }
            if (!InferTypeArgumentsTCModel.isAGenericType(chosenReceiverType)) {
                return null;
            }
            if (InferTypeArgumentsRefactoring.hasUnboundElement(methodReceiverCv, tCModel)) {
                return null;
            }
        }
        CastExpression castExpression = (CastExpression)node;
        Expression expression = castExpression.getExpression();
        Object nodeToReplace = castExpression.getParent() instanceof ParenthesizedExpression ? castExpression.getParent() : castExpression;
        Expression newExpression = (Expression)rewrite.getASTRewrite().createMoveTarget((ASTNode)expression);
        rewrite.getASTRewrite().replace((ASTNode)nodeToReplace, (ASTNode)newExpression, rewrite.createGroupDescription(RefactoringCoreMessages.InferTypeArgumentsRefactoring_removeCast));
        rewrite.getImportRemover().registerRemovedNode((ASTNode)nodeToReplace);
        return newExpression;
    }

    private static boolean hasUnboundElement(ConstraintVariable2 methodReceiverCv, InferTypeArgumentsTCModel tCModel) {
        ArrayList<CollectionElementVariable2> typeArgumentCvs = InferTypeArgumentsRefactoring.getTypeArgumentCvs(methodReceiverCv, tCModel);
        for (CollectionElementVariable2 elementCv : typeArgumentCvs) {
            TType chosenElementType = InferTypeArgumentsConstraintsSolver.getChosenType(elementCv);
            if (chosenElementType != null) continue;
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            DynamicValidationStateChange result;
            DynamicValidationStateChange dynamicValidationStateChange = result = new DynamicValidationStateChange(RefactoringCoreMessages.InferTypeArgumentsRefactoring_name, (Change[])this.fChangeManager.getAllChanges()){

                public final ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    IJavaProject project = InferTypeArgumentsRefactoring.this.getSingleProject();
                    String description = RefactoringCoreMessages.InferTypeArgumentsRefactoring_descriptor_description;
                    String header = project != null ? Messages.format(RefactoringCoreMessages.InferTypeArgumentsRefactoring_descriptor_description_project, BasicElementLabels.getJavaElementName((String)project.getElementName())) : RefactoringCoreMessages.InferTypeArgumentsRefactoring_descriptor_description;
                    String name = project != null ? project.getElementName() : null;
                    JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(name, this, header);
                    String[] settings = new String[InferTypeArgumentsRefactoring.this.fElements.length];
                    int index = 0;
                    while (index < settings.length) {
                        settings[index] = JavaElementLabels.getTextLabel(InferTypeArgumentsRefactoring.this.fElements[index], JavaElementLabels.ALL_FULLY_QUALIFIED);
                        ++index;
                    }
                    comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.InferTypeArgumentsRefactoring_original_elements, settings));
                    if (InferTypeArgumentsRefactoring.this.fAssumeCloneReturnsSameType) {
                        comment.addSetting(RefactoringCoreMessages.InferTypeArgumentsRefactoring_assume_clone);
                    }
                    if (InferTypeArgumentsRefactoring.this.fLeaveUnconstrainedRaw) {
                        comment.addSetting(RefactoringCoreMessages.InferTypeArgumentsRefactoring_leave_unconstrained);
                    }
                    InferTypeArgumentsDescriptor descriptor = RefactoringSignatureDescriptorFactory.createInferTypeArgumentsDescriptor((String)name, (String)description, (String)comment.asString(), arguments, (int)6);
                    int index2 = 0;
                    while (index2 < InferTypeArgumentsRefactoring.this.fElements.length) {
                        arguments.put("element" + (index2 + 1), JavaRefactoringDescriptorUtil.elementToHandle(name, InferTypeArgumentsRefactoring.this.fElements[index2]));
                        ++index2;
                    }
                    arguments.put(InferTypeArgumentsRefactoring.ATTRIBUTE_CLONE, Boolean.valueOf(InferTypeArgumentsRefactoring.this.fAssumeCloneReturnsSameType).toString());
                    arguments.put(InferTypeArgumentsRefactoring.ATTRIBUTE_LEAVE, Boolean.valueOf(InferTypeArgumentsRefactoring.this.fLeaveUnconstrainedRaw).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                }
            };
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private IJavaProject getSingleProject() {
        IJavaProject first = null;
        int index = 0;
        while (index < this.fElements.length) {
            IJavaProject project = this.fElements[index].getJavaProject();
            if (project != null) {
                if (first == null) {
                    first = project;
                } else if (!project.equals(first)) {
                    return null;
                }
            }
            ++index;
        }
        return first;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String clone = arguments.getAttribute(ATTRIBUTE_CLONE);
        if (clone == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_CLONE));
        }
        this.fAssumeCloneReturnsSameType = Boolean.valueOf(clone);
        String leave = arguments.getAttribute(ATTRIBUTE_LEAVE);
        if (leave == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_LEAVE));
        }
        this.fLeaveUnconstrainedRaw = Boolean.valueOf(leave);
        int count = 1;
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        String handle = null;
        String attribute = "element" + count;
        RefactoringStatus status = new RefactoringStatus();
        while ((handle = arguments.getAttribute(attribute)) != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.infer.typearguments");
            }
            elements.add(element);
            attribute = "element" + ++count;
        }
        this.fElements = elements.toArray(new IJavaElement[elements.size()]);
        if (elements.isEmpty()) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(null, this.getName(), "org.eclipse.jdt.ui.infer.typearguments");
        }
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }
}

