/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Collection;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.RealCallers;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyLabelDecorator;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

class CallHierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private static final long TEXTFLAGS = 0x210000200029L | JavaElementLabels.ALL_POST_QUALIFIED | 0x2000000000L;
    private static final int IMAGEFLAGS = 3;
    private ILabelDecorator fDecorator = new CallHierarchyLabelDecorator();

    CallHierarchyLabelProvider() {
        super(TEXTFLAGS, 3);
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = element instanceof RealCallers ? ((RealCallers)((Object)element)).getParent() : (MethodWrapper)((Object)element);
            IMember member = methodWrapper.getMember();
            if (member != null) {
                return this.fDecorator.decorateImage(super.getImage(member), (Object)methodWrapper);
            }
            return null;
        }
        if (this.isPendingUpdate(element)) {
            return null;
        }
        return super.getImage(element);
    }

    @Override
    public String getText(Object element) {
        if (this.isNormalMethodWrapper(element)) {
            MethodWrapper wrapper = (MethodWrapper)((Object)element);
            String decorated = this.getElementLabel(wrapper);
            if (this.isSpecialConstructorNode(wrapper)) {
                decorated = Messages.format(CallHierarchyMessages.CallHierarchyLabelProvider_constructor_label, decorated);
            }
            return decorated;
        }
        return this.getSpecialLabel(element);
    }

    @Override
    public StyledString getStyledText(Object element) {
        if (this.isNormalMethodWrapper(element)) {
            MethodWrapper wrapper = (MethodWrapper)((Object)element);
            String decorated = this.getElementLabel(wrapper);
            StyledString styledLabel = super.getStyledText(wrapper.getMember());
            StyledString styledDecorated = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)styledLabel);
            if (this.isSpecialConstructorNode(wrapper)) {
                decorated = Messages.format(CallHierarchyMessages.CallHierarchyLabelProvider_constructor_label, decorated);
                styledDecorated = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)ColoringLabelProvider.INHERITED_STYLER, (StyledString)styledDecorated);
            }
            return styledDecorated;
        }
        String specialLabel = this.getSpecialLabel(element);
        StyledString.Styler styler = element instanceof RealCallers ? ColoringLabelProvider.INHERITED_STYLER : null;
        return new StyledString(specialLabel, styler);
    }

    private boolean isNormalMethodWrapper(Object element) {
        return element instanceof MethodWrapper && ((MethodWrapper)((Object)element)).getMember() != null && !(element instanceof RealCallers);
    }

    private boolean isSpecialConstructorNode(MethodWrapper wrapper) {
        MethodWrapper parentWrapper = wrapper.getParent();
        if (!CallHierarchyContentProvider.isExpandWithConstructors(parentWrapper)) {
            return false;
        }
        IMember member = wrapper.getMember();
        if (member instanceof IType) {
            return true;
        }
        try {
            return member instanceof IMethod && ((IMethod)member).isConstructor();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private String getSpecialLabel(Object element) {
        if (element instanceof RealCallers) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_expandWithConstructorsAction_realCallers;
        }
        if (element instanceof MethodWrapper) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_root;
        }
        if (element == TreeTermination.SEARCH_CANCELED) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_searchCanceled;
        }
        if (this.isPendingUpdate(element)) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_updatePending;
        }
        return CallHierarchyMessages.CallHierarchyLabelProvider_noMethodSelected;
    }

    private boolean isPendingUpdate(Object element) {
        return element instanceof IWorkbenchAdapter;
    }

    private String getElementLabel(MethodWrapper methodWrapper) {
        String label = super.getText(methodWrapper.getMember());
        Collection<CallLocation> callLocations = methodWrapper.getMethodCall().getCallLocations();
        if (callLocations != null && callLocations.size() > 1) {
            return Messages.format(CallHierarchyMessages.CallHierarchyLabelProvider_matches, new String[]{label, String.valueOf(callLocations.size())});
        }
        return label;
    }
}

