/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.ChangeTypeContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ChangeTypeWizard
extends RefactoringWizard {
    private ChangeTypeRefactoring fCT;

    public ChangeTypeWizard(ChangeTypeRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.ChangeTypeWizard_title);
        this.fCT = ref;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeTypeInputPage());
    }

    static String print(Collection<ITypeBinding> types) {
        if (types.isEmpty()) {
            return "{ }";
        }
        String result = "{ ";
        Iterator<ITypeBinding> it = types.iterator();
        while (it.hasNext()) {
            ITypeBinding type = it.next();
            result = String.valueOf(result) + type.getQualifiedName();
            result = it.hasNext() ? String.valueOf(result) + ", " : String.valueOf(result) + " }";
        }
        return result;
    }

    private class ChangeTypeInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeTypeInputPage";
        private final String MESSAGE;
        private ChangeTypeLabelProvider fLabelProvider;
        private TreeViewer fTreeViewer;
        private boolean fTreeUpdated;

        public ChangeTypeInputPage() {
            super(PAGE_NAME);
            this.MESSAGE = RefactoringMessages.ChangeTypeInputPage_Select_Type;
            this.fTreeUpdated = false;
            this.setMessage(this.MESSAGE);
        }

        private TreeItem getInitialSelection(Collection<ITypeBinding> types) {
            ITypeBinding type = types.iterator().next();
            for (ITypeBinding other : types) {
                if (!this.getGeneralizeTypeRefactoring().isSubTypeOf(type, other)) continue;
                type = other;
            }
            return this.findItem(this.fTreeViewer.getTree().getItems(), type);
        }

        private TreeItem findItem(TreeItem[] items, ITypeBinding type) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getData().equals(type)) {
                    return items[i];
                }
                ++i;
            }
            i = 0;
            while (i < items.length) {
                TreeItem item = this.findItem(items[i].getItems(), type);
                if (item != null) {
                    return item;
                }
                ++i;
            }
            return null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            Label label = new Label(composite, 0);
            label.setText(Messages.format(RefactoringMessages.ChangeTypeWizard_pleaseChooseType, ((ChangeTypeRefactoring)this.getRefactoring()).getTarget()));
            label.setLayoutData((Object)new GridData());
            this.addTreeComponent(composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.change_type_wizard_page_context");
        }

        private void addTreeComponent(Composite parent) {
            this.fTreeViewer = new TreeViewer(parent, 2820);
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            Tree tree = this.fTreeViewer.getTree();
            Dialog.applyDialogFont((Control)tree);
            gd.heightHint = tree.getItemHeight() * 12;
            tree.setLayoutData((Object)gd);
            this.fTreeViewer.setContentProvider((IContentProvider)new ChangeTypeContentProvider((ChangeTypeRefactoring)this.getRefactoring()));
            this.fLabelProvider = new ChangeTypeLabelProvider();
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            ISelectionChangedListener listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ChangeTypeInputPage.this.typeSelected((ITypeBinding)selection.getFirstElement());
                }
            };
            this.fTreeViewer.addSelectionChangedListener(listener);
            this.fTreeViewer.setInput((Object)new ChangeTypeContentProvider.RootType(this.getGeneralizeTypeRefactoring().getOriginalType()));
            this.fTreeViewer.expandToLevel(10);
        }

        private void typeSelected(ITypeBinding type) {
            boolean isValid = this.getGeneralizeTypeRefactoring().getValidTypes().contains(type);
            this.setPageComplete(isValid);
            if (isValid) {
                this.setMessage("");
            } else if (this.getGeneralizeTypeRefactoring().getOriginalType().equals((Object)type)) {
                this.setMessage(Messages.format(RefactoringMessages.ChangeTypeWizard_with_itself, BasicElementLabels.getJavaElementName((String)type.getName())));
            } else {
                this.setMessage(Messages.format(RefactoringMessages.ChangeTypeWizard_grayed_types, new Object[]{BasicElementLabels.getJavaElementName((String)type.getName()), BasicElementLabels.getJavaElementName((String)this.getGeneralizeTypeRefactoring().getOriginalType().getName())}));
            }
        }

        private ChangeTypeRefactoring getGeneralizeTypeRefactoring() {
            return (ChangeTypeRefactoring)this.getRefactoring();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private ITypeBinding getSelectedType() {
            IStructuredSelection ss = (IStructuredSelection)this.fTreeViewer.getSelection();
            return (ITypeBinding)ss.getFirstElement();
        }

        public boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        private void initializeRefactoring() {
            this.getGeneralizeTypeRefactoring().setSelectedType(this.getSelectedType());
        }

        public void dispose() {
            this.fTreeViewer = null;
            super.dispose();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.fTreeViewer != null) {
                this.fTreeViewer.getTree().setFocus();
            }
            if (!this.fTreeUpdated) {
                this.fTreeViewer.getTree().getDisplay().asyncExec((Runnable)new ValidTypesTask());
                this.fTreeUpdated = true;
            }
        }

        private class ValidTypesTask
        implements Runnable {
            private Collection<ITypeBinding> fInvalidTypes;
            private Collection<ITypeBinding> fValidTypes;

            private ValidTypesTask() {
            }

            @Override
            public void run() {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) {
                        pm.beginTask(RefactoringMessages.ChangeTypeWizard_analyzing, 1000);
                        ChangeTypeRefactoring ct = (ChangeTypeRefactoring)ChangeTypeWizard.this.getRefactoring();
                        ValidTypesTask.this.fInvalidTypes = new HashSet();
                        ValidTypesTask.this.fInvalidTypes.addAll(ChangeTypeWizard.this.fCT.getAllSuperTypes(ct.getOriginalType()));
                        ValidTypesTask.this.fValidTypes = ct.computeValidTypes((IProgressMonitor)new SubProgressMonitor(pm, 950));
                        ValidTypesTask.this.fInvalidTypes.add(ct.getOriginalType());
                        ValidTypesTask.this.fInvalidTypes.removeAll(ValidTypesTask.this.fValidTypes);
                        pm.worked(50);
                        pm.done();
                    }
                };
                boolean internalError = false;
                try {
                    ChangeTypeInputPage.this.getWizard().getContainer().run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    internalError = true;
                    JavaPlugin.log(e);
                    ChangeTypeInputPage.this.setErrorMessage(RefactoringMessages.ChangeTypeWizard_internalError);
                }
                catch (InterruptedException interruptedException) {
                    ChangeTypeInputPage.this.setMessage(RefactoringMessages.ChangeTypeWizard_computationInterrupted);
                }
                ChangeTypeInputPage.this.fLabelProvider.grayOut(this.fInvalidTypes);
                if (internalError) {
                    ChangeTypeInputPage.this.setPageComplete(false);
                } else if (this.fValidTypes == null || this.fValidTypes.size() == 0) {
                    ChangeTypeInputPage.this.setErrorMessage(RefactoringMessages.ChangeTypeWizard_declCannotBeChanged);
                    ChangeTypeInputPage.this.setPageComplete(false);
                } else {
                    TreeItem selection = ChangeTypeInputPage.this.getInitialSelection(this.fValidTypes);
                    ChangeTypeInputPage.this.fTreeViewer.getTree().setSelection(new TreeItem[]{selection});
                    ChangeTypeInputPage.this.setPageComplete(true);
                    ChangeTypeInputPage.this.setMessage("");
                }
            }
        }
    }

    private class ChangeTypeLabelProvider
    extends BindingLabelProvider
    implements IColorProvider {
        private Color fGrayColor = Display.getCurrent().getSystemColor(18);
        private HashMap<Image, Image> fGrayImages = new HashMap();
        private Collection<ITypeBinding> fInvalidTypes;

        public void grayOut(Collection<ITypeBinding> invalidTypes) {
            this.fInvalidTypes = invalidTypes;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        public Color getForeground(Object element) {
            if (this.isInvalid(element)) {
                return this.fGrayColor;
            }
            return null;
        }

        private boolean isInvalid(Object element) {
            if (this.fInvalidTypes == null) {
                return false;
            }
            return this.fInvalidTypes.contains(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        @Override
        public Image getImage(Object element) {
            Image image = super.getImage(element);
            if (this.isInvalid(element) && image != null) {
                Image grayImage = this.fGrayImages.get(image);
                if (grayImage == null) {
                    grayImage = new Image((Device)Display.getCurrent(), image, 2);
                    this.fGrayImages.put(image, grayImage);
                }
                return grayImage;
            }
            return image;
        }

        public void dispose() {
            for (Image image : this.fGrayImages.values()) {
                image.dispose();
            }
            this.fGrayImages.clear();
            super.dispose();
        }
    }
}

