/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.ApiAccess;
import org.eclipse.pde.api.tools.internal.ApiAnnotations;
import org.eclipse.pde.api.tools.internal.descriptors.NamedElementDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAccess;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiDescription
implements IApiDescription {
    protected static final int VISIBILITY_INHERITED = 0;
    protected String fOwningComponentId = null;
    private boolean fModified = false;
    static NodeComparator fgComparator = new NodeComparator();
    protected HashMap<IElementDescriptor, ManifestNode> fPackageMap = new HashMap();
    protected HashMap<IPackageDescriptor, HashMap<IElementDescriptor, IApiAccess>> fAccessMap = new HashMap();
    private float fEmbeddedVersion = 0.0f;

    public ApiDescription(String owningComponentId) {
        this.fOwningComponentId = owningComponentId;
    }

    @Override
    public void accept(ApiDescriptionVisitor visitor, IProgressMonitor monitor) {
        this.visitChildren(visitor, this.fPackageMap, monitor);
    }

    protected void visitChildren(ApiDescriptionVisitor visitor, Map<IElementDescriptor, ManifestNode> childrenMap, IProgressMonitor monitor) {
        ArrayList<IElementDescriptor> elements = new ArrayList<IElementDescriptor>(childrenMap.keySet());
        Collections.sort(elements, fgComparator);
        Iterator iterator = elements.iterator();
        SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)elements.size());
        while (iterator.hasNext()) {
            loopMonitor.split(1);
            IElementDescriptor element = (IElementDescriptor)iterator.next();
            ManifestNode node = childrenMap.get(element);
            this.visitNode(visitor, node);
        }
    }

    @Override
    public boolean accept(ApiDescriptionVisitor visitor, IElementDescriptor element, IProgressMonitor monitor) {
        ManifestNode node = this.findNode(element, false);
        if (node != null) {
            this.visitNode(visitor, node);
            return true;
        }
        return false;
    }

    public int compareEmbeddedVersionTo(String version) {
        float lversion = Float.parseFloat(version);
        if (this.fEmbeddedVersion < lversion) {
            return 1;
        }
        if (this.fEmbeddedVersion == lversion) {
            return 0;
        }
        return -1;
    }

    public void setEmbeddedVersion(String version) {
        try {
            this.fEmbeddedVersion = Float.parseFloat(version);
        }
        catch (NumberFormatException numberFormatException) {
            this.fEmbeddedVersion = Float.parseFloat("1.2");
        }
    }

    private void visitNode(ApiDescriptionVisitor visitor, ManifestNode node) {
        int vis = node.visibility;
        ManifestNode tmp = node;
        while (tmp != null) {
            vis = tmp.visibility;
            tmp = tmp.visibility == 0 ? tmp.parent : null;
        }
        ApiAnnotations desc = new ApiAnnotations(vis, node.restrictions);
        boolean visitChildren = visitor.visitElement(node.element, desc);
        if (visitChildren && !node.children.isEmpty()) {
            this.visitChildren(visitor, node.children, null);
        }
        visitor.endVisitElement(node.element, desc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ManifestNode findNode(IElementDescriptor element, boolean write) {
        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Looking up manifest node for element: ");
            buffer.append(element);
            System.out.println(buffer.toString());
        }
        IElementDescriptor[] path = element.getPath();
        HashMap<IElementDescriptor, ManifestNode> map = this.fPackageMap;
        ManifestNode parentNode = null;
        ManifestNode node = null;
        IElementDescriptor[] iElementDescriptorArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDescriptor current = iElementDescriptorArray[n2];
            parentNode = node;
            node = (ManifestNode)map.get(current);
            if (node == null) {
                if (write || this.isInsertOnResolve(current)) {
                    node = this.createNode(parentNode, current);
                    if (node == null) return null;
                    map.put(current, node);
                } else {
                    if (!ApiPlugin.DEBUG_API_DESCRIPTION) return parentNode;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Returning parent manifest node: ");
                    buffer.append(parentNode);
                    buffer.append(" when looking for element");
                    buffer.append(element);
                    System.out.println(buffer.toString());
                    return parentNode;
                }
            }
            if ((node = node.refresh()) != null) {
                map = node.children;
            }
            ++n2;
        }
        if (!ApiPlugin.DEBUG_API_DESCRIPTION) return node;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Manifest node found: ");
        buffer.append(node);
        buffer.append(" when looking for element");
        buffer.append(element);
        System.out.println(buffer.toString());
        return node;
    }

    @Override
    public IApiAnnotations resolveAnnotations(IElementDescriptor element) {
        ManifestNode node = this.findNode(element, false);
        if (node != null) {
            return this.resolveAnnotations(node, element);
        }
        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Tried to resolve annotations for manifest node: ");
            buffer.append(node);
            buffer.append(" but the node could not be found.");
            System.out.println(buffer.toString());
        }
        return null;
    }

    protected int resolveVisibility(ManifestNode node) {
        ManifestNode visNode = node;
        int vis = visNode.visibility;
        while (vis == 0) {
            visNode = visNode.parent;
            vis = visNode.visibility;
        }
        return vis;
    }

    protected IApiAnnotations resolveAnnotations(ManifestNode node, IElementDescriptor element) {
        int vis = this.resolveVisibility(node);
        int res = 0;
        if (node.element.equals(element)) {
            res = node.restrictions;
        }
        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Resolved annotations for manifest node: ");
            stringBuffer.append(node);
            stringBuffer.append(" to be: ");
            stringBuffer.append(VisibilityModifiers.getVisibilityName(vis));
            stringBuffer.append(" ");
            stringBuffer.append(RestrictionModifiers.getRestrictionText(res));
            System.out.println(stringBuffer.toString());
        }
        return new ApiAnnotations(vis, res);
    }

    protected void clearPackages() {
        if (this.fPackageMap != null) {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                System.out.println("Clearing package map");
            }
            this.fPackageMap.clear();
        }
    }

    protected ManifestNode createNode(ManifestNode parentNode, IElementDescriptor element) {
        int vis = 0;
        if (element.getElementType() == 1) {
            vis = 1;
        }
        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Creating new manifest node for element: ");
            buffer.append(element);
            buffer.append(" and adding it to parent node: ");
            buffer.append(parentNode);
            System.out.println(buffer.toString());
        }
        return new ManifestNode(parentNode, element, vis, 0);
    }

    @Override
    public IStatus setRestrictions(IElementDescriptor element, int restrictions) {
        ManifestNode node = this.findNode(element, true);
        if (node != null) {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Setting restrictions for manifest node: ");
                buffer.append(node);
                buffer.append(" to be ");
                buffer.append(RestrictionModifiers.getRestrictionText(restrictions));
                System.out.println(buffer.toString());
            }
            this.modified();
            node.restrictions = restrictions;
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.pde.api.tools", 100, MessageFormat.format((String)"Failed to set API restriction: {0} not found in {1}", (Object[])new Object[]{element.toString(), this.fOwningComponentId}), null);
    }

    @Override
    public IStatus setVisibility(IElementDescriptor element, int visibility) {
        ManifestNode node = this.findNode(element, true);
        if (node != null) {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Setting visibility for manifest node: ");
                buffer.append(node);
                buffer.append(" to be ");
                buffer.append(VisibilityModifiers.getVisibilityName(visibility));
                System.out.println(buffer.toString());
            }
            this.modified();
            node.visibility = visibility;
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.pde.api.tools", 100, MessageFormat.format((String)"Failed to set API visibility: {0} not found in {1}", (Object[])new Object[]{element.toString(), this.fOwningComponentId}), null);
    }

    @Override
    public IStatus setAddedProfile(IElementDescriptor element, int addedProfile) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setRemovedProfile(IElementDescriptor element, int removedProfile) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setSuperclass(IElementDescriptor element, String superclass) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setSuperinterfaces(IElementDescriptor element, String superinterfaces) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setInterface(IElementDescriptor element, boolean interfaceFlag) {
        return Status.OK_STATUS;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("API description for component: ").append(this.fOwningComponentId);
        return buffer.toString();
    }

    protected boolean isInsertOnResolve(IElementDescriptor elementDescriptor) {
        return false;
    }

    protected synchronized void modified() {
        this.fModified = true;
    }

    protected synchronized boolean isModified() {
        return this.fModified;
    }

    protected synchronized void setModified(boolean mod) {
        this.fModified = mod;
    }

    @Override
    public IApiAccess resolveAccessLevel(IElementDescriptor element, IPackageDescriptor pelement) {
        HashMap<IElementDescriptor, IApiAccess> map;
        if (this.fAccessMap != null && (map = this.fAccessMap.get(pelement)) != null) {
            return map.get(element);
        }
        return null;
    }

    @Override
    public void setAccessLevel(IElementDescriptor element, IPackageDescriptor pelement, int access) {
        if (element != null && pelement != null && access != 0) {
            HashMap<IElementDescriptor, IApiAccess> map;
            if (this.fAccessMap == null) {
                this.fAccessMap = new HashMap();
            }
            if ((map = this.fAccessMap.get(pelement)) == null) {
                map = new HashMap();
                this.fAccessMap.put(pelement, map);
            }
            map.put(element, new ApiAccess(access));
        }
    }

    class ManifestNode {
        protected IElementDescriptor element = null;
        protected int visibility;
        protected int restrictions;
        protected ManifestNode parent = null;
        protected HashMap<IElementDescriptor, ManifestNode> children = new HashMap(1);

        public ManifestNode(ManifestNode parent, IElementDescriptor element, int visibility, int restrictions) {
            this.element = element;
            this.visibility = visibility;
            this.restrictions = restrictions;
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ManifestNode) {
                return ((ManifestNode)obj).element.equals(this.element);
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public String toString() {
            String type = null;
            String name = null;
            switch (this.element.getElementType()) {
                case 5: {
                    type = "Field";
                    name = ((IMemberDescriptor)this.element).getName();
                    break;
                }
                case 6: {
                    type = "Method";
                    name = ((IMemberDescriptor)this.element).getName();
                    break;
                }
                case 1: {
                    type = "Package";
                    name = ((IPackageDescriptor)this.element).getName();
                    break;
                }
                case 2: {
                    type = "Type";
                    name = ((IMemberDescriptor)this.element).getName();
                    break;
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(type == null ? "Unknown" : type).append(" Node: ").append(name == null ? "Unknown Name" : name);
            buffer.append("\nVisibility: ").append(VisibilityModifiers.getVisibilityName(this.visibility));
            buffer.append("\nRestrictions: ").append(RestrictionModifiers.getRestrictionText(this.restrictions));
            if (this.parent != null) {
                String pname = this.parent.element.getElementType() == 1 ? ((IPackageDescriptor)this.parent.element).getName() : ((IMemberDescriptor)this.parent.element).getName();
                buffer.append("\nParent: ").append(pname);
            }
            return buffer.toString();
        }

        protected boolean hasApiVisibility(ManifestNode node) {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                System.out.println("Checking node for API visibility:" + node);
            }
            if (node != null) {
                if (VisibilityModifiers.isAPI(node.visibility)) {
                    return true;
                }
                if (node.visibility == 0) {
                    return this.hasApiVisibility(node.parent);
                }
            }
            return false;
        }

        protected ManifestNode refresh() {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                System.out.println("Refreshing manifest node: " + this);
            }
            return this;
        }

        void persistXML(Document document, Element parentElement) {
            if (RestrictionModifiers.isUnrestricted(this.restrictions)) {
                return;
            }
            switch (this.element.getElementType()) {
                case 6: {
                    IMethodDescriptor md = (IMethodDescriptor)this.element;
                    Element method = document.createElement("method");
                    method.setAttribute("name", md.getName());
                    method.setAttribute("signature", md.getSignature());
                    this.persistAnnotations(method);
                    parentElement.appendChild(method);
                    break;
                }
                case 5: {
                    IFieldDescriptor fd = (IFieldDescriptor)this.element;
                    Element field = document.createElement("field");
                    field.setAttribute("name", fd.getName());
                    this.persistAnnotations(field);
                    parentElement.appendChild(field);
                    break;
                }
            }
        }

        void persistAnnotations(Element xmlElement) {
            xmlElement.setAttribute("visibility", Integer.toString(this.visibility));
            xmlElement.setAttribute("restrictions", Integer.toString(this.restrictions));
        }
    }

    static class NodeComparator
    implements Comparator<IElementDescriptor> {
        NodeComparator() {
        }

        @Override
        public int compare(IElementDescriptor o1, IElementDescriptor o2) {
            String s2;
            String s1 = o1 instanceof IReferenceTypeDescriptor ? ((IReferenceTypeDescriptor)o1).getQualifiedName() : ((NamedElementDescriptorImpl)o1).getName();
            String string = s2 = o2 instanceof IReferenceTypeDescriptor ? ((IReferenceTypeDescriptor)o2).getQualifiedName() : ((NamedElementDescriptorImpl)o2).getName();
            if (s1 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }
}

