/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractIllegalTypeReference;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public class IllegalAnnotationReferenceDetector
extends AbstractIllegalTypeReference {
    @Override
    public int getReferenceKinds() {
        return 0x40000000;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        return 14;
    }

    @Override
    protected int getProblemKind() {
        return 3;
    }

    @Override
    protected String getSeverityKey() {
        return "ILLEGAL_REFERENCE";
    }

    @Override
    public boolean considerReference(IReference reference) {
        return super.considerReference(reference);
    }

    @Override
    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        IAnnotatable annotable;
        IApiMember member = reference.getMember();
        if (member != null && (annotable = this.findAnnotableElement(type, member, reference, doc)) != null) {
            IAnnotation[] annotations = annotable.getAnnotations();
            String typename = Signatures.getSimpleTypeName(reference.getResolvedReference().getName());
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals(typename)) {
                    ISourceRange range = annotation.getNameRange();
                    if (range == null) break;
                    return new Position(range.getOffset() - 1, range.getLength() + 1);
                }
                ++n2;
            }
        }
        return this.defaultSourcePosition(type, reference);
    }

    IAnnotatable findAnnotableElement(IType type, IApiMember member, IReference reference, IDocument doc) throws CoreException {
        switch (member.getType()) {
            case 2: {
                return this.findTypeInType(type, (IApiType)member, reference, doc);
            }
            case 5: {
                return this.findFieldInType(type, (IApiField)member);
            }
            case 6: {
                return this.findMethodInType(type, (IApiMethod)member);
            }
        }
        return null;
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        return new String[]{this.getSimpleTypeName(reference.getResolvedReference())};
    }
}

