/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexContribution;
import org.eclipse.help.internal.index.IndexDocumentReader;
import org.eclipse.help.internal.index.IndexFile;
import org.xml.sax.SAXException;

public class IndexFileParser {
    private DocumentReader reader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexContribution parse(IndexFile indexFile) throws IOException, SAXException, ParserConfigurationException {
        if (this.reader == null) {
            this.reader = new IndexDocumentReader();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            IndexContribution contrib;
            InputStream in = indexFile.getInputStream();
            try {
                if (in == null) throw new FileNotFoundException();
                Index index = (Index)this.reader.read(in);
                contrib = new IndexContribution();
                contrib.setId(String.valueOf('/') + indexFile.getPluginId() + '/' + indexFile.getFile());
                contrib.setIndex(index);
                contrib.setLocale(indexFile.getLocale());
                return contrib;
            }
            finally {
                if (in == null) return contrib;
                in.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

