/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class ReflogViewContentProvider
implements ITreeContentProvider {
    private DeferredTreeContentManager loader;
    private Object currentInput;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null && this.loader != null) {
            this.loader.cancel(oldInput);
        }
        this.currentInput = newInput;
        if (viewer instanceof AbstractTreeViewer && newInput != null) {
            this.loader = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        }
    }

    public void dispose() {
        if (this.currentInput != null && this.loader != null) {
            this.loader.cancel(this.currentInput);
        }
        this.currentInput = null;
        this.loader = null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ReflogInput && this.loader != null) {
            return this.loader.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    private static class ErrorElement
    extends WorkbenchAdapter {
        private ErrorElement() {
        }

        public String getLabel(Object object) {
            return UIText.ReflogView_ErrorOnLoad;
        }
    }

    public static class ReflogInput
    extends WorkbenchAdapter
    implements IDeferredWorkbenchAdapter {
        private final Repository repository;
        private final String ref;
        private Collection<ReflogEntry> refLog;

        public ReflogInput(Repository repository, String ref) {
            Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
            Assert.isNotNull((Object)ref, (String)"Ref cannot be null");
            this.repository = repository;
            this.ref = ref;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public Object[] getChildren(Object o) {
            if (this.refLog != null) {
                return this.refLog.toArray();
            }
            return super.getChildren(o);
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Git git = new Git(this.repository);){
                    this.refLog = git.reflog().setRef(this.ref).call();
                    collector.add(this.refLog.toArray(), monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.logError("Error running reflog command", e);
                collector.add((Object)new ErrorElement(), monitor);
            }
        }

        public boolean isContainer() {
            return true;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }
    }
}

