/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class ProgressViewerContentProvider
extends ProgressContentProvider {
    protected AbstractProgressViewer progressViewer;
    private FinishedJobs.KeptJobsListener keptJobListener;
    private boolean showFinished;

    public ProgressViewerContentProvider(AbstractProgressViewer structured, boolean debug, boolean showFinished) {
        super(debug);
        this.progressViewer = structured;
        this.showFinished = showFinished;
        if (showFinished) {
            FinishedJobs.getInstance().addListener(this.getKeptJobListener());
        }
    }

    private FinishedJobs.KeptJobsListener getKeptJobListener() {
        this.keptJobListener = new FinishedJobs.KeptJobsListener(){

            @Override
            public void finished(JobTreeElement jte) {
                final JobTreeElement element = jte;
                WorkbenchJob updateJob = new WorkbenchJob("Refresh finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ProgressViewerContentProvider.this.refresh(new Object[]{element});
                        return Status.OK_STATUS;
                    }

                    @Override
                    public boolean shouldSchedule() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }

                    @Override
                    public boolean shouldRun() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }

            @Override
            public void removed(JobTreeElement jte) {
                final JobTreeElement element = jte;
                WorkbenchJob updateJob = new WorkbenchJob("Remove finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (element == null) {
                            ProgressViewerContentProvider.this.refresh();
                        } else {
                            ProgressViewerContentProvider.this.remove(new Object[]{element});
                        }
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }
        };
        return this.keptJobListener;
    }

    @Override
    public void refresh() {
        this.progressViewer.refresh(true);
    }

    @Override
    public void refresh(Object[] elements) {
        Object[] objectArray = this.getRoots(elements, true);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object refresh = objectArray[n2];
            this.progressViewer.refresh(refresh, true);
            ++n2;
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        if (!this.showFinished) {
            return elements;
        }
        Set kept = FinishedJobs.getInstance().getKeptAsSet();
        if (kept.size() == 0) {
            return elements;
        }
        HashSet<Object> all = new HashSet<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            all.add(element);
            ++n2;
        }
        for (JobTreeElement next : kept) {
            if (next.getParent() != null && all.contains(next.getParent())) continue;
            all.add(next);
        }
        return all.toArray();
    }

    private Object[] getRoots(Object[] elements, boolean subWithParent) {
        if (elements.length == 0) {
            return elements;
        }
        HashSet<JobTreeElement> roots = new HashSet<JobTreeElement>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            JobTreeElement jobTreeElement = (JobTreeElement)element;
            if (jobTreeElement.isJobInfo()) {
                GroupInfo group = ((JobInfo)jobTreeElement).getGroupInfo();
                if (group == null) {
                    roots.add(jobTreeElement);
                } else if (subWithParent) {
                    roots.add(group);
                }
            } else {
                roots.add(jobTreeElement);
            }
            ++n2;
        }
        return roots.toArray();
    }

    @Override
    public void add(Object[] elements) {
        this.progressViewer.add(elements);
    }

    @Override
    public void remove(Object[] elements) {
        this.progressViewer.remove(elements);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.keptJobListener != null) {
            FinishedJobs.getInstance().removeListener(this.keptJobListener);
        }
    }
}

