/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.impl.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.GetComboItems;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;

public class GetComboItemsService
extends AbstractActionService {
    @Override
    protected Object exec(Command command) throws CoreException {
        GetComboItems gci = (GetComboItems)command;
        ControlHandler control = gci.getControl();
        Element element = TeslaBridge.find(control, this.getContext());
        final Widget combo = ((SWTUIElement)((SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class)).getMapper().get((Element)element)).widget;
        if (!(combo instanceof Combo) && !(combo instanceof CCombo)) {
            throw new CoreException(TeslaImplPlugin.err("'get-combo-items' can be used only on combo box"));
        }
        final LinkedList list = new LinkedList();
        combo.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GetComboItemsService.addComboItemsToList(combo, list);
            }
        });
        for (String item : list) {
            this.getContext().getOutput().write((Object)item);
        }
        return null;
    }

    private static void addComboItemsToList(Widget widget, List<String> list) {
        if (widget instanceof Combo) {
            Combo combo = (Combo)widget;
            GetComboItemsService.addItemsToList(combo.getItems(), list);
        } else if (widget instanceof CCombo) {
            CCombo combo = (CCombo)widget;
            GetComboItemsService.addItemsToList(combo.getItems(), list);
        }
    }

    private static void addItemsToList(String[] items, List<String> list) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            list.add(items[i]);
            ++i;
        }
    }
}

