/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.UnimplementedCodeFix;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;

public class UnimplementedCodeCleanUp
extends AbstractMultiFix {
    public static final String MAKE_TYPE_ABSTRACT = "cleanup.make_type_abstract_if_missing_method";

    public UnimplementedCodeCleanUp() {
    }

    public UnimplementedCodeCleanUp(Map<String, String> settings) {
        super(settings);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.add_missing_methods")) {
            return new String[]{MultiFixMessages.UnimplementedCodeCleanUp_AddUnimplementedMethods_description};
        }
        if (this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            return new String[]{MultiFixMessages.UnimplementedCodeCleanUp_MakeAbstract_description};
        }
        return null;
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            buf.append("public abstract class Face implements IFace {\n");
        } else {
            buf.append("public class Face implements IFace {\n");
        }
        if (this.isEnabled("cleanup.add_missing_methods")) {
            boolean createComments = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.javadoc", null));
            if (createComments) {
                buf.append(this.indent(this.getOverridingMethodComment(), "    "));
            }
            buf.append("    @Override\n");
            buf.append("    public void method() {\n");
            buf.append(this.indent(this.getMethodBody(), "        "));
            buf.append("    }\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public CleanUpRequirements getRequirements() {
        if (!this.isEnabled("cleanup.add_missing_methods") && !this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            return super.getRequirements();
        }
        return new CleanUpRequirements(true, false, false, null);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        IProblemLocation[] problemLocations = UnimplementedCodeCleanUp.convertProblems(unit.getProblems());
        problemLocations = UnimplementedCodeCleanUp.filter(problemLocations, new int[]{67109264, 67109627});
        return UnimplementedCodeFix.createCleanUp(unit, this.isEnabled("cleanup.add_missing_methods"), this.isEnabled(MAKE_TYPE_ABSTRACT), problemLocations);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        IProblemLocation[] problemLocations = UnimplementedCodeCleanUp.filter(problems, new int[]{67109264, 67109627});
        return UnimplementedCodeFix.createCleanUp(unit, this.isEnabled("cleanup.add_missing_methods"), this.isEnabled(MAKE_TYPE_ABSTRACT), problemLocations);
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        if (id == 67109264 || id == 67109627) {
            return this.isEnabled("cleanup.add_missing_methods") || this.isEnabled(MAKE_TYPE_ABSTRACT);
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        if (!this.isEnabled("cleanup.add_missing_methods") && !this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            return 0;
        }
        IProblemLocation[] locations = UnimplementedCodeCleanUp.filter(UnimplementedCodeCleanUp.convertProblems(compilationUnit.getProblems()), new int[]{67109264, 67109627});
        HashSet<ASTNode> types = new HashSet<ASTNode>();
        int i = 0;
        while (i < locations.length) {
            ASTNode type = UnimplementedCodeFix.getSelectedTypeNode(compilationUnit, locations[i]);
            if (type != null) {
                types.add(type);
            }
            ++i;
        }
        return types.size();
    }

    private String getOverridingMethodComment() {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
        Template template = UnimplementedCodeCleanUp.getCodeTemplate(templateName);
        if (template == null) {
            return "";
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), null, "\n");
        context.setVariable("file_name", "Face.java");
        context.setVariable("package_name", "test");
        context.setVariable("project_name", "TestProject");
        context.setVariable("enclosing_type", "Face");
        context.setVariable("enclosing_method", "method");
        context.setVariable("return_type", "void");
        context.setVariable("see_to_overridden", "test.IFace#foo()");
        return this.evaluateTemplate(template, context);
    }

    private String getMethodBody() {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.methodbody";
        Template template = UnimplementedCodeCleanUp.getCodeTemplate(templateName);
        if (template == null) {
            return "";
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), null, "\n");
        context.setVariable("enclosing_method", "method");
        context.setVariable("enclosing_type", "Face");
        context.setVariable("body_statement", "");
        return this.evaluateTemplate(template, context);
    }

    private static Template getCodeTemplate(String id) {
        return JavaPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
    }

    private String evaluateTemplate(Template template, CodeTemplateContext context) {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            return "";
        }
        catch (TemplateException e) {
            JavaPlugin.log(e);
            return "";
        }
        if (buffer == null) {
            return "";
        }
        return buffer.getString();
    }

    private String indent(String code, String indent) {
        if (code.length() == 0) {
            return code;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(indent);
        char[] codeArray = code.toCharArray();
        int i = 0;
        while (i < codeArray.length) {
            buf.append(codeArray[i]);
            if (codeArray[i] == '\n') {
                buf.append(indent);
            }
            ++i;
        }
        buf.append("\n");
        return buf.toString();
    }
}

