/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.WizardActionGroup;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardRegistry;

public class NewActionProvider
extends CommonActionProvider {
    private static final String FULL_EXAMPLES_WIZARD_CATEGORY = "org.eclipse.ui.Examples";
    private static final String NEW_MENU_NAME = "common.new.menu";
    private ActionFactory.IWorkbenchAction showDlgAction;
    private IAction newProjectAction;
    private IAction newExampleAction;
    private WizardActionGroup newWizardActionGroup;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite anExtensionSite) {
        if (anExtensionSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            IWorkbenchWindow window = ((ICommonViewerWorkbenchSite)anExtensionSite.getViewSite()).getWorkbenchWindow();
            this.showDlgAction = ActionFactory.NEW.create(window);
            this.newProjectAction = new NewProjectAction(window);
            this.newExampleAction = new NewExampleAction(window);
            this.newWizardActionGroup = new WizardActionGroup(window, PlatformUI.getWorkbench().getNewWizardRegistry(), "new", anExtensionSite.getContentService());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.NewActionProvider_NewMenu_label, NEW_MENU_NAME);
        if (!this.contribute) {
            return;
        }
        submenu.add(this.newProjectAction);
        submenu.add((IContributionItem)new Separator());
        this.newWizardActionGroup.setContext(this.getContext());
        this.newWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        if (this.hasExamples()) {
            submenu.add((IContributionItem)new Separator());
            submenu.add(this.newExampleAction);
        }
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.showDlgAction);
        menu.insertAfter("group.new", (IContributionItem)submenu);
    }

    private boolean hasExamples() {
        IWizardRegistry newRegistry = PlatformUI.getWorkbench().getNewWizardRegistry();
        IWizardCategory category = newRegistry.findCategory(FULL_EXAMPLES_WIZARD_CATEGORY);
        return category != null;
    }

    public void dispose() {
        if (this.showDlgAction != null) {
            this.showDlgAction.dispose();
            this.showDlgAction = null;
        }
        super.dispose();
    }
}

