/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class InstallableUnitProposal
implements ICompletionProposal {
    private static final String REPLACE_STRING = " (replace)";
    private String completionString;
    private int offset;
    private int length;
    private boolean replace;

    public InstallableUnitProposal(String completionString, int offset, int length, boolean replace) {
        this.completionString = completionString;
        this.offset = offset;
        this.length = length;
        this.replace = replace;
    }

    public void apply(IDocument document) {
        String toReplace = this.completionString.substring(this.length);
        try {
            if (this.replace) {
                int indexOf = document.get().indexOf(34, this.offset);
                document.replace(this.offset, indexOf - this.offset, "");
                document.replace(this.offset, 0, toReplace);
            } else {
                document.replace(this.offset, 0, toReplace);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset + this.completionString.length() - this.length, 0);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.replace ? this.completionString.concat(REPLACE_STRING) : this.completionString;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

