/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class AddNewDependenciesOperation
extends WorkspaceModifyOperation {
    protected IProject fProject;
    protected IBundlePluginModelBase fBase;
    private boolean fNewDependencies = false;

    public AddNewDependenciesOperation(IProject project, IBundlePluginModelBase base) {
        this.fProject = project;
        this.fBase = base;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        HashSet<String> ignorePkgs;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.AddNewDependenciesOperation_mainTask, (int)100);
        IBundle bundle = this.fBase.getBundleModel().getBundle();
        String[] secDeps = this.findSecondaryBundles(bundle, ignorePkgs = new HashSet<String>());
        if (secDeps == null || secDeps.length == 0) {
            return;
        }
        subMonitor.worked(4);
        this.findImportPackages(bundle, ignorePkgs);
        subMonitor.worked(2);
        this.addProjectPackages(bundle, ignorePkgs);
        subMonitor.worked(4);
        HashMap<ExportPackageDescription, String> additionalDeps = new HashMap<ExportPackageDescription, String>();
        subMonitor.subTask(PDEUIMessages.AddNewDependenciesOperation_searchProject);
        boolean useRequireBundle = new ProjectScope(this.fProject).getNode("org.eclipse.pde.core").getBoolean("resolve.requirebundle", true);
        this.findSecondaryDependencies(secDeps, ignorePkgs, additionalDeps, bundle, useRequireBundle, (IProgressMonitor)subMonitor.split(80));
        this.handleNewDependencies(additionalDeps, useRequireBundle, (IProgressMonitor)subMonitor.split(10));
    }

    public boolean foundNewDependencies() {
        return this.fNewDependencies;
    }

    protected String[] findSecondaryBundles(IBundle bundle, Set<String> ignorePkgs) {
        String[] secDeps = this.getSecondaryDependencies();
        if (secDeps == null) {
            return null;
        }
        Set<String> manifestPlugins = this.findManifestPlugins(bundle, ignorePkgs);
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while (i < secDeps.length) {
            if (!manifestPlugins.contains(secDeps[i])) {
                result.add(secDeps[i]);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getSecondaryDependencies() {
        IBuildEntry be;
        IBuild build = this.getBuild();
        if (build != null && (be = build.getEntry("additional.bundles")) != null) {
            return be.getTokens();
        }
        return null;
    }

    protected final IBuild getBuild() {
        IFile buildProps = PDEProject.getBuildProperties((IProject)this.fProject);
        if (buildProps != null) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildProps);
            return model.getBuild();
        }
        return null;
    }

    private Set<String> findManifestPlugins(IBundle bundle, Set<String> ignorePkgs) {
        Set<String> plugins;
        IManifestHeader header = bundle.getManifestHeader("Require-Bundle");
        if (header == null) {
            return new HashSet<String>(0);
        }
        Set<String> set = plugins = header instanceof RequireBundleHeader ? this.findManifestPlugins((RequireBundleHeader)header, ignorePkgs) : this.findManifestPlugins(ignorePkgs);
        if (plugins.contains("org.eclipse.core.runtime")) {
            plugins.add("system.bundle");
        }
        return plugins;
    }

    private Set<String> findManifestPlugins(RequireBundleHeader header, Set<String> ignorePkgs) {
        RequireBundleObject[] bundles = header.getRequiredBundles();
        HashSet<String> result = new HashSet<String>(1 * bundles.length + 2);
        ArrayList<IPluginBase> plugins = new ArrayList<IPluginBase>();
        RequireBundleObject[] requireBundleObjectArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            RequireBundleObject bundle = requireBundleObjectArray[n2];
            String id = bundle.getId();
            result.add(id);
            IPluginModelBase base = PluginRegistry.findModel((String)id);
            if (base != null) {
                ExportPackageDescription[] exportedPkgs;
                ExportPackageDescription[] exportPackageDescriptionArray = exportedPkgs = this.findExportedPackages(base.getBundleDescription());
                int n3 = exportedPkgs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportedPkg = exportPackageDescriptionArray[n4];
                    ignorePkgs.add(exportedPkg.getName());
                    ++n4;
                }
                plugins.add(base.getPluginBase());
            }
            ++n2;
        }
        return result;
    }

    private Set<String> findManifestPlugins(Set<String> ignorePkgs) {
        BundleSpecification[] bundles = this.fBase.getBundleDescription().getRequiredBundles();
        HashSet<String> result = new HashSet<String>(1 * bundles.length + 2);
        ArrayList<IPluginBase> plugins = new ArrayList<IPluginBase>();
        BundleSpecification[] bundleSpecificationArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification bundle = bundleSpecificationArray[n2];
            String id = bundle.getName();
            result.add(id);
            IPluginModelBase base = PluginRegistry.findModel((String)id);
            if (base != null) {
                ExportPackageDescription[] exportedPkgs;
                ExportPackageDescription[] exportPackageDescriptionArray = exportedPkgs = this.findExportedPackages(base.getBundleDescription());
                int n3 = exportedPkgs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportedPkg = exportPackageDescriptionArray[n4];
                    ignorePkgs.add(exportedPkg.getName());
                    ++n4;
                }
                plugins.add(base.getPluginBase());
            }
            ++n2;
        }
        return result;
    }

    protected final ExportPackageDescription[] findExportedPackages(BundleDescription desc) {
        if (desc != null) {
            IBundle bundle = this.fBase.getBundleModel().getBundle();
            String value = bundle.getHeader("Bundle-SymbolicName");
            int index = value != null ? value.indexOf(59) : -1;
            String projectBundleId = index > 0 ? value.substring(0, index) : value;
            LinkedList<ExportPackageDescription> result = new LinkedList<ExportPackageDescription>();
            Stack<Object> stack = new Stack<Object>();
            stack.add(desc);
            while (!stack.isEmpty()) {
                BundleSpecification[] requiredBundles;
                ExportPackageDescription[] expkgs;
                BundleDescription bdesc = (BundleDescription)stack.pop();
                ExportPackageDescription[] exportPackageDescriptionArray = expkgs = bdesc.getExportPackages();
                int n = expkgs.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription expkg = exportPackageDescriptionArray[n2];
                    if (this.addPackage(projectBundleId, expkg)) {
                        result.add(expkg);
                    }
                    ++n2;
                }
                BundleSpecification[] bundleSpecificationArray = requiredBundles = bdesc.getRequiredBundles();
                int n3 = requiredBundles.length;
                n = 0;
                while (n < n3) {
                    BaseDescription bd;
                    BundleSpecification requiredBundle = bundleSpecificationArray[n];
                    if (requiredBundle.isExported() && (bd = requiredBundle.getSupplier()) != null && bd instanceof BundleDescription) {
                        stack.add(bd);
                    }
                    ++n;
                }
            }
            return result.toArray(new ExportPackageDescription[result.size()]);
        }
        return new ExportPackageDescription[0];
    }

    private boolean addPackage(String symbolicName, ExportPackageDescription pkg) {
        if (symbolicName == null) {
            return true;
        }
        String[] friends = (String[])pkg.getDirective("x-friends");
        if (friends != null) {
            String[] stringArray = friends;
            int n = friends.length;
            int n2 = 0;
            while (n2 < n) {
                String friend = stringArray[n2];
                if (symbolicName.equals(friend)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    protected final void findImportPackages(IBundle bundle, Set<String> ignorePkgs) {
        IManifestHeader header = bundle.getManifestHeader("Import-Package");
        if (header == null || header.getValue() == null) {
            return;
        }
        if (header instanceof ImportPackageHeader) {
            ImportPackageObject[] pkgs;
            ImportPackageObject[] importPackageObjectArray = pkgs = ((ImportPackageHeader)header).getPackages();
            int n = pkgs.length;
            int n2 = 0;
            while (n2 < n) {
                ImportPackageObject pkg = importPackageObjectArray[n2];
                ignorePkgs.add(pkg.getName());
                ++n2;
            }
        } else {
            ImportPackageSpecification[] pkgs;
            ImportPackageSpecification[] importPackageSpecificationArray = pkgs = this.fBase.getBundleDescription().getImportPackages();
            int n = pkgs.length;
            int n3 = 0;
            while (n3 < n) {
                ImportPackageSpecification pkg = importPackageSpecificationArray[n3];
                ignorePkgs.add(pkg.getName());
                ++n3;
            }
        }
    }

    protected void findSecondaryDependencies(String[] secDeps, Set<String> ignorePkgs, Map<ExportPackageDescription, String> newDeps, IBundle bundle, boolean useRequireBundle, IProgressMonitor monitor) {
        IJavaProject jProject = JavaCore.create((IProject)this.fProject);
        SearchEngine engine = new SearchEngine();
        if (ignorePkgs == null) {
            ignorePkgs = new HashSet<String>(2);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.AddNewDependenciesOperation_searchProject, (int)secDeps.length);
        String[] stringArray = secDeps;
        int n = secDeps.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId = stringArray[n2];
            try {
                SubMonitor iterationMonitor = subMonitor.split(1);
                if (iterationMonitor.isCanceled()) {
                    return;
                }
                IPluginModelBase base = PluginRegistry.findModel((String)pluginId);
                if (base != null) {
                    ExportPackageDescription[] exported = this.findExportedPackages(base.getBundleDescription());
                    IJavaSearchScope searchScope = PluginJavaSearchUtil.createSeachScope((IJavaProject)jProject);
                    iterationMonitor.beginTask(NLS.bind((String)PDEUIMessages.AddNewDependenciesOperation_searchForDependency, (Object)pluginId), exported.length);
                    int i = 0;
                    while (i < exported.length) {
                        String pkgName = exported[i].getName();
                        if (!ignorePkgs.contains(pkgName)) {
                            ReferenceFinder requestor = new ReferenceFinder();
                            engine.search(SearchPattern.createPattern((String)pkgName, (int)2, (int)2, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, null);
                            if (requestor.foundMatches()) {
                                this.fNewDependencies = true;
                                ignorePkgs.add(pkgName);
                                newDeps.put(exported[i], pluginId);
                                if (useRequireBundle) {
                                    while (i < exported.length) {
                                        ignorePkgs.add(exported[i].getName());
                                        ++i;
                                    }
                                }
                            }
                        }
                        iterationMonitor.worked(1);
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            ++n2;
        }
    }

    protected void addProjectPackages(IBundle bundle, Set<String> ignorePkgs) {
        IBuild build = this.getBuild();
        if (build == null) {
            return;
        }
        IBuildEntry binIncludes = build.getEntry("bin.includes");
        if (binIncludes != null) {
            ManifestElement[] elems;
            String value = bundle.getHeader("Bundle-ClassPath");
            if (value == null) {
                value = ".";
            }
            try {
                elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            }
            catch (BundleException bundleException) {
                return;
            }
            IJavaProject jProject = JavaCore.create((IProject)this.fProject);
            ManifestElement[] manifestElementArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement elem = manifestElementArray[n2];
                String library = elem.getValue();
                if (binIncludes.contains(library)) {
                    IBuildEntry entry = build.getEntry("source." + library);
                    if (entry != null) {
                        String[] resources;
                        String[] stringArray = resources = entry.getTokens();
                        int n3 = resources.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String resource = stringArray[n4];
                            this.addPackagesFromResource(jProject, this.fProject.findMember(resource), ignorePkgs);
                            ++n4;
                        }
                    } else {
                        this.addPackagesFromResource(jProject, this.fProject.findMember(library), ignorePkgs);
                    }
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(library, "/");
                    StringBuffer buffer = new StringBuffer();
                    while (tokenizer.hasMoreTokens()) {
                        buffer.append(tokenizer.nextToken()).append('/');
                        if (!binIncludes.contains(buffer.toString())) continue;
                        this.addPackagesFromResource(jProject, this.fProject.findMember(library), ignorePkgs);
                    }
                }
                ++n2;
            }
        }
    }

    private void addPackagesFromResource(IJavaProject jProject, IResource res, Set<String> ignorePkgs) {
        if (res == null) {
            return;
        }
        try {
            IJavaElement[] children;
            IPackageFragmentRoot root = jProject.getPackageFragmentRoot(res);
            IJavaElement[] iJavaElementArray = children = root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                String pkgName = child.getElementName();
                if (child instanceof IParent && pkgName.length() > 0 && ((IParent)child).hasChildren()) {
                    ignorePkgs.add(child.getElementName());
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void handleNewDependencies(Map<ExportPackageDescription, String> additionalDeps, boolean useRequireBundle, IProgressMonitor monitor) {
        if (!additionalDeps.isEmpty()) {
            this.addDependencies(additionalDeps, useRequireBundle);
        }
    }

    protected void addDependencies(Map<ExportPackageDescription, String> depsToAdd, boolean useRequireBundle) {
        if (useRequireBundle) {
            Collection<String> plugins = depsToAdd.values();
            this.minimizeBundles(plugins);
            IBuild build = this.getBuild();
            IPluginBase pbase = this.fBase.getPluginBase();
            if (pbase == null) {
                this.addRequireBundles(plugins, this.fBase.getBundleModel().getBundle(), build.getEntry("additional.bundles"));
            } else {
                this.addRequireBundles(plugins, pbase, build.getEntry("additional.bundles"));
            }
            try {
                build.write("", new PrintWriter(new FileOutputStream(PDEProject.getBuildProperties((IProject)this.fProject).getFullPath().toFile())));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            Set<ExportPackageDescription> pkgs = depsToAdd.keySet();
            this.addImportPackages(pkgs, this.fBase.getBundleModel().getBundle());
        }
    }

    protected final void addImportPackages(Collection<ExportPackageDescription> depsToAdd, IBundle bundle) {
        Iterator<ExportPackageDescription> it = depsToAdd.iterator();
        IManifestHeader mheader = bundle.getManifestHeader("Import-Package");
        if (mheader == null) {
            bundle.setHeader("Import-Package", "");
            mheader = bundle.getManifestHeader("Import-Package");
        }
        if (mheader instanceof ImportPackageHeader) {
            ImportPackageHeader header = (ImportPackageHeader)mheader;
            String versionAttr = BundlePluginBase.getBundleManifestVersion((IBundle)bundle) < 2 ? "specification-version" : "version";
            while (it.hasNext()) {
                ImportPackageObject obj = new ImportPackageObject((ManifestHeader)header, it.next(), versionAttr);
                header.addPackage((PackageObject)obj);
            }
        } else {
            String currentValue = mheader != null ? mheader.getValue() : null;
            StringBuffer buffer = currentValue == null ? new StringBuffer() : new StringBuffer(currentValue).append(", ");
            while (it.hasNext()) {
                ExportPackageDescription desc = it.next();
                String value = desc.getVersion().equals((Object)Version.emptyVersion) ? desc.getName() : String.valueOf(desc.getName()) + "; version=\"" + desc.getVersion() + "\"";
                buffer.append(value).append(",\n ");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - ",\n ".length());
            }
            bundle.setHeader("Import-Package", buffer.toString());
        }
    }

    protected final void addRequireBundles(Collection<String> depsToAdd, IBundle bundle, IBuildEntry entry) {
        if (bundle == null) {
            return;
        }
        HashSet<String> added = new HashSet<String>();
        Iterator<String> it = depsToAdd.iterator();
        IManifestHeader mheader = bundle.getManifestHeader("Require-Bundle");
        if (mheader instanceof RequireBundleHeader) {
            RequireBundleHeader header = (RequireBundleHeader)mheader;
            while (it.hasNext()) {
                String pluginId = it.next();
                if (added.contains(pluginId)) continue;
                try {
                    header.addBundle(pluginId);
                    added.add(pluginId);
                    entry.removeToken(pluginId);
                }
                catch (CoreException coreException) {}
            }
        } else {
            String currentValue = mheader != null ? mheader.getValue() : null;
            StringBuffer buffer = currentValue == null ? new StringBuffer() : new StringBuffer(currentValue).append(", ");
            while (it.hasNext()) {
                String pluginId = it.next();
                if (added.contains(pluginId)) continue;
                try {
                    buffer.append(pluginId).append(",\n ");
                    added.add(pluginId);
                    entry.removeToken(pluginId);
                }
                catch (CoreException coreException) {}
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - ",\n ".length());
            }
            bundle.setHeader("Require-Bundle", buffer.toString());
        }
    }

    protected final void addRequireBundles(Collection<String> depsToAdd, IPluginBase base, IBuildEntry entry) {
        HashSet<String> added = new HashSet<String>();
        Iterator<String> it = depsToAdd.iterator();
        base.getImports();
        while (it.hasNext()) {
            String pluginId = it.next();
            if (added.contains(pluginId)) continue;
            try {
                PluginImport plugin = new PluginImport();
                ManifestElement element = ManifestElement.parseHeader((String)"Require-Bundle", (String)pluginId)[0];
                plugin.load(element, 1);
                plugin.setModel(base.getModel());
                base.add((IPluginImport)plugin);
                added.add(pluginId);
                if (entry == null || !entry.contains(pluginId)) continue;
                entry.removeToken(pluginId);
            }
            catch (BundleException bundleException) {
            }
            catch (CoreException coreException) {}
        }
    }

    protected final void minimizeBundles(Collection<String> pluginIds) {
        Stack<String> stack = new Stack<String>();
        Iterator<String> it = pluginIds.iterator();
        while (it.hasNext()) {
            stack.push(it.next().toString());
        }
        while (!stack.isEmpty()) {
            IPluginImport[] imports;
            IPluginModelBase base = PluginRegistry.findModel((String)((String)stack.pop()).toString());
            if (base == null) continue;
            IPluginImport[] iPluginImportArray = imports = base.getPluginBase().getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport pluginImport = iPluginImportArray[n2];
                if (pluginImport.isReexported()) {
                    String reExportedId = pluginImport.getId();
                    pluginIds.remove(pluginImport.getId());
                    stack.push(reExportedId);
                }
                ++n2;
            }
        }
    }

    protected static class ReferenceFinder
    extends SearchRequestor {
        private boolean found = false;

        protected ReferenceFinder() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.found = true;
        }

        public boolean foundMatches() {
            return this.found;
        }
    }
}

